/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.EcCurve;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.spi.NamedCurves;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

public final class JceEcPublicKey
extends JceOsslKey
implements ECPublicKey {
    static final String ALG = "EC";
    private static final Asn1BerValue ID_EC_PUBLIC_KEY = Asn1.newOid("1.2.840.10045.2.1");
    private static final int POINT_INFINITY = 0;
    private static final int UNCOMPRESSED = 4;
    private final ECPoint point;
    private final ECParameterSpec params;

    public JceEcPublicKey(Pkey pkey, ECPoint point, ECParameterSpec params, byte[] encoding) {
        super(ALG, pkey, encoding);
        this.point = point;
        this.params = params;
    }

    public JceEcPublicKey(Pkey pkey, byte[] encoding) throws InvalidKeyException {
        super(ALG, pkey, encoding);
        byte[][] coords = this.pkey.getEcPublicKey();
        this.point = new ECPoint(new BigInteger(1, coords[0]), new BigInteger(1, coords[1]));
        this.params = NamedCurves.lookup(this.pkey.getEcCurve());
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    @Override
    public ECPoint getW() {
        return this.point;
    }

    @Override
    byte[] derEncode() throws InvalidKeyException {
        EcCurve curve = NamedCurves.lookup(this.params);
        if (curve == null) {
            throw new InvalidKeyException("Unsupported ECParameterSpec");
        }
        Asn1BerValue ecPubKey = Asn1.newSequence(Asn1.newSequence(ID_EC_PUBLIC_KEY, Asn1.newOid(curve.oid())), Asn1.newBitString(JceEcPublicKey.encodePointUncompressed(this.point, this.params)));
        return ecPubKey.encodeDerOctets();
    }

    static byte[] encodePointUncompressed(ECPoint point, ECParameterSpec params) {
        if (point.equals(ECPoint.POINT_INFINITY)) {
            return new byte[]{0};
        }
        byte[] x = point.getAffineX().toByteArray();
        int xLen = x.length;
        int xOffset = 0;
        byte[] y = point.getAffineY().toByteArray();
        int yLen = y.length;
        int yOffset = 0;
        if (xLen > 0 && x[0] == 0) {
            --xLen;
            ++xOffset;
        }
        if (yLen > 0 && y[0] == 0) {
            --yLen;
            ++yOffset;
        }
        int fLen = (params.getCurve().getField().getFieldSize() + 7) / 8;
        byte[] encodedPoint = new byte[1 + fLen * 2];
        encodedPoint[0] = 4;
        System.arraycopy(x, xOffset, encodedPoint, encodedPoint.length - fLen - xLen, xLen);
        System.arraycopy(y, yOffset, encodedPoint, encodedPoint.length - yLen, yLen);
        return encodedPoint;
    }

    public String toString() {
        return "EcPublicKey: curve=" + (Object)((Object)NamedCurves.lookup(this.params)) + ",point.x=" + this.point.getAffineX() + ",point.y=" + this.point.getAffineY();
    }
}

