/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceEcPublicKey;
import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.EcCurve;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.spi.NamedCurves;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Optional;

public final class JceEcPrivateKey
extends JceOsslKey
implements ECPrivateKey {
    static final String ALG = "EC";
    private static final Asn1BerValue ID_EC_PUBLIC_KEY = Asn1.newOid("1.2.840.10045.2.1");
    private final BigInteger priv;
    private final Optional<ECPoint> point;
    private final ECParameterSpec params;

    public JceEcPrivateKey(Pkey pkey, BigInteger priv, Optional<ECPoint> point, ECParameterSpec params) {
        super(ALG, pkey);
        this.priv = priv;
        this.point = point;
        this.params = params;
    }

    public JceEcPrivateKey(Pkey pkey) throws InvalidKeyException {
        super(ALG, pkey);
        byte[] privBytes = this.pkey.getEcPrivateKey();
        try {
            this.priv = new BigInteger(1, privBytes);
        }
        finally {
            Util.clearArray(privBytes);
        }
        byte[][] coords = this.pkey.getEcPublicKey();
        this.point = coords != null ? Optional.of(new ECPoint(new BigInteger(1, coords[0]), new BigInteger(1, coords[1]))) : Optional.empty();
        this.params = NamedCurves.lookup(this.pkey.getEcCurve());
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    @Override
    public BigInteger getS() {
        return this.priv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] derEncode() throws InvalidKeyException {
        EcCurve curve = NamedCurves.lookup(this.params);
        if (curve == null) {
            throw new InvalidKeyException("Unsupported ECParameterSpec");
        }
        Asn1BerValue curveOid = Asn1.newOid(curve.oid());
        byte[] privateValue = JceEcPrivateKey.encodePrivateValue(this.priv, this.params);
        try {
            Asn1BerValue ecPrivKey = Asn1.newSequence(Asn1.newInteger(0L), Asn1.newSequence(ID_EC_PUBLIC_KEY, curveOid), Asn1.newOctetString(Asn1.newSequence(Asn1.newInteger(1L), Asn1.newOctetString(privateValue), Asn1.newExplicitTag(0, curveOid), this.point.isPresent() ? Asn1.explicit(1).newBitString(JceEcPublicKey.encodePointUncompressed(this.point.get(), this.params)) : null).encodeDer()));
            byte[] byArray = ecPrivKey.encodeDerOctets();
            return byArray;
        }
        finally {
            Util.clearArray(privateValue);
        }
    }

    private static byte[] encodePrivateValue(BigInteger priv, ECParameterSpec params) {
        int pLen = (params.getOrder().bitLength() + 7) / 8;
        byte[] privBytes = priv.toByteArray();
        if (privBytes.length != pLen) {
            byte[] buf = new byte[pLen];
            int copyLen = Math.min(privBytes.length, pLen);
            System.arraycopy(privBytes, privBytes.length - copyLen, buf, pLen - copyLen, copyLen);
            Util.clearArray(privBytes);
            privBytes = buf;
        }
        return privBytes;
    }

    @Override
    public void destroy() {
        this.pkey.free();
    }
}

