/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import com.oracle.jipher.internal.common.Cleaner;
import com.oracle.jipher.internal.common.PhantomCleanable;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class CleanerImpl
implements Runnable {
    private static Function<Cleaner, CleanerImpl> cleanerImplAccess = null;
    final PhantomCleanable<?> phantomCleanableList;
    final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static void setCleanerImplAccess(Function<Cleaner, CleanerImpl> access) {
        if (cleanerImplAccess != null) {
            throw new InternalError("cleanerImplAccess");
        }
        cleanerImplAccess = access;
    }

    static CleanerImpl getCleanerImpl(Cleaner cleaner) {
        return cleanerImplAccess.apply(cleaner);
    }

    public CleanerImpl() {
        this.phantomCleanableList = new PhantomCleanableRef();
    }

    public void start(Cleaner cleaner, ThreadFactory threadFactory) {
        if (CleanerImpl.getCleanerImpl(cleaner) != this) {
            throw new AssertionError((Object)"wrong cleaner");
        }
        new CleanerCleanable(cleaner);
        if (threadFactory == null) {
            threadFactory = InternalThreadFactory.factory();
        }
        Thread thread = threadFactory.newThread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        while (!this.phantomCleanableList.isListEmpty()) {
            try {
                Cleaner.Cleanable ref = (Cleaner.Cleanable)((Object)this.queue.remove(60000L));
                if (ref == null) continue;
                ref.clean();
            }
            catch (Throwable throwable) {}
        }
    }

    static final class CleanerCleanable
    extends PhantomCleanable<Cleaner> {
        CleanerCleanable(Cleaner cleaner) {
            super(cleaner, cleaner);
        }

        @Override
        protected void performCleanup() {
        }
    }

    static final class InternalThreadFactory
    implements ThreadFactory {
        static final ThreadFactory FACTORY = new InternalThreadFactory();
        final AtomicInteger cleanerThreadNumber = new AtomicInteger();

        InternalThreadFactory() {
        }

        static ThreadFactory factory() {
            return FACTORY;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Cleaner-" + this.cleanerThreadNumber.getAndIncrement());
        }
    }

    public static final class PhantomCleanableRef
    extends PhantomCleanable<Object> {
        private final Runnable action;

        public PhantomCleanableRef(Object obj, Cleaner cleaner, Runnable action) {
            super(obj, cleaner);
            this.action = action;
        }

        PhantomCleanableRef() {
            this.action = null;
        }

        @Override
        protected void performCleanup() {
            this.action.run();
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException("get");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear");
        }
    }
}

