/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.invoke.MethodType;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.ValueNode;

class ForeignGraphKit
extends HostedGraphKit {
    ForeignGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method, GraphProvider.Purpose purpose) {
        super(debug, providers, method, purpose);
    }

    Pair<List<ValueNode>, ValueNode> unpackArgumentsAndExtractNEP(ValueNode argumentsArray, MethodType methodType) {
        List args = this.loadArrayElements(argumentsArray, JavaKind.Object, methodType.parameterCount() + 1);
        ValueNode nep = (ValueNode)args.remove(args.size() - 1);
        return Pair.create((Object)args, (Object)nep);
    }

    List<ValueNode> unboxArguments(List<ValueNode> args, MethodType methodType) {
        assert (args.size() == methodType.parameterCount()) : args.size() + " " + methodType.parameterCount();
        for (int i = 0; i < args.size(); ++i) {
            ValueNode argument = args.get(i);
            argument = this.createUnboxing(argument, JavaKind.fromJavaClass((Class)methodType.parameterType(i)));
            args.set(i, argument);
        }
        return args;
    }

    public ValueNode boxAndReturn(ValueNode returnValue, MethodType methodType) {
        JavaKind returnKind = JavaKind.fromJavaClass((Class)methodType.returnType());
        if (returnKind.equals((Object)JavaKind.Void)) {
            return this.createReturn((ValueNode)this.createObject(null), JavaKind.Object);
        }
        ResolvedJavaType boxed = this.getMetaAccess().lookupJavaType(returnKind.toBoxedJavaClass());
        return this.createReturn(this.createBoxing(returnValue, returnKind, boxed), JavaKind.Object);
    }
}

