/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_NativeEntryPoint;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import jdk.internal.foreign.abi.ABIDescriptor;
import jdk.internal.foreign.abi.VMStorage;

public final class NativeEntryPointInfo {
    private final MethodType methodType;
    private final VMStorage[] parameterAssignments;
    private final VMStorage[] returnBuffering;
    private final boolean needsReturnBuffer;
    private final boolean capturesState;
    private final boolean needsTransition;

    private NativeEntryPointInfo(MethodType methodType, VMStorage[] cc, VMStorage[] returnBuffering, boolean needsReturnBuffer, boolean capturesState, boolean needsTransition) {
        assert (methodType.parameterCount() == cc.length);
        assert (needsReturnBuffer == returnBuffering.length > 1);
        this.methodType = methodType;
        this.parameterAssignments = cc;
        this.returnBuffering = returnBuffering;
        this.needsReturnBuffer = needsReturnBuffer;
        this.capturesState = capturesState;
        this.needsTransition = needsTransition;
    }

    public static NativeEntryPointInfo make(VMStorage[] argMoves, VMStorage[] returnMoves, MethodType methodType, boolean needsReturnBuffer, int capturedStateMask, boolean needsTransition) {
        if (returnMoves.length > 1 != needsReturnBuffer) {
            throw new AssertionError((Object)"Multiple register return, but needsReturnBuffer was false");
        }
        return new NativeEntryPointInfo(methodType, argMoves, returnMoves, needsReturnBuffer, capturedStateMask != 0, needsTransition);
    }

    public static Target_jdk_internal_foreign_abi_NativeEntryPoint makeEntryPoint(ABIDescriptor ignoreAbi, VMStorage[] argMoves, VMStorage[] returnMoves, MethodType methodType, boolean needsReturnBuffer, int capturedStateMask, boolean needsTransition) {
        NativeEntryPointInfo info = NativeEntryPointInfo.make(argMoves, returnMoves, methodType, needsReturnBuffer, capturedStateMask, needsTransition);
        long addr = ForeignFunctionsRuntime.singleton().getDowncallStubPointer(info).rawValue();
        return new Target_jdk_internal_foreign_abi_NativeEntryPoint(info.methodType(), addr, capturedStateMask);
    }

    public int callAddressIndex() {
        return this.needsReturnBuffer() ? 1 : 0;
    }

    public int captureAddressIndex() {
        if (!this.capturesCallState()) {
            throw new IllegalArgumentException(String.valueOf(this) + " does not have a capture state argument");
        }
        return this.callAddressIndex() + 1;
    }

    public MethodType methodType() {
        return this.methodType;
    }

    public boolean needsReturnBuffer() {
        return this.needsReturnBuffer;
    }

    public boolean capturesCallState() {
        return this.capturesState;
    }

    public VMStorage[] parametersAssignment() {
        return this.parameterAssignments;
    }

    public VMStorage[] returnsAssignment() {
        return this.returnBuffering;
    }

    public boolean skipsTransition() {
        return !this.needsTransition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeEntryPointInfo that = (NativeEntryPointInfo)o;
        return this.capturesState == that.capturesState && this.needsTransition == that.needsTransition && this.needsReturnBuffer == that.needsReturnBuffer && Objects.equals(this.methodType, that.methodType) && Arrays.equals(this.parameterAssignments, that.parameterAssignments) && Arrays.equals(this.returnBuffering, that.returnBuffering);
    }

    public int hashCode() {
        return Objects.hash(this.methodType, this.needsReturnBuffer, this.capturesState, this.needsTransition, Arrays.hashCode(this.parameterAssignments), Arrays.hashCode(this.returnBuffering));
    }
}

