/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JsonPrinter;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class ResourceConfiguration
extends ConfigurationBase<ResourceConfiguration, Predicate> {
    private static final String PROPERTY_BUNDLE = "java.util.PropertyResourceBundle";
    private final ConcurrentMap<ConditionalElement<String>, Pattern> addedResources = new ConcurrentHashMap<ConditionalElement<String>, Pattern>();
    private final ConcurrentMap<ConditionalElement<String>, Pattern> ignoredResources = new ConcurrentHashMap<ConditionalElement<String>, Pattern>();
    private final ConcurrentMap<ConditionalElement<String>, BundleConfiguration> bundles = new ConcurrentHashMap<ConditionalElement<String>, BundleConfiguration>();

    public ResourceConfiguration() {
    }

    public ResourceConfiguration(ResourceConfiguration other) {
        this.addedResources.putAll(other.addedResources);
        this.ignoredResources.putAll(other.ignoredResources);
        for (Map.Entry entry : other.bundles.entrySet()) {
            this.bundles.put((ConditionalElement<String>)((ConditionalElement)entry.getKey()), new BundleConfiguration((BundleConfiguration)entry.getValue()));
        }
    }

    @Override
    public ResourceConfiguration copy() {
        return new ResourceConfiguration(this);
    }

    @Override
    public void subtract(ResourceConfiguration other) {
        this.addedResources.keySet().removeAll(other.addedResources.keySet());
        this.ignoredResources.keySet().removeAll(other.ignoredResources.keySet());
        this.bundles.keySet().removeAll(other.bundles.keySet());
    }

    @Override
    protected void merge(ResourceConfiguration other) {
        this.addedResources.putAll(other.addedResources);
        this.ignoredResources.putAll(other.ignoredResources);
        this.bundles.putAll(other.bundles);
    }

    @Override
    protected void intersect(ResourceConfiguration other) {
        this.addedResources.keySet().retainAll(other.addedResources.keySet());
        this.ignoredResources.keySet().retainAll(other.ignoredResources.keySet());
        this.bundles.keySet().retainAll(other.bundles.keySet());
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.addedResources.entrySet().removeIf((? super E entry) -> predicate.testIncludedResource((ConditionalElement<String>)((ConditionalElement)entry.getKey()), (Pattern)entry.getValue()));
        this.bundles.entrySet().removeIf((? super E entry) -> predicate.testIncludedBundle((ConditionalElement<String>)((ConditionalElement)entry.getKey()), (BundleConfiguration)entry.getValue()));
    }

    @Override
    public void mergeConditional(ConfigurationCondition condition, ResourceConfiguration other) {
        for (Map.Entry entry : other.addedResources.entrySet()) {
            this.addedResources.put((ConditionalElement<String>)new ConditionalElement(condition, (Object)((String)((ConditionalElement)entry.getKey()).getElement())), (Pattern)entry.getValue());
        }
        for (Map.Entry entry : other.ignoredResources.entrySet()) {
            this.ignoredResources.put((ConditionalElement<String>)new ConditionalElement(condition, (Object)((String)((ConditionalElement)entry.getKey()).getElement())), (Pattern)entry.getValue());
        }
        for (Map.Entry entry : other.bundles.entrySet()) {
            this.bundles.put((ConditionalElement<String>)new ConditionalElement(condition, (Object)((String)((ConditionalElement)entry.getKey()).getElement())), new BundleConfiguration((BundleConfiguration)entry.getValue()));
        }
    }

    public void addResourcePattern(ConfigurationCondition condition, String pattern) {
        this.addedResources.computeIfAbsent((ConditionalElement<String>)new ConditionalElement(condition, (Object)pattern), p -> Pattern.compile((String)p.getElement()));
    }

    public void ignoreResourcePattern(ConfigurationCondition condition, String pattern) {
        this.ignoredResources.computeIfAbsent((ConditionalElement<String>)new ConditionalElement(condition, (Object)pattern), p -> Pattern.compile((String)p.getElement()));
    }

    public void addBundle(ConfigurationCondition condition, String basename, Collection<Locale> locales) {
        BundleConfiguration config = this.getOrCreateBundleConfig(condition, basename);
        for (Locale locale : locales) {
            config.locales.add(locale.toLanguageTag());
        }
    }

    private void addBundle(ConfigurationCondition condition, String baseName) {
        this.getOrCreateBundleConfig(condition, baseName);
    }

    private void addClassResourceBundle(ConfigurationCondition condition, String basename, String className) {
        this.getOrCreateBundleConfig((ConfigurationCondition)condition, (String)basename).classNames.add(className);
    }

    public void addBundle(ConfigurationCondition condition, List<String> classNames, List<String> locales, String baseName) {
        assert (classNames.size() == locales.size()) : "Each bundle should be represented by both classname and locale";
        BundleConfiguration config = this.getOrCreateBundleConfig(condition, baseName);
        for (int i = 0; i < classNames.size(); ++i) {
            String className = classNames.get(i);
            String localeTag = locales.get(i);
            if (!className.equals(PROPERTY_BUNDLE)) {
                config.classNames.add(className);
                continue;
            }
            config.locales.add(localeTag);
        }
    }

    private BundleConfiguration getOrCreateBundleConfig(ConfigurationCondition condition, String baseName) {
        ConditionalElement key = new ConditionalElement(condition, (Object)baseName);
        return this.bundles.computeIfAbsent((ConditionalElement<String>)key, cond -> new BundleConfiguration(condition, baseName));
    }

    public boolean anyResourceMatches(String s) {
        for (Pattern pattern : this.ignoredResources.values()) {
            if (!pattern.matcher(s).matches()) continue;
            return false;
        }
        for (Pattern pattern : this.addedResources.values()) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean anyBundleMatches(ConfigurationCondition condition, String bundleName) {
        return this.bundles.containsKey(new ConditionalElement(condition, (Object)bundleName));
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        writer.quote("resources").append(':').append('{').newline();
        writer.quote("includes").append(':');
        JsonPrinter.printCollection((JsonWriter)writer, this.addedResources.keySet(), (Comparator)ConditionalElement.comparator(), (p, w) -> ResourceConfiguration.conditionalElementJson((ConditionalElement<String>)p, w, "pattern"));
        if (!this.ignoredResources.isEmpty()) {
            writer.append(',').newline();
            writer.quote("excludes").append(':');
            JsonPrinter.printCollection((JsonWriter)writer, this.ignoredResources.keySet(), (Comparator)ConditionalElement.comparator(), (p, w) -> ResourceConfiguration.conditionalElementJson((ConditionalElement<String>)p, w, "pattern"));
        }
        writer.append('}').append(',').newline();
        writer.quote("bundles").append(':');
        JsonPrinter.printCollection((JsonWriter)writer, this.bundles.keySet(), (Comparator)ConditionalElement.comparator(), (p, w) -> ResourceConfiguration.printResourceBundle((BundleConfiguration)this.bundles.get(p), w));
        writer.unindent().newline().append('}');
    }

    @Override
    public ConfigurationParser createParser(boolean strictMetadata) {
        return ResourceConfigurationParser.create((boolean)strictMetadata, (ResourcesRegistry)new ParserAdapter(this), (boolean)true);
    }

    private static void printResourceBundle(BundleConfiguration config, JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        ConfigurationConditionPrintable.printConditionAttribute(config.condition, writer);
        writer.quote("name").append(':').quote(config.baseName);
        if (!config.locales.isEmpty()) {
            writer.append(',').newline().quote("locales").append(":");
            JsonPrinter.printCollection((JsonWriter)writer, config.locales, Comparator.naturalOrder(), (p, w) -> w.quote(p));
        }
        if (!config.classNames.isEmpty()) {
            writer.append(',').newline().quote("classNames").append(":");
            JsonPrinter.printCollection((JsonWriter)writer, config.classNames, Comparator.naturalOrder(), (p, w) -> w.quote(p));
        }
        writer.unindent().newline().append('}');
    }

    @Override
    public boolean isEmpty() {
        return this.addedResources.isEmpty() && this.bundles.isEmpty();
    }

    private static void conditionalElementJson(ConditionalElement<String> p, JsonWriter w, String elementName) throws IOException {
        w.append('{').indent().newline();
        ConfigurationConditionPrintable.printConditionAttribute(p.getCondition(), w);
        w.quote(elementName).append(':').quote((String)p.getElement());
        w.unindent().newline().append('}');
    }

    public static final class BundleConfiguration {
        public final ConfigurationCondition condition;
        public final String baseName;
        public final Set<String> locales = ConcurrentHashMap.newKeySet();
        public final Set<String> classNames = ConcurrentHashMap.newKeySet();

        private BundleConfiguration(ConfigurationCondition condition, String baseName) {
            this.condition = condition;
            this.baseName = baseName;
        }

        private BundleConfiguration(BundleConfiguration other) {
            this(other.condition, other.baseName);
            this.locales.addAll(other.locales);
            this.classNames.addAll(other.classNames);
        }
    }

    public static interface Predicate {
        public boolean testIncludedResource(ConditionalElement<String> var1, Pattern var2);

        public boolean testIncludedBundle(ConditionalElement<String> var1, BundleConfiguration var2);
    }

    public static class ParserAdapter
    implements ResourcesRegistry {
        private final ResourceConfiguration configuration;

        ParserAdapter(ResourceConfiguration configuration) {
            this.configuration = configuration;
        }

        public void addResources(ConfigurationCondition condition, String pattern) {
            this.configuration.addResourcePattern(condition, pattern);
        }

        public void injectResource(Module module, String resourcePath, byte[] resourceContent) {
            VMError.shouldNotReachHere((String)"Resource injection is only supported via Feature implementation");
        }

        public void ignoreResources(ConfigurationCondition condition, String pattern) {
            this.configuration.ignoreResourcePattern(condition, pattern);
        }

        public void addResourceBundles(ConfigurationCondition condition, String baseName) {
            this.configuration.addBundle(condition, baseName);
        }

        public void addResourceBundles(ConfigurationCondition condition, String basename, Collection<Locale> locales) {
            this.configuration.addBundle(condition, basename, locales);
        }

        public void addClassBasedResourceBundle(ConfigurationCondition condition, String basename, String className) {
            this.configuration.addClassResourceBundle(condition, basename, className);
        }
    }
}

