/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.FieldInfo;
import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.core.util.json.JsonPrinter;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ConfigurationType
implements JsonPrintable {
    private final ConfigurationCondition condition;
    private final String qualifiedJavaName;
    private Map<String, FieldInfo> fields;
    private Map<ConfigurationMethod, ConfigurationMemberInfo> methods;
    private boolean allDeclaredClasses;
    private boolean allRecordComponents;
    private boolean allPermittedSubclasses;
    private boolean allNestMembers;
    private boolean allSigners;
    private boolean allPublicClasses;
    private boolean allDeclaredFields;
    private boolean allPublicFields;
    private boolean unsafeAllocated;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allDeclaredMethodsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allPublicMethodsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allDeclaredConstructorsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    private ConfigurationMemberInfo.ConfigurationMemberAccessibility allPublicConstructorsAccess = ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;

    static ConfigurationType copyAndSubtract(ConfigurationType type, ConfigurationType subtractType) {
        if (type == subtractType) {
            return null;
        }
        ConfigurationType copy = new ConfigurationType(type);
        if (subtractType == null) {
            return copy;
        }
        assert (type.getCondition().equals((Object)subtractType.getCondition()));
        assert (type.getQualifiedJavaName().equals(subtractType.getQualifiedJavaName()));
        copy.removeAll(subtractType);
        return copy.isEmpty() ? null : copy;
    }

    static ConfigurationType copyAndIntersect(ConfigurationType type, ConfigurationType toIntersect) {
        ConfigurationType copy = new ConfigurationType(type);
        assert (type.getCondition().equals((Object)toIntersect.getCondition()));
        assert (type.getQualifiedJavaName().equals(toIntersect.getQualifiedJavaName()));
        copy.intersectWith(toIntersect);
        return copy;
    }

    static ConfigurationType copyAndMerge(ConfigurationType type, ConfigurationType toMerge) {
        ConfigurationType copy = new ConfigurationType(type);
        copy.mergeFrom(toMerge);
        return copy;
    }

    public ConfigurationType(ConfigurationCondition condition, String qualifiedJavaName) {
        assert (qualifiedJavaName.indexOf(47) == -1) : "Requires qualified Java name, not internal representation";
        assert (!qualifiedJavaName.startsWith("[")) : "Requires Java source array syntax, for example java.lang.String[]";
        this.condition = condition;
        this.qualifiedJavaName = qualifiedJavaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurationType(ConfigurationType other, ConfigurationCondition condition) {
        ConfigurationType configurationType = other;
        synchronized (configurationType) {
            this.qualifiedJavaName = other.qualifiedJavaName;
            this.condition = condition;
            this.mergeFrom(other);
        }
    }

    ConfigurationType(ConfigurationType other) {
        this(other, other.condition);
    }

    void mergeFrom(ConfigurationType other) {
        assert (this.condition.equals((Object)other.condition));
        assert (this.qualifiedJavaName.equals(other.qualifiedJavaName));
        this.mergeFlagsFrom(other);
        this.mergeFieldsFrom(other);
        this.mergeMethodsFrom(other);
    }

    private void mergeFlagsFrom(ConfigurationType other) {
        this.setFlagsFromOther(other, (our, their) -> our != false || their != false, ConfigurationMemberInfo.ConfigurationMemberAccessibility::combine);
    }

    private void mergeFieldsFrom(ConfigurationType other) {
        if (other.fields != null) {
            if (this.fields == null) {
                this.fields = new HashMap<String, FieldInfo>();
            }
            for (Map.Entry<String, FieldInfo> fieldInfoEntry : other.fields.entrySet()) {
                this.fields.compute(fieldInfoEntry.getKey(), (key, value) -> {
                    if (value == null) {
                        return (FieldInfo)fieldInfoEntry.getValue();
                    }
                    return value.newMergedWith((FieldInfo)fieldInfoEntry.getValue());
                });
            }
        }
        this.maybeRemoveFields(this.allDeclaredFields, this.allPublicFields);
    }

    private void maybeRemoveFields(boolean hasAllDeclaredFields, boolean hasAllPublicFields) {
        if (hasAllDeclaredFields) {
            this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
        }
        if (hasAllPublicFields) {
            this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC);
        }
    }

    private void mergeMethodsFrom(ConfigurationType other) {
        if (other.methods != null) {
            if (this.methods == null) {
                this.methods = new HashMap<ConfigurationMethod, ConfigurationMemberInfo>();
            }
            for (Map.Entry<ConfigurationMethod, ConfigurationMemberInfo> methodEntry : other.methods.entrySet()) {
                this.methods.compute(methodEntry.getKey(), (key, value) -> {
                    if (value != null) {
                        return value.intersect((ConfigurationMemberInfo)methodEntry.getValue());
                    }
                    return (ConfigurationMemberInfo)methodEntry.getValue();
                });
            }
        }
        this.maybeRemoveMethods(this.allDeclaredMethodsAccess, this.allPublicMethodsAccess, this.allDeclaredConstructorsAccess, this.allPublicConstructorsAccess);
    }

    private void maybeRemoveMethods(ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllDeclaredMethods, ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllPublicMethods, ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllDeclaredConstructors, ConfigurationMemberInfo.ConfigurationMemberAccessibility hasAllPublicConstructors) {
        if (hasAllDeclaredMethods != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, hasAllDeclaredMethods, false);
        }
        if (hasAllDeclaredConstructors != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, hasAllDeclaredConstructors, true);
        }
        if (hasAllPublicMethods != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, hasAllPublicMethods, false);
        }
        if (hasAllPublicConstructors != ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE) {
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, hasAllPublicConstructors, true);
        }
    }

    private void intersectWith(ConfigurationType other) {
        this.intersectFlags(other);
        this.intersectFields(other);
        this.intersectMethods(other);
    }

    private void intersectFlags(ConfigurationType other) {
        this.setFlagsFromOther(other, (our, their) -> our != false && their != false, ConfigurationMemberInfo.ConfigurationMemberAccessibility::intersect);
    }

    private void intersectFields(ConfigurationType other) {
        if (this.fields != null) {
            if (other.fields != null) {
                this.fields.keySet().retainAll(other.fields.keySet());
                this.fields.replaceAll((key, value) -> value.newIntersectedWith(other.fields.get(key)));
            } else {
                this.fields = null;
            }
        }
    }

    private void intersectMethods(ConfigurationType other) {
        if (this.methods != null) {
            if (other.methods != null) {
                this.methods.keySet().retainAll(other.methods.keySet());
            } else {
                this.methods = null;
            }
        }
    }

    private void removeAll(ConfigurationType other) {
        assert (this.condition.equals((Object)other.condition));
        assert (this.qualifiedJavaName.equals(other.qualifiedJavaName));
        this.removeFlags(other);
        this.removeFields(other);
        this.removeMethods(other);
    }

    private void removeFlags(ConfigurationType other) {
        this.setFlagsFromOther(other, (our, their) -> our != false && their == false, ConfigurationMemberInfo.ConfigurationMemberAccessibility::remove);
    }

    private void removeFields(ConfigurationType other) {
        this.maybeRemoveFields(this.allDeclaredFields || other.allDeclaredFields, this.allPublicFields || other.allPublicFields);
        if (this.fields != null && other.fields != null) {
            for (Map.Entry<String, FieldInfo> fieldInfoEntry : other.fields.entrySet()) {
                this.fields.computeIfPresent(fieldInfoEntry.getKey(), (key, value) -> value.newWithDifferencesFrom((FieldInfo)fieldInfoEntry.getValue()));
            }
            if (this.fields.isEmpty()) {
                this.fields = null;
            }
        }
    }

    private void removeMethods(ConfigurationType other) {
        this.maybeRemoveMethods(this.allDeclaredMethodsAccess.combine(other.allDeclaredMethodsAccess), this.allPublicMethodsAccess.combine(other.allPublicMethodsAccess), this.allDeclaredConstructorsAccess.combine(other.allDeclaredConstructorsAccess), this.allPublicConstructorsAccess.combine(other.allPublicConstructorsAccess));
        if (this.methods != null && other.methods != null) {
            this.methods.entrySet().removeAll(other.methods.entrySet());
            if (this.methods.isEmpty()) {
                this.methods = null;
            }
        }
    }

    private void setFlagsFromOther(ConfigurationType other, BiPredicate<Boolean, Boolean> flagPredicate, BiFunction<ConfigurationMemberInfo.ConfigurationMemberAccessibility, ConfigurationMemberInfo.ConfigurationMemberAccessibility, ConfigurationMemberInfo.ConfigurationMemberAccessibility> accessCombiner) {
        this.allDeclaredClasses = flagPredicate.test(this.allDeclaredClasses, other.allDeclaredClasses);
        this.allRecordComponents = flagPredicate.test(this.allRecordComponents, other.allRecordComponents);
        this.allPermittedSubclasses = flagPredicate.test(this.allPermittedSubclasses, other.allPermittedSubclasses);
        this.allNestMembers = flagPredicate.test(this.allNestMembers, other.allNestMembers);
        this.allSigners = flagPredicate.test(this.allSigners, other.allSigners);
        this.allPublicClasses = flagPredicate.test(this.allPublicClasses, other.allPublicClasses);
        this.allDeclaredFields = flagPredicate.test(this.allDeclaredFields, other.allDeclaredFields);
        this.allPublicFields = flagPredicate.test(this.allPublicFields, other.allPublicFields);
        this.unsafeAllocated = flagPredicate.test(this.unsafeAllocated, other.unsafeAllocated);
        this.allDeclaredMethodsAccess = accessCombiner.apply(this.allDeclaredMethodsAccess, other.allDeclaredMethodsAccess);
        this.allPublicMethodsAccess = accessCombiner.apply(this.allPublicMethodsAccess, other.allPublicMethodsAccess);
        this.allDeclaredConstructorsAccess = accessCombiner.apply(this.allDeclaredConstructorsAccess, other.allDeclaredConstructorsAccess);
        this.allPublicConstructorsAccess = accessCombiner.apply(this.allPublicConstructorsAccess, other.allPublicConstructorsAccess);
    }

    private boolean isEmpty() {
        return this.methods == null && this.fields == null && this.allFlagsFalse();
    }

    private boolean allFlagsFalse() {
        return !this.allDeclaredClasses && !this.allRecordComponents && !this.allPermittedSubclasses && !this.allNestMembers && !this.allSigners && !this.allPublicClasses && !this.allDeclaredFields && !this.allPublicFields && this.allDeclaredMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allPublicMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allDeclaredConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE && this.allPublicConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.NONE;
    }

    public String getQualifiedJavaName() {
        return this.qualifiedJavaName;
    }

    public synchronized void addField(String name, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, boolean finalButWritable) {
        if (!finalButWritable && (declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED) && this.allDeclaredFields || declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC) && this.allPublicFields)) {
            this.fields = ConfigurationType.maybeRemove(this.fields, map -> {
                FieldInfo fieldInfo = (FieldInfo)map.get(name);
                if (fieldInfo != null && !fieldInfo.isFinalButWritable()) {
                    map.remove(name);
                }
            });
            return;
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, FieldInfo>();
        }
        this.fields.compute(name, (k, v) -> v != null ? FieldInfo.get(v.getKind().intersect(declaration), v.isFinalButWritable() || finalButWritable) : FieldInfo.get(declaration, finalButWritable));
    }

    public void addMethodsWithName(String name, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        this.addMethod(name, null, declaration, accessibility);
    }

    public void addMethod(String name, String internalSignature, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration) {
        this.addMethod(name, internalSignature, declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
    }

    public synchronized void addMethod(String name, String internalSignature, ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        boolean matchesAllSignatures;
        ConfigurationMemberInfo kind = ConfigurationMemberInfo.get(declaration, accessibility);
        boolean bl = matchesAllSignatures = internalSignature == null;
        if (ConfigurationMethod.isConstructorName(name) ? this.hasAllConstructors(declaration, accessibility) : this.hasAllMethods(declaration, accessibility)) {
            if (!matchesAllSignatures) {
                if (accessibility == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED) {
                    this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.remove(new ConfigurationMethod(name, internalSignature)));
                } else if (accessibility == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED) {
                    this.methods = ConfigurationType.maybeRemove(this.methods, map -> {
                        ConfigurationMethod method = new ConfigurationMethod(name, internalSignature);
                        if (map.containsKey(method) && ((ConfigurationMemberInfo)map.get(method)).getAccessibility() == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED) {
                            map.remove(method);
                        }
                    });
                }
            }
            return;
        }
        if (this.methods == null) {
            this.methods = new HashMap<ConfigurationMethod, ConfigurationMemberInfo>();
        }
        ConfigurationMethod method = new ConfigurationMethod(name, internalSignature);
        if (matchesAllSignatures) {
            this.methods.compute(method, (k, v) -> v != null ? kind.union((ConfigurationMemberInfo)v) : kind);
            this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.entrySet().removeIf(entry -> name.equals(((ConfigurationMethod)entry.getKey()).getName()) && kind.includes((ConfigurationMemberInfo)entry.getValue()) && !method.equals(entry.getKey())));
        } else {
            this.methods.compute(method, (k, v) -> v != null ? kind.intersect((ConfigurationMemberInfo)v) : kind);
        }
        assert (this.methods.containsKey(method));
    }

    private boolean hasAllConstructors(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        return declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED) && this.allDeclaredConstructorsAccess.includes(accessibility) || declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC) && this.allPublicConstructorsAccess.includes(accessibility);
    }

    private boolean hasAllMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        return declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED) && this.allDeclaredMethodsAccess.includes(accessibility) || declaration.includes(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC) && this.allPublicMethodsAccess.includes(accessibility);
    }

    public synchronized void setAllDeclaredClasses() {
        this.allDeclaredClasses = true;
    }

    public synchronized void setAllRecordComponents() {
        this.allRecordComponents = true;
    }

    public synchronized void setAllPermittedSubclasses() {
        this.allPermittedSubclasses = true;
    }

    public synchronized void setAllNestMembers() {
        this.allNestMembers = true;
    }

    public synchronized void setAllSigners() {
        this.allSigners = true;
    }

    public synchronized void setAllPublicClasses() {
        this.allPublicClasses = true;
    }

    public void setUnsafeAllocated() {
        this.unsafeAllocated = true;
    }

    public synchronized void setAllDeclaredFields() {
        this.allDeclaredFields = true;
        this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
    }

    public synchronized void setAllPublicFields() {
        this.allPublicFields = true;
        this.removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC);
    }

    public synchronized void setAllDeclaredMethods(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allDeclaredMethodsAccess.includes(accessibility)) {
            this.allDeclaredMethodsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, accessibility, false);
        }
    }

    public synchronized void setAllPublicMethods(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allPublicMethodsAccess.includes(accessibility)) {
            this.allPublicMethodsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, accessibility, false);
        }
    }

    public synchronized void setAllDeclaredConstructors(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allDeclaredConstructorsAccess.includes(accessibility)) {
            this.allDeclaredConstructorsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, accessibility, true);
        }
    }

    public synchronized void setAllPublicConstructors(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        if (!this.allPublicConstructorsAccess.includes(accessibility)) {
            this.allPublicConstructorsAccess = accessibility;
            this.removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC, accessibility, true);
        }
    }

    public synchronized void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        ConfigurationConditionPrintable.printConditionAttribute(this.condition, writer);
        writer.quote("name").append(':').quote(this.qualifiedJavaName);
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allDeclaredFields, "allDeclaredFields");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allPublicFields, "allPublicFields");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allDeclaredMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allDeclaredMethods");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allPublicMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allPublicMethods");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allDeclaredConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allDeclaredConstructors");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allPublicConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED, "allPublicConstructors");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allDeclaredClasses, "allDeclaredClasses");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allRecordComponents, "allRecordComponents");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allPermittedSubclasses, "allPermittedSubclasses");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allNestMembers, "allNestMembers");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allSigners, "allSigners");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allPublicClasses, "allPublicClasses");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allDeclaredMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED, "queryAllDeclaredMethods");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allPublicMethodsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED, "queryAllPublicMethods");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allDeclaredConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED, "queryAllDeclaredConstructors");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.allPublicConstructorsAccess == ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED, "queryAllPublicConstructors");
        ConfigurationType.optionallyPrintJsonBoolean(writer, this.unsafeAllocated, "unsafeAllocated");
        if (this.fields != null) {
            writer.append(',').newline().quote("fields").append(':');
            JsonPrinter.printCollection((JsonWriter)writer, this.fields.entrySet(), Map.Entry.comparingByKey(), ConfigurationType::printField);
        }
        if (this.methods != null) {
            Set<ConfigurationMethod> queriedMethods;
            Set<ConfigurationMethod> accessedMethods = this.getMethodsByAccessibility(ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
            if (!accessedMethods.isEmpty()) {
                writer.append(',').newline().quote("methods").append(':');
                JsonPrinter.printCollection((JsonWriter)writer, accessedMethods, Comparator.comparing(ConfigurationMethod::getName).thenComparing(Comparator.nullsFirst(Comparator.comparing(ConfigurationMethod::getInternalSignature))), JsonPrintable::printJson);
            }
            if (!(queriedMethods = this.getMethodsByAccessibility(ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED)).isEmpty()) {
                writer.append(',').newline().quote("queriedMethods").append(':');
                JsonPrinter.printCollection((JsonWriter)writer, queriedMethods, Comparator.comparing(ConfigurationMethod::getName).thenComparing(Comparator.nullsFirst(Comparator.comparing(ConfigurationMethod::getInternalSignature))), JsonPrintable::printJson);
            }
        }
        writer.unindent().newline().append('}');
    }

    private Set<ConfigurationMethod> getMethodsByAccessibility(ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility) {
        return this.methods.entrySet().stream().filter(e -> ((ConfigurationMemberInfo)e.getValue()).getAccessibility() == accessibility).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static void printField(Map.Entry<String, FieldInfo> entry, JsonWriter w) throws IOException {
        w.append('{').quote("name").append(':').quote(entry.getKey());
        if (entry.getValue().isFinalButWritable()) {
            w.append(", ").quote("allowWrite").append(':').append("true");
        }
        w.append('}');
    }

    private static void optionallyPrintJsonBoolean(JsonWriter writer, boolean predicate, String attribute) throws IOException {
        if (predicate) {
            writer.append(',').newline().quote(attribute).append(":true");
        }
    }

    private void removeFields(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration) {
        this.fields = ConfigurationType.maybeRemove(this.fields, map -> map.values().removeIf(v -> declaration.includes(v.getKind())));
    }

    private void removeMethods(ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration, ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility, boolean constructors) {
        ConfigurationMemberInfo kind = ConfigurationMemberInfo.get(declaration, accessibility);
        this.methods = ConfigurationType.maybeRemove(this.methods, map -> map.entrySet().removeIf(entry -> ((ConfigurationMethod)entry.getKey()).isConstructor() == constructors && kind.includes((ConfigurationMemberInfo)entry.getValue())));
    }

    private static <T, S> Map<T, S> maybeRemove(Map<T, S> fromMap, Consumer<Map<T, S>> action) {
        Map<T, S> map = fromMap;
        if (map != null) {
            action.accept(map);
            if (map.isEmpty()) {
                map = null;
            }
        }
        return map;
    }

    ConfigurationCondition getCondition() {
        return this.condition;
    }

    public static final class TestBackdoor {
        public static ConfigurationMemberInfo getMethodInfoIfPresent(ConfigurationType type, ConfigurationMethod method) {
            return type.methods == null ? null : type.methods.get(method);
        }

        public static FieldInfo getFieldInfoIfPresent(ConfigurationType type, String fieldName) {
            return type.fields == null ? null : type.fields.get(fieldName);
        }

        public static boolean haveAllDeclaredFields(ConfigurationType self) {
            return self.allDeclaredFields;
        }

        public static boolean haveAllPublicFields(ConfigurationType type) {
            return type.allPublicFields;
        }

        public static boolean haveAllDeclaredClasses(ConfigurationType type) {
            return type.allDeclaredClasses;
        }

        public static boolean haveAllRecordComponents(ConfigurationType type) {
            return type.allRecordComponents;
        }

        public static boolean haveAllPermittedSubclasses(ConfigurationType type) {
            return type.allPermittedSubclasses;
        }

        public static boolean haveAllNestMembers(ConfigurationType type) {
            return type.allNestMembers;
        }

        public static boolean haveAllSigners(ConfigurationType type) {
            return type.allSigners;
        }

        public static boolean haveAllPublicClasses(ConfigurationType type) {
            return type.allPublicClasses;
        }

        public static ConfigurationMemberInfo.ConfigurationMemberAccessibility getAllDeclaredConstructors(ConfigurationType type) {
            return type.allDeclaredConstructorsAccess;
        }

        public static ConfigurationMemberInfo.ConfigurationMemberAccessibility getAllPublicConstructors(ConfigurationType type) {
            return type.allPublicConstructorsAccess;
        }

        private TestBackdoor() {
        }
    }
}

