/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;

public abstract class ConfigurationCommand {
    protected static final int VALUE_INDEX = 1;
    protected static final int OPTION_INDEX = 0;
    protected static final int OPTION_VALUE_LENGTH = 2;
    protected static final String OPTION_VALUE_SEP = "=";
    protected static final String BAD_OPTION_FORMAT = "Format is not valid: %s. Options should be in format --<option>=<value>. ";

    public abstract String getName();

    public abstract void apply(Iterator<String> var1) throws IOException;

    public String getUsage() {
        return "native-image-configure " + this.getName() + " [options]";
    }

    public final String getDescription() {
        return this.getName() + this.getDescription0();
    }

    protected abstract String getDescription0();

    protected static Path requirePath(String current, String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new ConfigurationUsageException("Argument must be provided for: " + current);
        }
        return Paths.get(value, new String[0]);
    }

    protected static URI requirePathUri(String current, String value) {
        return ConfigurationCommand.requirePath(current, value).toUri();
    }

    protected static Path getOrCreateDirectory(String current, String value) throws IOException {
        Path directory = ConfigurationCommand.requirePath(current, value);
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectory(directory, new FileAttribute[0]);
        } else if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new NoSuchFileException(value);
        }
        return directory;
    }

    protected static Path getOrCreateFile(String option, String value) throws IOException {
        Path file = ConfigurationCommand.requirePath(option, value);
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        } else if (Files.isDirectory(file, new LinkOption[0])) {
            throw new ConfigurationUsageException(option + " expects a path to a file, but directory path is given: " + value + ". Please use a path to a file.");
        }
        return file;
    }
}

