/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AccessFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.PointsToAnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public abstract class StoreFieldTypeFlow
extends AccessFieldTypeFlow {
    protected StoreFieldTypeFlow(BytecodePosition storeLocation, AnalysisField field) {
        super(storeLocation, field);
    }

    protected StoreFieldTypeFlow(StoreFieldTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState newState) {
        return this.declaredTypeFilter(bb, newState);
    }

    public static class StoreInstanceFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final TypeFlow<?> valueFlow;
        private TypeFlow<?> objectFlow;
        private boolean isContextInsensitive;

        public StoreInstanceFieldTypeFlow(BytecodePosition storeLocation, AnalysisField field, TypeFlow<?> objectFlow) {
            this(storeLocation, field, null, objectFlow);
        }

        public StoreInstanceFieldTypeFlow(BytecodePosition storeLocation, AnalysisField field, TypeFlow<?> valueFlow, TypeFlow<?> objectFlow) {
            super(storeLocation, field);
            this.valueFlow = valueFlow;
            this.objectFlow = objectFlow;
        }

        StoreInstanceFieldTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, StoreInstanceFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = original.valueFlow != null ? methodFlows.lookupCloneOf(bb, original.valueFlow) : null;
            this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
        }

        public void markAsContextInsensitive() {
            this.isContextInsensitive = true;
        }

        @Override
        public boolean isContextInsensitive() {
            return this.isContextInsensitive;
        }

        public StoreInstanceFieldTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new StoreInstanceFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public TypeFlow<?> receiver() {
            return this.objectFlow;
        }

        @Override
        public void setObserved(TypeFlow<?> newObjectFlow) {
            this.objectFlow = newObjectFlow;
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            TypeState objectState = this.objectFlow.getState();
            objectState = this.filterObjectState(bb, objectState);
            for (AnalysisObject receiver : objectState.objects(bb)) {
                FieldTypeFlow fieldFlow = receiver.getInstanceFieldFlow(bb, this.objectFlow, (BytecodePosition)this.source, this.field, true);
                this.addUse(bb, fieldFlow);
            }
        }

        @Override
        public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
            this.objectFlow.removeObserver(this);
            this.valueFlow.removeUse(this);
            StoreFieldTypeFlow contextInsensitiveStore = ((PointsToAnalysisField)this.field).initAndGetContextInsensitiveStore(bb, (BytecodePosition)this.source);
            this.valueFlow.addUse(bb, contextInsensitiveStore);
        }

        @Override
        public String toString() {
            return "StoreInstanceFieldTypeFlow<" + String.valueOf(this.getState()) + ">";
        }
    }

    public static class StoreStaticFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final FieldTypeFlow fieldFlow;
        private final TypeFlow<?> valueFlow;

        StoreStaticFieldTypeFlow(BytecodePosition storeLocation, AnalysisField field, TypeFlow<?> valueFlow, FieldTypeFlow fieldFlow) {
            super(storeLocation, field);
            this.valueFlow = valueFlow;
            this.fieldFlow = fieldFlow;
        }

        StoreStaticFieldTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, StoreStaticFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
            this.fieldFlow = original.fieldFlow;
        }

        public StoreFieldTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new StoreStaticFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void initFlow(PointsToAnalysis bb) {
            this.addUse(bb, this.fieldFlow);
        }

        @Override
        public boolean needsInitialization() {
            return true;
        }

        @Override
        public String toString() {
            return "StoreStaticFieldTypeFlow<" + String.valueOf(this.getState()) + ">";
        }
    }
}

