/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver.launcher.configuration;

import com.oracle.svm.driver.launcher.configuration.BundleConfigurationParser;
import com.oracle.svm.driver.launcher.json.BundleJSONParserException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;

public class BundlePathMapParser
extends BundleConfigurationParser {
    private static final String substitutionMapSrcField = "src";
    private static final String substitutionMapDstField = "dst";
    private final Map<Path, Path> pathMap;

    public BundlePathMapParser(Map<Path, Path> pathMap) {
        this.pathMap = pathMap;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        for (Object rawEntry : BundlePathMapParser.asList(json, "Expected a list of path substitution objects")) {
            Map<String, Object> entry = BundlePathMapParser.asMap(rawEntry, "Expected a substitution object");
            Object srcPathString = entry.get(substitutionMapSrcField);
            if (srcPathString == null) {
                throw new BundleJSONParserException("Expected src-field in substitution object");
            }
            Object dstPathString = entry.get(substitutionMapDstField);
            if (dstPathString == null) {
                throw new BundleJSONParserException("Expected dst-field in substitution object");
            }
            this.pathMap.put(Path.of(srcPathString.toString(), new String[0]), Path.of(dstPathString.toString(), new String[0]));
        }
    }
}

