/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.cai.a;
import com.oracle.svm.enterprise.hosted.pgo.d;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;

public class HotMethodDuplicationPhase<C>
extends BasePhase<C> {
    private static final AtomicInteger uO = new AtomicInteger();
    private final Function<HostedMethod, d.b> uP;

    public HotMethodDuplicationPhase(Function<HostedMethod, d.b> function) {
        this.uP = function;
    }

    protected void run(StructuredGraph structuredGraph, C c2) {
        assert (structuredGraph.globalProfileProvider().hotCaller()) : "Should not run on cold compilation units";
        b b2 = new b(structuredGraph);
        d.b b3 = this.uP.apply((HostedMethod)structuredGraph.method());
        HotMethodDuplicationPhase.b(structuredGraph, invoke -> {
            HostedMethod hostedMethod;
            NodeSourcePosition nodeSourcePosition = FrameState.toSourcePosition((FrameState)invoke.stateDuring());
            d.b b4 = b3.a((BytecodePosition)nodeSourcePosition, (ResolvedJavaMethod)(hostedMethod = (HostedMethod)invoke.getTargetMethod()));
            if (b4 == null || !b4.eV()) {
                return;
            }
            HostedMethod hostedMethod2 = HotMethodDuplicationPhase.a(b2, (BytecodePosition)nodeSourcePosition, hostedMethod, b4);
            assert (invoke.callTarget() != null);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)hostedMethod2);
        });
    }

    private static HostedMethod a(b b2, BytecodePosition bytecodePosition, HostedMethod hostedMethod, d.b b3) {
        HostedMethod hostedMethod2;
        if (((Boolean)c.uZ.getValue(b2.uR.getOptions())).booleanValue() && b3.eW() && (hostedMethod2 = HotMethodDuplicationPhase.a(b3, hostedMethod)) != null) {
            HotMethodDuplicationPhase.a(b2, hostedMethod2, "Reusing method");
            return hostedMethod2;
        }
        hostedMethod2 = b2.a(hostedMethod, bytecodePosition);
        HotMethodDuplicationPhase.a(b2, hostedMethod2, "Duplicated method");
        return hostedMethod2;
    }

    private static void a(b b2, HostedMethod hostedMethod, String string) {
        if (((Boolean)c.uY.getValue(b2.uR.getOptions())).booleanValue()) {
            ResolvedJavaMethod resolvedJavaMethod = b2.uR.method();
            b2.uR.getDebug().log("[HotMethodDuplicationPhase] %s: %s called from %s", (Object)string, (Object)hostedMethod.format("%h.%n"), (Object)resolvedJavaMethod.format("%h.%n"));
        }
    }

    private static HostedMethod a(d.b b2, HostedMethod hostedMethod) {
        for (d.b b3 = b2; b3 != null; b3 = b3.eU()) {
            d.c c2 = (d.c)b3;
            HostedMethod hostedMethod2 = ((a.a)c2.eX()).dx();
            if (hostedMethod2 == null || !Objects.equals(hostedMethod2.wrapped, hostedMethod.wrapped)) continue;
            return hostedMethod2;
        }
        return null;
    }

    private static void b(StructuredGraph structuredGraph, Consumer<Invoke> consumer) {
        for (Node node : structuredGraph.getNodes()) {
            Invoke invoke;
            if (!(node instanceof Invoke) || !(invoke = (Invoke)node).getInvokeKind().isDirect() || invoke.getTargetMethod() == null) continue;
            consumer.accept(invoke);
        }
    }

    private static final class b {
        private final StructuredGraph uR;
        private final Map<a, HostedMethod> uS = new HashMap<a, HostedMethod>();
        private HostedMethod uT;
        private HostedMethod uU;
        private Map<Object, Object> uV;

        private b(StructuredGraph structuredGraph) {
            this.uR = structuredGraph;
        }

        private HostedMethod a(HostedMethod hostedMethod, BytecodePosition bytecodePosition) {
            return this.uS.computeIfAbsent(new a(bytecodePosition, hostedMethod.wrapped), a2 -> this.w(hostedMethod));
        }

        private HostedMethod w(HostedMethod hostedMethod) {
            this.uT = hostedMethod;
            this.uU = hostedMethod.getOrCreateMultiMethod((MultiMethod.MultiMethodKey)new com.oracle.svm.enterprise.hosted.phases.HotMethodDuplicationPhase$a());
            this.uV = new IdentityHashMap<Object, Object>();
            this.uU.compilationInfo.setCompileOptions(new OptionValues(hostedMethod.compilationInfo.getCompileOptions().getMap()));
            EncodedGraph encodedGraph = this.a(hostedMethod.compilationInfo.getCompilationGraph().getEncodedGraph());
            this.uU.compilationInfo.encodeGraph(this.a(encodedGraph, (ResolvedJavaMethod)this.uU));
            return this.uU;
        }

        private EncodedGraph a(EncodedGraph encodedGraph) {
            Object[] objectArray = encodedGraph.getObjects();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = this.q(objectArray[i2]);
            }
            return new EncodedGraph(Arrays.copyOf(encodedGraph.getEncoding(), encodedGraph.getEncoding().length), encodedGraph.getStartOffset(), objectArray2, Arrays.copyOf(encodedGraph.getNodeClasses(), encodedGraph.getNodeClasses().length), encodedGraph.getAssumptions(), encodedGraph.getInlinedMethods(), encodedGraph.hasUnsafeAccess(), encodedGraph.trackNodeSourcePosition());
        }

        private StructuredGraph a(EncodedGraph encodedGraph, ResolvedJavaMethod resolvedJavaMethod) {
            DebugContext debugContext = this.uR.getDebug();
            StructuredGraph structuredGraph = new StructuredGraph.Builder(this.uR.getOptions(), debugContext).method(resolvedJavaMethod).recordInlinedMethods(false).trackNodeSourcePosition(encodedGraph.trackNodeSourcePosition()).compilationId((CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID).build();
            try (DebugContext.Scope scope = debugContext.scope((Object)"HotMethodDuplicationPhase#decodeGraph", (Object)structuredGraph, (Object)resolvedJavaMethod);){
                new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, structuredGraph).decode(encodedGraph);
            }
            catch (Throwable throwable) {
                throw debugContext.handle(throwable);
            }
            return structuredGraph;
        }

        private Object q(Object object) {
            if (object == null) {
                return null;
            }
            return this.uV.computeIfAbsent(object, this::r);
        }

        private ResolvedJavaMethod d(ResolvedJavaMethod resolvedJavaMethod) {
            if (Objects.equals(resolvedJavaMethod, this.uT)) {
                return this.uU;
            }
            return (ResolvedJavaMethod)this.q(resolvedJavaMethod);
        }

        private Object r(Object object) {
            if (object instanceof Node) {
                throw VMError.shouldNotReachHere((String)"Must not replace a Graal graph nodes, only data objects referenced from a node");
            }
            if (object.getClass() == ResolvedJavaMethodBytecode.class) {
                ResolvedJavaMethodBytecode resolvedJavaMethodBytecode = (ResolvedJavaMethodBytecode)object;
                HostedMethod hostedMethod = (HostedMethod)this.q(resolvedJavaMethodBytecode.getMethod());
                return new ResolvedJavaMethodBytecode(this.d((ResolvedJavaMethod)hostedMethod), resolvedJavaMethodBytecode.getOrigin());
            }
            if (object.getClass() == SubstrateMethodPointerConstant.class) {
                SubstrateMethodPointerConstant substrateMethodPointerConstant = (SubstrateMethodPointerConstant)object;
                MethodPointer methodPointer = substrateMethodPointerConstant.pointer();
                ResolvedJavaMethod resolvedJavaMethod = methodPointer.getMethod();
                ResolvedJavaMethod resolvedJavaMethod2 = this.d(resolvedJavaMethod);
                return new SubstrateMethodPointerConstant(new MethodPointer(resolvedJavaMethod2));
            }
            if (object.getClass() == NodeSourcePosition.class) {
                NodeSourcePosition nodeSourcePosition = (NodeSourcePosition)object;
                NodeSourcePosition nodeSourcePosition2 = (NodeSourcePosition)this.q(nodeSourcePosition.getCaller());
                ResolvedJavaMethod resolvedJavaMethod = this.d(nodeSourcePosition.getMethod());
                return new NodeSourcePosition(nodeSourcePosition.getSourceLanguage(), nodeSourcePosition2, resolvedJavaMethod, nodeSourcePosition.getBCI(), nodeSourcePosition.getMarker());
            }
            return object;
        }

        private static final class a {
            final BytecodePosition uW;
            final AnalysisMethod uX;

            a(BytecodePosition bytecodePosition, AnalysisMethod analysisMethod) {
                this.uW = bytecodePosition;
                this.uX = analysisMethod;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                a a2 = (a)object;
                return Objects.equals(this.uW, a2.uW) && Objects.equals(this.uX, a2.uX);
            }

            public int hashCode() {
                return Objects.hash(this.uW, this.uX);
            }
        }
    }

    public static class c {
        public static final OptionKey<Boolean> uY = new OptionKey((Object)false);
        public static final OptionKey<Boolean> uZ = new OptionKey((Object)true);
    }

    private static final class a
    implements MultiMethod.MultiMethodKey {
        final int uQ = uO.getAndIncrement();

        private a() {
        }

        public String toString() {
            return "Hot_Method_Key_" + this.uQ;
        }
    }
}

