/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.amd64;

import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.InvokeTarget;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.options.OptionValues;

public class g
extends AMD64MacroAssembler {
    private static final int cq = -98693133;
    private final boolean cr;

    public g(TargetDescription targetDescription) {
        super(targetDescription);
        assert (SubstrateControlFlowIntegrity.useSoftwareCFI()) : "Software CFI support expected";
        this.cr = SubstrateControlFlowIntegrity.singleton().getCFIMode() == SubstrateControlFlowIntegrity.CFIOptions.SW;
    }

    public g(TargetDescription targetDescription, OptionValues optionValues, boolean bl2) {
        super(targetDescription, optionValues, bl2);
        assert (SubstrateControlFlowIntegrity.useSoftwareCFI()) : "Software CFI support expected";
        this.cr = SubstrateControlFlowIntegrity.singleton().getCFIMode() == SubstrateControlFlowIntegrity.CFIOptions.SW;
    }

    private void a(Register register) {
        Register register2 = register.equals((Object)AMD64.r10) ? AMD64.r11 : AMD64.r10;
        Label label = new Label();
        this.push(register2);
        this.movl(register2, new AMD64Address(register, 0));
        this.addl(register2, 98693133);
        this.jcc(AMD64Assembler.ConditionFlag.Zero, label);
        this.int3();
        this.bind(label);
        this.lfence();
        this.pop(register2);
    }

    public void jmp(Register register) {
        this.a(register);
        super.jmp(register);
    }

    public void b(Register register) {
        super.jmp(register);
    }

    public void jmp(AMD64Address aMD64Address) {
        throw VMError.shouldNotReachHere((String)"No memory-indirect jumps with software CFI");
    }

    public void ret(int n2) {
        throw VMError.shouldNotReachHere((String)"No returns with software CFI");
    }

    public int directJmp(long l2, Register register) {
        throw VMError.shouldNotReachHere((String)"No register-indirect direct jump with software CFI");
    }

    private boolean a(InvokeTarget invokeTarget, CallingConvention.Type type) {
        if (!this.cr) {
            SharedMethod sharedMethod;
            if (type != null) {
                return ((SubstrateCallingConventionType)type).nativeABI();
            }
            if (invokeTarget instanceof SharedMethod && (sharedMethod = (SharedMethod)invokeTarget).getCallingConventionKind().isNativeABI()) {
                return true;
            }
            if (invokeTarget instanceof SubstrateForeignCallLinkage && ((SharedMethod)(sharedMethod = (SubstrateForeignCallLinkage)invokeTarget).getMethod()).getCallingConventionKind().isNativeABI()) {
                return true;
            }
        }
        return false;
    }

    private AMD64MacroAssembler.PostCallAction a(AMD64MacroAssembler.PostCallAction postCallAction, InvokeTarget invokeTarget) {
        return this.a(postCallAction, invokeTarget, null);
    }

    private AMD64MacroAssembler.PostCallAction a(AMD64MacroAssembler.PostCallAction postCallAction, InvokeTarget invokeTarget, CallingConvention.Type type) {
        if (this.a(invokeTarget, type)) {
            return postCallAction;
        }
        if (postCallAction == AMD64MacroAssembler.PostCallAction.NONE) {
            return (n2, n3) -> this.endbranch();
        }
        return (n2, n3) -> {
            this.endbranch();
            postCallAction.apply(n2, n3);
        };
    }

    public int directCall(AMD64MacroAssembler.PostCallAction postCallAction, long l2, Register register, InvokeTarget invokeTarget) {
        AMD64MacroAssembler.PostCallAction postCallAction2 = this.a(postCallAction, invokeTarget);
        if (this.a(invokeTarget, null)) {
            return super.directCall(postCallAction2, l2, register, invokeTarget);
        }
        this.movq(register, l2);
        this.a(register);
        int n2 = g.needsRex((Register)register) ? 3 : 2;
        this.mitigateJCCErratum(n2);
        int n3 = this.position();
        this.call(register);
        int n4 = this.position();
        assert (n3 + n2 == n4);
        if (postCallAction2 != AMD64MacroAssembler.PostCallAction.NONE) {
            postCallAction2.apply(n3, n4);
        }
        return n3;
    }

    public int call(AMD64MacroAssembler.PostCallAction postCallAction, InvokeTarget invokeTarget) {
        return super.call(this.a(postCallAction, invokeTarget), invokeTarget);
    }

    public int indirectCall(AMD64MacroAssembler.PostCallAction postCallAction, Register register, boolean bl2, InvokeTarget invokeTarget, CallingConvention.Type type) {
        if (!this.a(invokeTarget, type)) {
            this.a(register);
        }
        return super.indirectCall(this.a(postCallAction, invokeTarget, type), register, bl2, invokeTarget, type);
    }
}

