/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckImpl;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.RuntimeRandomness;
import com.oracle.svm.enterprise.core.at;
import com.oracle.svm.enterprise.core.av;
import java.util.random.RandomGenerator;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.nativeimage.ImageSingletons;

public class EnterpriseSubstrateFrameContextSupport {
    private final boolean bk;

    public static boolean a(ResolvedJavaMethod resolvedJavaMethod) {
        return (Integer)at.MaxRuntimeCodeOffsetInstructions.getValue() > 0 && resolvedJavaMethod instanceof SharedRuntimeMethod;
    }

    public static void a(CompilationResultBuilder compilationResultBuilder, Runnable runnable) {
        RandomGenerator randomGenerator = RuntimeRandomness.instance().getRandom();
        int n2 = randomGenerator.nextInt((Integer)at.MaxRuntimeCodeOffsetInstructions.getValue());
        for (int i2 = 0; i2 < n2; ++i2) {
            runnable.run();
        }
        compilationResultBuilder.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_START);
    }

    public EnterpriseSubstrateFrameContextSupport(boolean bl2) {
        this.bk = bl2;
    }

    protected boolean a(SharedMethod sharedMethod) {
        return sharedMethod.hasCalleeSavedRegisters() && !this.bk;
    }

    public boolean b(SharedMethod sharedMethod) {
        return this.e(sharedMethod) || this.c(sharedMethod);
    }

    public boolean c(SharedMethod sharedMethod) {
        return this.stackOverflowCheckedInPrologue(sharedMethod) && StackOverflowCheckImpl.needStackOverflowCheck((SharedMethod)sharedMethod);
    }

    public boolean stackOverflowCheckedInPrologue(SharedMethod sharedMethod) {
        if (!((Boolean)at.StackOverflowCheckInPrologue.getValue()).booleanValue()) {
            return false;
        }
        if (this.a(sharedMethod)) {
            return false;
        }
        return SubstrateUtil.HOSTED;
    }

    public static ResolvedJavaMethod a(CompilationResultBuilder compilationResultBuilder, SharedMethod sharedMethod) {
        SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor = EnterpriseSubstrateFrameContextSupport.d(sharedMethod) ? StackOverflowCheckImpl.THROW_CACHED_STACK_OVERFLOW_ERROR : StackOverflowCheckImpl.THROW_NEW_STACK_OVERFLOW_ERROR;
        ResolvedJavaMethod resolvedJavaMethod = ((SubstrateForeignCallLinkage)compilationResultBuilder.foreignCalls.lookupForeignCall((ForeignCallDescriptor)substrateForeignCallDescriptor)).getMethod();
        return resolvedJavaMethod;
    }

    public static int a(CompilationResultBuilder compilationResultBuilder) {
        LIR lIR = compilationResultBuilder.getLIR();
        StructuredGraph structuredGraph = ((ControlFlowGraph)lIR.getControlFlowGraph()).graph;
        return NumUtil.safeToInt((long)StackOverflowCheckImpl.computeDeoptFrameSize((StructuredGraph)structuredGraph));
    }

    private static boolean d(SharedMethod sharedMethod) {
        if (SubstrateUtil.HOSTED) {
            return ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate((ResolvedJavaMethod)sharedMethod);
        }
        return false;
    }

    public boolean e(SharedMethod sharedMethod) {
        return this.safepointCheckedInEpilogue(sharedMethod) && sharedMethod.needSafepointCheck();
    }

    public boolean safepointCheckedInEpilogue(SharedMethod sharedMethod) {
        if (!CalleeSavedRegisters.supportedByPlatform()) {
            return false;
        }
        if (!((Boolean)at.SafepointCheckInEpilogue.getValue()).booleanValue()) {
            return false;
        }
        if (!SubstrateUtil.HOSTED && this.a(sharedMethod)) {
            return false;
        }
        return SubstrateUtil.HOSTED;
    }

    public static ResolvedJavaMethod b(CompilationResultBuilder compilationResultBuilder, SharedMethod sharedMethod) {
        SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor = ((SharedType)sharedMethod.getSignature().getReturnType(null)).getStorageKind() == JavaKind.Object ? av.bB : Safepoint.ENTER_SLOW_PATH_SAFEPOINT_CHECK;
        ResolvedJavaMethod resolvedJavaMethod = ((SubstrateForeignCallLinkage)compilationResultBuilder.foreignCalls.lookupForeignCall((ForeignCallDescriptor)substrateForeignCallDescriptor)).getMethod();
        return resolvedJavaMethod;
    }

    public static long b(ResolvedJavaMethod resolvedJavaMethod) {
        assert (!SubstrateUtil.HOSTED);
        SharedMethod sharedMethod = (SharedMethod)resolvedJavaMethod;
        long l2 = CodeInfoAccess.absoluteIP((CodeInfo)CodeInfoTable.getImageCodeInfo(), (long)sharedMethod.getCodeOffsetInImage()).rawValue();
        if (l2 == 0L) {
            throw VMError.shouldNotReachHere((String)("target method not compiled: " + sharedMethod.format("%H.%n(%p)")));
        }
        return l2;
    }

    public static class b {
        private Label bl = null;
        private Label bm = null;

        public boolean J() {
            return this.bl != null;
        }

        public boolean K() {
            return this.bm != null;
        }

        public Label L() {
            if (this.bl == null) {
                this.bl = new Label();
            }
            return this.bl;
        }

        public Label M() {
            if (this.bm == null) {
                this.bm = new Label();
            }
            return this.bm;
        }

        public void N() {
            this.bl = null;
            this.bm = null;
        }
    }

    public static interface a {
        public void b(CompilationResultBuilder var1);
    }
}

