/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import java.util.HashMap;
import java.util.Map;

public enum OrtProvider {
    CPU("CPUExecutionProvider"),
    CUDA("CUDAExecutionProvider"),
    DNNL("DnnlExecutionProvider"),
    OPEN_VINO("OpenVINOExecutionProvider"),
    VITIS_AI("VitisAIExecutionProvider"),
    TENSOR_RT("TensorrtExecutionProvider"),
    NNAPI("NnapiExecutionProvider"),
    RK_NPU("RknpuExecutionProvider"),
    DIRECT_ML("DmlExecutionProvider"),
    MI_GRAPH_X("MIGraphXExecutionProvider"),
    ACL("ACLExecutionProvider"),
    ARM_NN("ArmNNExecutionProvider"),
    ROCM("ROCMExecutionProvider"),
    CORE_ML("CoreMLExecutionProvider"),
    XNNPACK("XnnpackExecutionProvider");

    private static final Map<String, OrtProvider> valueMap;
    private final String name;

    private OrtProvider(String string2) {
        this.name = string2;
    }

    public String getName() {
        return this.name;
    }

    public static OrtProvider mapFromName(String string) {
        OrtProvider ortProvider = valueMap.get(string);
        if (ortProvider == null) {
            throw new IllegalArgumentException("Unknown execution provider - " + string);
        }
        return ortProvider;
    }

    static {
        valueMap = new HashMap<String, OrtProvider>(OrtProvider.values().length);
        for (OrtProvider ortProvider : OrtProvider.values()) {
            valueMap.put(ortProvider.name, ortProvider);
        }
    }
}

