/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.truffle.compiler.HostMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleElementCache;
import org.graalvm.compiler.truffle.compiler.host.TruffleHostEnvironment;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class SubstrateTruffleHostEnvironment
extends TruffleHostEnvironment {
    private final HostMethodInfoCache hostCache = new HostMethodInfoCache();

    SubstrateTruffleHostEnvironment(TruffleCompilerRuntime runtime, MetaAccessProvider metaAccess) {
        super(runtime, metaAccess);
    }

    protected TruffleCompilerImpl createCompiler(TruffleCompilable compilable) {
        throw new UnsupportedOperationException("Creating a truffle compiler during SVM host compilation is not supported.");
    }

    public HostMethodInfo getHostMethodInfo(ResolvedJavaMethod method) {
        return (HostMethodInfo)this.hostCache.get(method);
    }

    final class HostMethodInfoCache
    extends TruffleElementCache<ResolvedJavaMethod, HostMethodInfo> {
        HostMethodInfoCache() {
            super(4096);
        }

        protected Object createKey(ResolvedJavaMethod method) {
            return method;
        }

        protected HostMethodInfo computeValue(ResolvedJavaMethod method) {
            return SubstrateTruffleHostEnvironment.this.runtime().getHostMethodInfo(method);
        }
    }
}

