/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

public class HostedSnippetReflectionProvider
extends SubstrateSnippetReflectionProvider {
    public HostedSnippetReflectionProvider(WordTypes wordTypes) {
        super(wordTypes);
    }

    @Override
    public JavaConstant forObject(Object object) {
        if (object instanceof WordBase) {
            WordBase word = (WordBase)object;
            if (!(object instanceof RelocatedPointer)) {
                return JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)word.rawValue());
            }
        }
        return super.forObject(object);
    }

    @Override
    public <T> T asObject(Class<T> type, JavaConstant c) {
        Object object;
        ImageHeapConstant imageHeapConstant;
        JavaConstant constant = c;
        if (constant instanceof ImageHeapConstant && (constant = (imageHeapConstant = (ImageHeapConstant)constant).getHostedObject()) == null) {
            return null;
        }
        if (type == Class.class && constant instanceof SubstrateObjectConstant && (object = SubstrateObjectConstant.asObject((Constant)constant)) instanceof DynamicHub) {
            DynamicHub hub = (DynamicHub)object;
            return type.cast(hub.getHostedJavaClass());
        }
        return super.asObject(type, constant);
    }
}

