/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.code.CustomCallingConventionMethod;
import com.oracle.svm.core.graal.code.ExplicitCallingConvention;
import com.oracle.svm.core.graal.code.StubCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.phases.SubstrateSafepointInsertionPhase;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedElement;
import com.oracle.svm.hosted.meta.HostedMethodNameFactory;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import jdk.internal.vm.annotation.ForceInline;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.JavaMethodContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.nativeimage.ImageSingletons;

public final class HostedMethod
extends HostedElement
implements SharedMethod,
WrappedJavaMethod,
GraphProvider,
JavaMethodContext,
OriginalMethodProvider,
MultiMethod {
    public static final String METHOD_NAME_COLLISION_SEPARATOR = "%";
    public final AnalysisMethod wrapped;
    private final HostedType holder;
    private final Signature signature;
    private final ConstantPool constantPool;
    private final ExceptionHandler[] handlers;
    StaticAnalysisResults staticAnalysisResults;
    int vtableIndex = -1;
    private int codeAddressOffset;
    private boolean codeAddressOffsetValid;
    private boolean compiled;
    HostedMethod[] implementations;
    public final CompilationInfo compilationInfo;
    private final LocalVariableTable localVariableTable;
    private final String name;
    private final String uniqueShortName;
    private final MultiMethod.MultiMethodKey multiMethodKey;
    private volatile Map<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap;
    private static final AtomicReferenceFieldUpdater<HostedMethod, Map> MULTIMETHOD_MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(HostedMethod.class, Map.class, "multiMethodMap");
    public static final HostedMethod[] EMPTY_ARRAY = new HostedMethod[0];

    static HostedMethod create(HostedUniverse universe, AnalysisMethod wrapped, HostedType holder, Signature signature, ConstantPool constantPool, ExceptionHandler[] handlers) {
        LocalVariableTable localVariableTable = HostedMethod.createLocalVariableTable(universe, wrapped);
        return HostedMethod.create0(wrapped, holder, signature, constantPool, handlers, wrapped.getMultiMethodKey(), null, localVariableTable);
    }

    private static HostedMethod create0(AnalysisMethod wrapped, HostedType holder, Signature signature, ConstantPool constantPool, ExceptionHandler[] handlers, MultiMethod.MultiMethodKey key, Map<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap, LocalVariableTable localVariableTable) {
        Function<Integer, Pair<String, String>> nameGenerator = collisionCount -> {
            Object name = wrapped.wrapped.getName();
            if (key != ORIGINAL_METHOD) {
                name = (String)name + "%%" + String.valueOf(key);
            }
            if (collisionCount > 0) {
                name = (String)name + METHOD_NAME_COLLISION_SEPARATOR + collisionCount;
            }
            String uniqueShortName = SubstrateUtil.uniqueShortName(holder.getJavaClass().getClassLoader(), (ResolvedJavaType)holder, (String)name, signature, wrapped.isConstructor());
            return Pair.create((Object)name, (Object)uniqueShortName);
        };
        Pair<String, String> names = ((HostedMethodNameFactory)ImageSingletons.lookup(HostedMethodNameFactory.class)).createNames(nameGenerator);
        return new HostedMethod(wrapped, holder, signature, constantPool, handlers, (String)names.getLeft(), (String)names.getRight(), localVariableTable, key, multiMethodMap);
    }

    private static LocalVariableTable createLocalVariableTable(HostedUniverse universe, AnalysisMethod wrapped) {
        LocalVariableTable lvt = wrapped.getLocalVariableTable();
        if (lvt == null) {
            return null;
        }
        try {
            Local[] origLocals = lvt.getLocals();
            Local[] newLocals = new Local[origLocals.length];
            for (int i = 0; i < newLocals.length; ++i) {
                Local origLocal = origLocals[i];
                JavaType origType = origLocal.getType();
                if (!universe.contains(origType)) {
                    throw new UnsupportedFeatureException("No HostedType for given AnalysisType");
                }
                HostedType newType = universe.lookup(origType);
                newLocals[i] = new Local(origLocal.getName(), (JavaType)newType, origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
            }
            return new LocalVariableTable(newLocals);
        }
        catch (UnsupportedFeatureException e) {
            return null;
        }
    }

    private HostedMethod(AnalysisMethod wrapped, HostedType holder, Signature signature, ConstantPool constantPool, ExceptionHandler[] handlers, String name, String uniqueShortName, LocalVariableTable localVariableTable, MultiMethod.MultiMethodKey multiMethodKey, Map<MultiMethod.MultiMethodKey, MultiMethod> multiMethodMap) {
        this.wrapped = wrapped;
        this.holder = holder;
        this.signature = signature;
        this.constantPool = constantPool;
        this.handlers = handlers;
        this.compilationInfo = new CompilationInfo(this);
        this.localVariableTable = localVariableTable;
        this.name = name;
        this.uniqueShortName = uniqueShortName;
        this.multiMethodKey = multiMethodKey;
        this.multiMethodMap = multiMethodMap;
    }

    public HostedMethod[] getImplementations() {
        return this.implementations;
    }

    public String getQualifiedName() {
        return this.wrapped.getQualifiedName();
    }

    public void setCodeAddressOffset(int address) {
        assert (this.isCompiled());
        assert (!this.codeAddressOffsetValid);
        this.codeAddressOffset = address;
        this.codeAddressOffsetValid = true;
    }

    public int getCodeAddressOffset() {
        if (!this.codeAddressOffsetValid) {
            throw VMError.shouldNotReachHere(this.format("%H.%n(%p)") + ": has no code address offset set.");
        }
        return this.codeAddressOffset;
    }

    public boolean isCodeAddressOffsetValid() {
        return this.codeAddressOffsetValid;
    }

    public void setCompiled() {
        this.compiled = true;
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public String getUniqueShortName() {
        return this.uniqueShortName;
    }

    public void clear() {
        this.compilationInfo.clear();
        this.staticAnalysisResults = null;
    }

    @Override
    public boolean hasCodeOffsetInImage() {
        throw VMError.intentionallyUnimplemented();
    }

    @Override
    public int getCodeOffsetInImage() {
        throw VMError.intentionallyUnimplemented();
    }

    @Override
    public int getDeoptOffsetInImage() {
        int result = 0;
        HostedMethod deoptTarget = this.getMultiMethod(DEOPT_TARGET_METHOD);
        if (deoptTarget != null && deoptTarget.isCodeAddressOffsetValid()) {
            result = deoptTarget.getCodeAddressOffset();
            assert (result != 0);
        }
        return result;
    }

    public AnalysisMethod getWrapped() {
        return this.wrapped;
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.wrapped.getParameters();
    }

    @Override
    public boolean isDeoptTarget() {
        return super.isDeoptTarget();
    }

    @Override
    public boolean canDeoptimize() {
        return this.compilationInfo.canDeoptForTesting() || this.multiMethodKey == SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD;
    }

    @Override
    public boolean isUninterruptible() {
        return Uninterruptible.Utils.isUninterruptible((AnnotatedElement)this.wrapped);
    }

    @Override
    public boolean needSafepointCheck() {
        return SubstrateSafepointInsertionPhase.needSafepointCheck((ResolvedJavaMethod)this.wrapped);
    }

    @Override
    public boolean isForeignCallTarget() {
        return this.isAnnotationPresent(SubstrateForeignCallTarget.class);
    }

    @Override
    public boolean isSnippet() {
        return this.isAnnotationPresent(Snippet.class);
    }

    public boolean hasVTableIndex() {
        return this.vtableIndex != -1;
    }

    @Override
    public int getVTableIndex() {
        assert (this.vtableIndex != -1);
        return this.vtableIndex;
    }

    @Override
    public Deoptimizer.StubType getDeoptStubType() {
        Deoptimizer.DeoptStub stubAnnotation = this.getAnnotation(Deoptimizer.DeoptStub.class);
        if (stubAnnotation != null) {
            return stubAnnotation.stubType();
        }
        return Deoptimizer.StubType.NoDeoptStub;
    }

    @Override
    public boolean isEntryPoint() {
        return this.wrapped.isEntryPoint();
    }

    @Override
    public SubstrateCallingConventionKind getCallingConventionKind() {
        return ExplicitCallingConvention.Util.getCallingConventionKind((ResolvedJavaMethod)this.wrapped, this.isEntryPoint());
    }

    @Override
    public SubstrateCallingConventionType getCustomCallingConventionType() {
        VMError.guarantee(this.getCallingConventionKind().isCustom(), "%s does not have a custom calling convention.", this.name);
        VMError.guarantee(this.wrapped.getWrapped() instanceof CustomCallingConventionMethod, "%s has a custom calling convention but doesn't implement %s", this.name, CustomCallingConventionMethod.class);
        return ((CustomCallingConventionMethod)this.wrapped.getWrapped()).getCallingConvention();
    }

    @Override
    public boolean hasCalleeSavedRegisters() {
        return StubCallingConvention.Utils.hasStubCallingConvention(this);
    }

    public String getName() {
        return this.name;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        return this.wrapped.buildGraph(debug, method, providers, purpose);
    }

    public boolean allowRuntimeCompilation() {
        return this.wrapped.allowRuntimeCompilation();
    }

    public byte[] getCode() {
        return this.wrapped.getCode();
    }

    public int getCodeSize() {
        return this.wrapped.getCodeSize();
    }

    public HostedType getDeclaringClass() {
        return this.holder;
    }

    public int getMaxLocals() {
        return this.wrapped.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.wrapped.getMaxStackSize();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.wrapped.isVarArgs();
    }

    public boolean isBridge() {
        return this.wrapped.isBridge();
    }

    public boolean isClassInitializer() {
        return this.wrapped.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.wrapped.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        return this.implementations.length == 1 && this.implementations[0].equals(this);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.handlers;
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.wrapped.asStackTraceElement(bci);
    }

    public StaticAnalysisResults getProfilingInfo() {
        return this.staticAnalysisResults;
    }

    public StaticAnalysisResults getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return this.staticAnalysisResults;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Annotation[][] getParameterAnnotations() {
        return this.wrapped.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.wrapped.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.wrapped.hasNeverInlineDirective();
    }

    public boolean shouldBeInlined() {
        return this.getAnnotation(AlwaysInline.class) != null || this.getAnnotation(ForceInline.class) != null;
    }

    public LineNumberTable getLineNumberTable() {
        return this.wrapped.getLineNumberTable();
    }

    public String toString() {
        return "HostedMethod<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return this.hasVTableIndex();
    }

    public Constant getEncoding() {
        return new SubstrateMethodPointerConstant(new MethodPointer(this));
    }

    public boolean isDefault() {
        throw VMError.intentionallyUnimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public JavaMethod asJavaMethod() {
        return this;
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public Executable getJavaMethod() {
        return this.wrapped.getJavaMethod();
    }

    public MultiMethod.MultiMethodKey getMultiMethodKey() {
        return this.multiMethodKey;
    }

    void setMultiMethodMap(ConcurrentHashMap<MultiMethod.MultiMethodKey, MultiMethod> newMultiMethodMap) {
        VMError.guarantee(this.multiMethodMap == null, "Resetting already initialized multimap");
        if (!MULTIMETHOD_MAP_UPDATER.compareAndSet(this, null, newMultiMethodMap)) {
            throw VMError.shouldNotReachHere("unable to set multimeMethodMap");
        }
    }

    public HostedMethod getOrCreateMultiMethod(MultiMethod.MultiMethodKey key) {
        if (key == this.multiMethodKey) {
            return this;
        }
        if (this.multiMethodMap == null) {
            ConcurrentHashMap<MultiMethod.MultiMethodKey, HostedMethod> newMultiMethodMap = new ConcurrentHashMap<MultiMethod.MultiMethodKey, HostedMethod>();
            newMultiMethodMap.put(this.multiMethodKey, this);
            MULTIMETHOD_MAP_UPDATER.compareAndSet(this, null, newMultiMethodMap);
        }
        return (HostedMethod)this.multiMethodMap.computeIfAbsent(key, k -> {
            HostedMethod newMultiMethod = HostedMethod.create0(this.wrapped, this.holder, this.signature, this.constantPool, this.handlers, k, this.multiMethodMap, this.localVariableTable);
            newMultiMethod.staticAnalysisResults = this.staticAnalysisResults;
            newMultiMethod.implementations = this.implementations;
            newMultiMethod.vtableIndex = this.vtableIndex;
            return newMultiMethod;
        });
    }

    public HostedMethod getMultiMethod(MultiMethod.MultiMethodKey key) {
        if (key == this.multiMethodKey) {
            return this;
        }
        if (this.multiMethodMap == null) {
            return null;
        }
        return (HostedMethod)this.multiMethodMap.get(key);
    }

    public Collection<MultiMethod> getAllMultiMethods() {
        if (this.multiMethodMap == null) {
            return Collections.singleton(this);
        }
        return this.multiMethodMap.values();
    }
}

