/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;

public final class IncompatibleClassChangeFallbackMethod
extends NonBytecodeMethod {
    private final ResolvedJavaMethod original;
    private final Class<? extends IncompatibleClassChangeError> resolutionError;

    public IncompatibleClassChangeFallbackMethod(ResolvedJavaType declaringClass, ResolvedJavaMethod original, Class<? extends IncompatibleClassChangeError> resolutionError) {
        super(original.getName(), false, declaringClass, original.getSignature(), original.getConstantPool());
        this.original = original;
        this.resolutionError = resolutionError;
    }

    public ResolvedJavaMethod getOriginal() {
        return this.original;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method, purpose);
        ResolvedJavaMethod constructor = providers.getMetaAccess().lookupJavaMethod((Executable)ReflectionUtil.lookupConstructor(this.resolutionError, (Class[])new Class[0]));
        AbstractNewObjectNode newInstance = (AbstractNewObjectNode)kit.append((Node)new NewInstanceNode(constructor.getDeclaringClass(), true));
        kit.createInvokeWithExceptionAndUnwind(constructor, CallTargetNode.InvokeKind.Special, kit.getFrameState(), kit.bci(), new ValueNode[]{newInstance});
        kit.append((Node)new UnwindNode((ValueNode)newInstance));
        return kit.finalizeGraph();
    }
}

