/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.analysis.Inflation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;

@AutomaticallyRegisteredFeature
public class ServiceLoaderFeature
implements InternalFeature {
    private static final Set<String> SKIPPED_SERVICES = Set.of("com.oracle.svm.hosted.NativeImageClassLoaderPostProcessing", "org.graalvm.nativeimage.Platform", "java.util.random.RandomGenerator", "java.security.Provider", "sun.util.locale.provider.LocaleDataMetaInfo", "jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory", "org.graalvm.compiler.hotspot.CompilerConfigurationFactory", "org.graalvm.compiler.hotspot.HotSpotBackendFactory", "org.graalvm.compiler.hotspot.meta.DefaultHotSpotLoweringProvider$Extensions", "org.graalvm.compiler.hotspot.meta.HotSpotInvocationPluginProvider", "org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory");
    private final Set<String> servicesToSkip = new HashSet<String>(SKIPPED_SERVICES);
    private static final Set<String> SKIPPED_PROVIDERS = Set.of("org.graalvm.compiler.hotspot.meta.HotSpotDisassemblerProvider", "jdk.internal.org.jline.JdkConsoleProviderImpl", "jdk.jshell.execution.impl.ConsoleImpl$ConsoleProviderImpl");
    private final Set<String> serviceProvidersToSkip = new HashSet<String>(SKIPPED_PROVIDERS);

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.UseServiceLoaderFeature.getValue();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.servicesToSkip.addAll(Options.ServiceLoaderFeatureExcludeServices.getValue().values());
        this.serviceProvidersToSkip.addAll(Options.ServiceLoaderFeatureExcludeServiceProviders.getValue().values());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        accessImpl.imageClassLoader.classLoaderSupport.serviceProvidersForEach((serviceName, providers) -> {
            if (this.servicesToSkip.contains(serviceName)) {
                return;
            }
            Class serviceClass = access.findClassByName(serviceName);
            if (serviceClass == null || serviceClass.isArray() || serviceClass.isPrimitive()) {
                return;
            }
            if (!accessImpl.getHostVM().platformSupported(serviceClass)) {
                return;
            }
            access.registerReachabilityHandler(a -> this.handleServiceClassIsReachable((Feature.DuringAnalysisAccess)a, serviceClass, (Collection<String>)providers), new Object[]{serviceClass});
        });
    }

    void handleServiceClassIsReachable(Feature.DuringAnalysisAccess access, Class<?> serviceProvider, Collection<String> providers) {
        LinkedHashSet<String> registeredProviders = new LinkedHashSet<String>();
        for (String provider : providers) {
            Constructor nullaryConstructor;
            FeatureImpl.DuringAnalysisAccessImpl accessImpl;
            Class providerClass;
            if (this.serviceProvidersToSkip.contains(provider) || (providerClass = access.findClassByName(provider)) == null || providerClass.isArray() || providerClass.isPrimitive() || !(accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access).getHostVM().platformSupported(providerClass) || ((Inflation)accessImpl.getBigBang()).getAnnotationSubstitutionProcessor().isDeleted(providerClass)) continue;
            try {
                nullaryConstructor = providerClass.getDeclaredConstructor(new Class[0]);
            }
            catch (LinkageError | NoSuchMethodException | SecurityException e) {
                nullaryConstructor = null;
            }
            if (nullaryConstructor == null) continue;
            RuntimeReflection.register((Class[])new Class[]{providerClass});
            RuntimeReflection.register((Executable[])new Executable[]{nullaryConstructor});
            RuntimeReflection.registerAllDeclaredMethods((Class)providerClass);
            registeredProviders.add(provider);
        }
        if (!registeredProviders.isEmpty()) {
            String serviceResourceLocation = "META-INF/services/" + serviceProvider.getName();
            byte[] serviceFileData = registeredProviders.stream().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
            RuntimeResourceAccess.addResource((Module)access.getApplicationClassLoader().getUnnamedModule(), (String)serviceResourceLocation, (byte[])serviceFileData);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> UseServiceLoaderFeature = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ServiceLoaderFeatureExcludeServices = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ServiceLoaderFeatureExcludeServiceProviders = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    }
}

