/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.Counter;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CounterSupport {
    private final Counter.Group[] enabledGroups;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    CounterSupport(Counter.Group[] enabledGroups) {
        this.enabledGroups = enabledGroups;
    }

    @Fold
    public static CounterSupport singleton() {
        return (CounterSupport)ImageSingletons.lookup(CounterSupport.class);
    }

    public void logValues(Log log) {
        for (Counter.Group group : this.enabledGroups) {
            group.logValues(log);
        }
    }

    public boolean hasCounters() {
        return this.enabledGroups != null && this.enabledGroups.length > 0;
    }
}

