/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.ContinuationsFeature;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.Pointer;

public interface VirtualThreads {
    @Fold
    public static VirtualThreads singleton() {
        ContinuationsFeature.abortIfUnsupported();
        return (VirtualThreads)ImageSingletons.lookup(VirtualThreads.class);
    }

    @Fold
    public static boolean isSupported() {
        return ImageSingletons.contains(VirtualThreads.class);
    }

    public ThreadFactory createFactory();

    public boolean isVirtual(Thread var1);

    public boolean getAndClearInterrupt(Thread var1);

    public void join(Thread var1, long var2) throws InterruptedException;

    public void pinCurrent();

    public void unpinCurrent();

    public boolean isCurrentPinned();

    public Executor getScheduler(Thread var1);

    public void blockedOn(Target_sun_nio_ch_Interruptible var1);

    public StackTraceElement[] getVirtualOrPlatformThreadStackTrace(boolean var1, Thread var2, Pointer var3);

    public void visitCurrentVirtualOrPlatformThreadStackFrames(Pointer var1, StackFrameVisitor var2);

    public StackTraceElement[] getVirtualOrPlatformThreadStackTraceAtSafepoint(Thread var1, Pointer var2);
}

