/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.DynamicMethodAddressResolutionHeapSupport;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.AbstractImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class AbstractCopyingImageHeapProvider
extends AbstractImageHeapProvider {
    @Override
    public boolean guaranteesHeapPreferredAddressSpaceAlignment() {
        return true;
    }

    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int initialize(Pointer reservedAddressSpace, UnsignedWord reservedSize, WordPointer basePointer, WordPointer endPointer) {
        Pointer imageHeap;
        UnsignedWord imageHeapSizeInFile;
        Word imageHeapBegin;
        int result;
        Pointer heapBase;
        boolean haveDynamicMethodResolution = DynamicMethodAddressResolutionHeapSupport.isEnabled();
        UnsignedWord preHeapRequiredBytes = (UnsignedWord)WordFactory.zero();
        UnsignedWord alignment = WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment());
        if (haveDynamicMethodResolution) {
            int res = DynamicMethodAddressResolutionHeapSupport.get().initialize();
            if (res != 0) {
                return res;
            }
            preHeapRequiredBytes = DynamicMethodAddressResolutionHeapSupport.get().getDynamicMethodAddressResolverPreHeapMemoryBytes();
        }
        UnsignedWord imageHeapAddressSpaceSize = this.getImageHeapAddressSpaceSize();
        UnsignedWord totalAddressSpaceSize = imageHeapAddressSpaceSize.add(preHeapRequiredBytes);
        Pointer allocatedMemory = (Pointer)WordFactory.nullPointer();
        if (reservedAddressSpace.isNull()) {
            heapBase = allocatedMemory = VirtualMemoryProvider.get().reserve(totalAddressSpaceSize, alignment, false);
            if (allocatedMemory.isNull()) {
                return 801;
            }
        } else {
            if (reservedSize.belowThan(totalAddressSpaceSize)) {
                return 802;
            }
            heapBase = reservedAddressSpace;
        }
        if (haveDynamicMethodResolution) {
            heapBase = heapBase.add(preHeapRequiredBytes);
            if (allocatedMemory.isNonNull()) {
                allocatedMemory.add(preHeapRequiredBytes);
            }
            Pointer installOffset = heapBase.subtract(DynamicMethodAddressResolutionHeapSupport.get().getRequiredPreHeapMemoryInBytes());
            int error = DynamicMethodAddressResolutionHeapSupport.get().install(installOffset);
            if (error != 0) {
                this.freeImageHeap((PointerBase)allocatedMemory);
                return error;
            }
        }
        if ((result = this.commitAndCopyMemory((Pointer)(imageHeapBegin = Isolates.IMAGE_HEAP_BEGIN.get()), imageHeapSizeInFile = AbstractCopyingImageHeapProvider.getImageHeapSizeInFile(), imageHeap = heapBase.add(Heap.getHeap().getImageHeapOffsetInAddressSpace()))) != 0) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return result;
        }
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        int nullRegionSize = Heap.getHeap().getImageHeapNullRegionSize();
        Pointer firstPartOfReadOnlyImageHeap = imageHeap.add(nullRegionSize);
        UnsignedWord writableBeginPageOffset = UnsignedUtils.roundDown((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get().subtract(imageHeapBegin.add(nullRegionSize)), pageSize);
        if (writableBeginPageOffset.aboveThan(0) && VirtualMemoryProvider.get().protect((PointerBase)firstPartOfReadOnlyImageHeap, writableBeginPageOffset, 1) != 0) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return 9;
        }
        UnsignedWord writableEndPageOffset = UnsignedUtils.roundUp((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract(imageHeapBegin), pageSize);
        if (writableEndPageOffset.belowThan(imageHeapSizeInFile)) {
            Pointer afterWritableBoundary = imageHeap.add(writableEndPageOffset);
            UnsignedWord afterWritableSize = imageHeapSizeInFile.subtract(writableEndPageOffset);
            if (VirtualMemoryProvider.get().protect((PointerBase)afterWritableBoundary, afterWritableSize, 1) != 0) {
                this.freeImageHeap((PointerBase)allocatedMemory);
                return 9;
            }
        }
        if (nullRegionSize > 0 && VirtualMemoryProvider.get().protect((PointerBase)imageHeapBegin, WordFactory.unsigned((int)nullRegionSize), 0) != 0) {
            return 9;
        }
        basePointer.write((WordBase)heapBase);
        if (endPointer.isNonNull()) {
            endPointer.write((WordBase)PointerUtils.roundUp((PointerBase)imageHeap.add(imageHeapSizeInFile), pageSize));
        }
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    protected int commitAndCopyMemory(Pointer loadedImageHeap, UnsignedWord imageHeapSize, Pointer newImageHeap) {
        Pointer actualNewImageHeap = VirtualMemoryProvider.get().commit((PointerBase)newImageHeap, imageHeapSize, 3);
        if (actualNewImageHeap.isNull() || actualNewImageHeap.notEqual((UnsignedWord)newImageHeap)) {
            return 801;
        }
        return this.copyMemory(loadedImageHeap, imageHeapSize, newImageHeap);
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    protected abstract int copyMemory(Pointer var1, UnsignedWord var2, Pointer var3);

    @Override
    @Uninterruptible(reason="Called during isolate tear-down.")
    public int freeImageHeap(PointerBase heapBase) {
        if (heapBase.isNonNull()) {
            UnsignedWord totalAddressSpaceSize = this.getImageHeapAddressSpaceSize();
            Pointer addressSpaceStart = (Pointer)heapBase;
            if (DynamicMethodAddressResolutionHeapSupport.isEnabled()) {
                UnsignedWord preHeapRequiredBytes = DynamicMethodAddressResolutionHeapSupport.get().getDynamicMethodAddressResolverPreHeapMemoryBytes();
                totalAddressSpaceSize = totalAddressSpaceSize.add(preHeapRequiredBytes);
                addressSpaceStart = addressSpaceStart.subtract(preHeapRequiredBytes);
            }
            if (VirtualMemoryProvider.get().free((PointerBase)addressSpaceStart, totalAddressSpaceSize) != 0) {
                return 20;
            }
        }
        return 0;
    }
}

