/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.jdk.DirectByteBufferUtil;
import com.oracle.svm.core.jdk.Target_java_nio_Buffer;
import com.oracle.svm.core.jvmstat.CHeapPerfMemoryProvider;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfMemoryPrologue;
import com.oracle.svm.core.jvmstat.PerfMemoryProvider;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class PerfMemory {
    private static final CGlobalData<Pointer> PERF_DATA_ISOLATE = CGlobalDataFactory.createWord();
    private PerfMemoryProvider memoryProvider;
    private ByteBuffer buffer;
    private int capacity;
    private Word rawMemory;
    private int used;
    private long initialTime;
    private Word[] overflowMemory;
    private int overflowMemoryPos;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PerfMemory() {
    }

    public boolean initialize() {
        if (!this.createBuffer()) {
            return false;
        }
        PerfMemoryPrologue.initialize(this.rawMemory, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        this.used = PerfMemoryPrologue.getPrologueSize();
        this.initialTime = System.nanoTime();
        return true;
    }

    private boolean createBuffer() {
        PerfMemoryProvider m = null;
        Buffer b = null;
        if (PerfManager.Options.PerfDataMemoryMappedFile.getValue().booleanValue() && PerfMemory.tryAcquirePerfDataFile() && (b = (m = (PerfMemoryProvider)ImageSingletons.lookup(PerfMemoryProvider.class)).create()) == null) {
            PerfMemory.releasePerfDataFile();
        }
        if (b == null) {
            m = new CHeapPerfMemoryProvider();
            b = m.create();
        }
        if (b == null || b.capacity() < PerfMemoryPrologue.getPrologueSize()) {
            return false;
        }
        this.memoryProvider = m;
        this.buffer = b;
        this.capacity = b.capacity();
        this.rawMemory = (Word)WordFactory.pointer((long)SubstrateUtil.cast((Object)b, Target_java_nio_Buffer.class).address);
        assert (this.verifyRawMemoryAccess());
        return true;
    }

    private boolean verifyRawMemoryAccess() {
        byte originalValue = this.buffer.get(0);
        byte writtenValue = -55;
        assert (originalValue != writtenValue);
        this.buffer.put(0, writtenValue);
        assert (this.rawMemory.readByte(0) == writtenValue);
        this.rawMemory.writeByte(0, originalValue);
        assert (this.buffer.get(0) == originalValue);
        return true;
    }

    public ByteBuffer createByteBuffer() {
        return DirectByteBufferUtil.allocate(this.rawMemory.rawValue(), this.capacity);
    }

    @NeverInline(value="Workaround for GR-26795.")
    public synchronized Word allocate(int size) {
        if (this.used + size >= this.capacity) {
            PerfMemoryPrologue.addOverflow(this.rawMemory, size);
            Word result = (Word)UnmanagedMemory.calloc((int)size);
            this.addOverflowMemory(result);
            return result;
        }
        Word result = this.rawMemory.add(this.used);
        this.used += size;
        PerfMemoryPrologue.setUsed(this.rawMemory, this.used);
        PerfMemoryPrologue.incrementNumEntries(this.rawMemory);
        return result;
    }

    private void addOverflowMemory(Word result) {
        if (this.overflowMemory == null) {
            this.overflowMemory = new Word[8];
        } else if (this.overflowMemory.length == this.overflowMemoryPos) {
            Word[] expandedOverflowMemory = new Word[this.overflowMemory.length * 2];
            System.arraycopy(this.overflowMemory, 0, expandedOverflowMemory, 0, this.overflowMemoryPos);
            this.overflowMemory = expandedOverflowMemory;
        }
        this.overflowMemory[this.overflowMemoryPos] = result;
        ++this.overflowMemoryPos;
    }

    public void markUpdated() {
        PerfMemoryPrologue.markUpdated(this.rawMemory, this.initialTime);
    }

    public void setAccessible() {
        PerfMemoryPrologue.setAccessible(this.rawMemory, true);
    }

    public void teardown() {
        if (this.buffer != null) {
            this.buffer = null;
            this.rawMemory = (Word)WordFactory.zero();
            this.capacity = 0;
            this.used = 0;
        }
        if (this.overflowMemory != null) {
            for (int i = 0; i < this.overflowMemory.length; ++i) {
                UnmanagedMemory.free((PointerBase)this.overflowMemory[i]);
            }
            this.overflowMemory = null;
        }
        if (this.memoryProvider != null) {
            this.memoryProvider.teardown();
        }
        PerfMemory.releasePerfDataFile();
    }

    private static boolean tryAcquirePerfDataFile() {
        Pointer perfDataIsolatePtr = PERF_DATA_ISOLATE.get();
        return perfDataIsolatePtr.logicCompareAndSwapWord(0, (WordBase)WordFactory.nullPointer(), (WordBase)CurrentIsolate.getIsolate(), LocationIdentity.ANY_LOCATION);
    }

    private static void releasePerfDataFile() {
        Pointer perfDataIsolatePtr = PERF_DATA_ISOLATE.get();
        if (perfDataIsolatePtr.readWord(0) == CurrentIsolate.getIsolate()) {
            perfDataIsolatePtr.writeWord(0, (WordBase)WordFactory.nullPointer());
        }
    }
}

