/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.jni.CallVariant;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@InternalVMMethod
public final class JNIJavaCallTrampolineHolder {
    private JNIJavaCallTrampolineHolder() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getTrampolineName(CallVariant variant, boolean nonVirtual) {
        StringBuilder name = new StringBuilder(48);
        if (variant == CallVariant.VARARGS) {
            name.append("varargs");
        } else if (variant == CallVariant.ARRAY) {
            name.append("array");
        } else if (variant == CallVariant.VA_LIST) {
            name.append("valist");
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput((Object)variant);
        }
        if (nonVirtual) {
            name.append("Nonvirtual");
        }
        name.append("JavaCallTrampoline");
        return name.toString();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isNonVirtual(String trampolineName) {
        return trampolineName.endsWith("NonvirtualJavaCallTrampoline");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static CallVariant getVariant(String trampolineName) {
        if (trampolineName.startsWith("varargs")) {
            return CallVariant.VARARGS;
        }
        if (trampolineName.startsWith("array")) {
            return CallVariant.ARRAY;
        }
        if (trampolineName.startsWith("valist")) {
            return CallVariant.VA_LIST;
        }
        throw VMError.shouldNotReachHereUnexpectedInput(trampolineName);
    }

    private static native void varargsJavaCallTrampoline();

    private static native void arrayJavaCallTrampoline();

    private static native void valistJavaCallTrampoline();

    private static native void varargsNonvirtualJavaCallTrampoline();

    private static native void arrayNonvirtualJavaCallTrampoline();

    private static native void valistNonvirtualJavaCallTrampoline();
}

