/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.jdk.AccessControllerUtil;
import com.oracle.svm.core.jdk.PrivilegedStack;
import com.oracle.svm.core.jdk.StackAccessControlContextVisitor;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.util.VMError;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=AccessController.class)
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_java_security_AccessController {
    Target_java_security_AccessController() {
    }

    @Substitute
    static AccessControlContext getStackAccessControlContext() {
        if (!CEntryPointSnippets.isIsolateInitialized()) {
            return null;
        }
        return StackAccessControlContextVisitor.getFromStack();
    }

    @Substitute
    static AccessControlContext getInheritedAccessControlContext() {
        return SubstrateUtil.cast((Object)Thread.currentThread(), Target_java_lang_Thread.class).inheritedAccessControlContext;
    }

    @Substitute
    private static ProtectionDomain getProtectionDomain(Class<?> caller) {
        return caller.getProtectionDomain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    static <T> T executePrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context, Class<?> caller) throws Throwable {
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        PrivilegedStack.push(context, caller);
        try {
            T t = action.run();
            return t;
        }
        finally {
            PrivilegedStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    static <T> T executePrivileged(PrivilegedAction<T> action, AccessControlContext context, Class<?> caller) {
        if (action == null) {
            throw new NullPointerException("Null action");
        }
        PrivilegedStack.push(context, caller);
        try {
            T t = action.run();
            return t;
        }
        finally {
            PrivilegedStack.pop();
        }
    }

    @Substitute
    static AccessControlContext checkContext(AccessControlContext context, Class<?> caller) {
        if (context != null && context.equals(AccessControllerUtil.DISALLOWED_CONTEXT_MARKER)) {
            VMError.shouldNotReachHere("Non-allowed AccessControlContext that was replaced with a blank one at build time was invoked without being reinitialized at run time.\nThis might be an indicator of improper build time initialization, or of a non-compatible JDK version.\nIn order to fix this you can either:\n    * Annotate the offending context's field with @RecomputeFieldValue\n    * Implement a custom runtime accessor and annotate said field with @InjectAccessors\n    * If this context originates from the JDK, and it doesn't leak sensitive info, you can allow it in 'AccessControlContextReplacerFeature.duringSetup'");
        }
        if (System.getSecurityManager() != null) {
            throw VMError.unsupportedFeature("SecurityManager isn't supported");
        }
        return context;
    }
}

