/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.lir;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.lir.VerificationMarkerOp;
import com.oracle.svm.core.nodes.CFunctionEpilogueMarker;
import com.oracle.svm.core.nodes.CFunctionPrologueMarker;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.FinalCodeAnalysisPhase;

public class VerifyCFunctionReferenceMapsLIRPhase
extends FinalCodeAnalysisPhase {
    protected CharSequence createName() {
        return "VerifyCFunctionReferenceMapsLIRPhase";
    }

    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, FinalCodeAnalysisPhase.FinalCodeAnalysisContext context) {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        LIR ir = lirGenRes.getLIR();
        for (int blockId : ir.getBlocks()) {
            if (LIR.isBlockDeleted((int)blockId)) continue;
            BasicBlock block = ir.getBlockById(blockId);
            ArrayList instructions = ir.getLIRforBlock(block);
            for (int i = 0; i < instructions.size(); ++i) {
                LIRInstruction op = (LIRInstruction)instructions.get(i);
                if (!(op instanceof VerificationMarkerOp) || !(((VerificationMarkerOp)op).getMarker() instanceof CFunctionPrologueMarker)) continue;
                CFunctionPrologueMarker prologueMarker = (CFunctionPrologueMarker)((VerificationMarkerOp)op).getMarker();
                new VerificationInstance(ir, prologueMarker.getNewThreadStatus(), prologueMarker.getEpilogueMarker()).run(block, i);
            }
        }
    }

    static class VerificationInstance {
        private final LIR ir;
        private final int newThreadStatus;
        private final CFunctionEpilogueMarker epilogueMarker;
        private final Set<BasicBlock<?>> processed = new HashSet();
        private final Deque<BasicBlock<?>> worklist = new ArrayDeque();
        private final List<LIRFrameState> states = new ArrayList<LIRFrameState>();

        VerificationInstance(LIR ir, int newThreadStatus, CFunctionEpilogueMarker epilogueMarker) {
            this.ir = ir;
            this.newThreadStatus = newThreadStatus;
            this.epilogueMarker = epilogueMarker;
        }

        void run(BasicBlock<?> startBlock, int startInstruction) {
            this.processBlock(startBlock, startInstruction);
            while (!this.worklist.isEmpty()) {
                this.processBlock(this.worklist.pop(), 0);
            }
            if (this.states.size() < this.expectedFrameStates()) {
                throw VMError.shouldNotReachHere("Expected at least " + this.expectedFrameStates() + " instructions with states, but found " + this.states.size());
            }
            ReferenceMap firstMap = this.states.get(0).debugInfo().getReferenceMap();
            for (LIRFrameState state : this.states) {
                ReferenceMap map = state.debugInfo().getReferenceMap();
                if (firstMap.equals(map)) continue;
                throw VMError.shouldNotReachHere("Reference maps not equal: " + String.valueOf(firstMap) + ", " + String.valueOf(map));
            }
        }

        private void processBlock(BasicBlock<?> block, int startInstruction) {
            int i;
            this.processed.add(block);
            ArrayList instructions = this.ir.getLIRforBlock(block);
            for (i = startInstruction; i < instructions.size(); ++i) {
                LIRInstruction op = (LIRInstruction)instructions.get(i);
                if (op instanceof VerificationMarkerOp && ((VerificationMarkerOp)op).getMarker() == this.epilogueMarker) {
                    return;
                }
                op.forEachState(state -> this.states.add(state));
            }
            if (block.getSuccessorCount() == 0) {
                throw VMError.shouldNotReachHere("No epilogue marker found");
            }
            for (i = 0; i < block.getSuccessorCount(); ++i) {
                BasicBlock successor = block.getSuccessorAt(i);
                if (this.processed.contains(successor)) continue;
                this.worklist.add(successor);
            }
        }

        private int expectedFrameStates() {
            switch (this.newThreadStatus) {
                case 3: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
            }
            throw VMError.shouldNotReachHere("Unexpected thread status: " + this.newThreadStatus);
        }
    }
}

