/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrGCWhen;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

class JfrGCHeapSummaryEvent {
    JfrGCHeapSummaryEvent() {
    }

    public static void emit(JfrGCWhen gcWhen) {
        if (HasJfrSupport.get()) {
            JfrGCHeapSummaryEvent.emit0(GCImpl.getGCImpl().getCollectionEpoch(), JfrTicks.elapsedTicks(), HeapImpl.getAccounting().getCommittedBytes(), HeapImpl.getAccounting().getUsedBytes(), gcWhen);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void emit0(UnsignedWord gcEpoch, long start, UnsignedWord committedSize, UnsignedWord heapUsed, JfrGCWhen gcWhen) {
        if (JfrEvent.GCHeapSummary.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.GCHeapSummary);
            JfrNativeEventWriter.putLong(data, start);
            JfrNativeEventWriter.putLong(data, gcEpoch.rawValue());
            JfrNativeEventWriter.putLong(data, gcWhen.getId());
            JfrNativeEventWriter.putLong(data, -1L);
            JfrNativeEventWriter.putLong(data, -1L);
            JfrNativeEventWriter.putLong(data, committedSize.rawValue());
            JfrNativeEventWriter.putLong(data, -1L);
            JfrNativeEventWriter.putLong(data, committedSize.rawValue());
            JfrNativeEventWriter.putLong(data, heapUsed.rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }
}

