/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.config;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.Uninterruptible;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.word.WordBase;

public final class ObjectLayout {
    private final SubstrateTargetDescription target;
    private final int referenceSize;
    private final int objectAlignment;
    private final int alignmentMask;
    private final int hubOffset;
    private final int firstFieldOffset;
    private final int arrayLengthOffset;
    private final int arrayBaseOffset;
    private final int fixedIdentityHashOffset;

    public ObjectLayout(SubstrateTargetDescription target, int referenceSize, int objectAlignment, int hubOffset, int firstFieldOffset, int arrayLengthOffset, int arrayBaseOffset, int fixedIdentityHashOffset) {
        assert (CodeUtil.isPowerOf2((int)referenceSize)) : referenceSize;
        assert (CodeUtil.isPowerOf2((int)objectAlignment)) : objectAlignment;
        assert (arrayLengthOffset % 4 == 0);
        assert (hubOffset < firstFieldOffset && hubOffset < arrayLengthOffset) : hubOffset;
        assert (fixedIdentityHashOffset == -1 || fixedIdentityHashOffset > 0 && fixedIdentityHashOffset < arrayLengthOffset) : fixedIdentityHashOffset;
        this.target = target;
        this.referenceSize = referenceSize;
        this.objectAlignment = objectAlignment;
        this.alignmentMask = objectAlignment - 1;
        this.hubOffset = hubOffset;
        this.firstFieldOffset = firstFieldOffset;
        this.arrayLengthOffset = arrayLengthOffset;
        this.arrayBaseOffset = arrayBaseOffset;
        this.fixedIdentityHashOffset = fixedIdentityHashOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getAlignment() {
        return this.objectAlignment;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAligned(long value) {
        return value % (long)this.getAlignment() == 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getReferenceSize() {
        return this.referenceSize;
    }

    public int getDeoptScratchSpace() {
        return this.target.getDeoptScratchSpace();
    }

    public int sizeInBytes(JavaKind kind) {
        return kind == JavaKind.Object ? this.referenceSize : this.target.arch.getPlatformKind(kind).getSizeInBytes();
    }

    public int getArrayIndexShift(JavaKind kind) {
        return CodeUtil.log2((int)this.getArrayIndexScale(kind));
    }

    public int getArrayIndexScale(JavaKind kind) {
        return this.sizeInBytes(kind);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int alignUp(int obj) {
        return obj + this.alignmentMask & ~this.alignmentMask;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long alignUp(long obj) {
        return obj + (long)this.alignmentMask & (long)(~this.alignmentMask);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getHubOffset() {
        return this.hubOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getFirstFieldOffset() {
        return this.firstFieldOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getArrayLengthOffset() {
        return this.arrayLengthOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getFixedIdentityHashOffset() {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)this.hasFixedIdentityHashField(), (String)"must check before calling");
        } else assert (this.hasFixedIdentityHashField());
        return this.fixedIdentityHashOffset;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasFixedIdentityHashField() {
        return this.fixedIdentityHashOffset >= 0;
    }

    public int getArrayBaseOffset(JavaKind kind) {
        return NumUtil.roundUp((int)this.arrayBaseOffset, (int)this.sizeInBytes(kind));
    }

    public long getArrayElementOffset(JavaKind kind, int index) {
        return this.getArrayBaseOffset(kind) + index * this.sizeInBytes(kind);
    }

    public long getArraySize(JavaKind kind, int length, boolean withOptionalIdHashField) {
        return this.computeArrayTotalSize(this.getArrayUnalignedSize(kind, length), withOptionalIdHashField);
    }

    private long getArrayUnalignedSize(JavaKind kind, int length) {
        assert (length >= 0);
        return (long)this.getArrayBaseOffset(kind) + ((long)length << this.getArrayIndexShift(kind));
    }

    public long getArrayOptionalIdentityHashOffset(JavaKind kind, int length) {
        return this.getArrayOptionalIdentityHashOffset(this.getArrayUnalignedSize(kind, length));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getArrayOptionalIdentityHashOffset(long unalignedSize) {
        if (this.hasFixedIdentityHashField()) {
            return this.getFixedIdentityHashOffset();
        }
        int align = 4;
        return (unalignedSize + (long)align - 1L) / (long)align * (long)align;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long computeArrayTotalSize(long unalignedSize, boolean withOptionalIdHashField) {
        long size = unalignedSize;
        if (withOptionalIdHashField && !this.hasFixedIdentityHashField()) {
            size = this.getArrayOptionalIdentityHashOffset(size) + 4L;
        }
        return this.alignUp(size);
    }

    public int getMinImageHeapInstanceSize() {
        int unalignedSize = this.firstFieldOffset;
        if (!this.hasFixedIdentityHashField()) {
            int idHashOffset = NumUtil.roundUp((int)unalignedSize, (int)4);
            unalignedSize = idHashOffset + 4;
        }
        return this.alignUp(unalignedSize);
    }

    public int getMinImageHeapArraySize() {
        return NumUtil.safeToInt((long)this.getArraySize(JavaKind.Byte, 0, true));
    }

    public int getMinImageHeapObjectSize() {
        return Math.min(this.getMinImageHeapArraySize(), this.getMinImageHeapInstanceSize());
    }

    public static JavaKind getCallSignatureKind(boolean isEntryPoint, ResolvedJavaType type, MetaAccessProvider metaAccess, TargetDescription target) {
        if (metaAccess.lookupJavaType(WordBase.class).isAssignableFrom(type)) {
            return target.wordJavaKind;
        }
        if (isEntryPoint && AnnotationAccess.isAnnotationPresent((AnnotatedElement)type, CEnum.class)) {
            return JavaKind.Int;
        }
        return type.getJavaKind();
    }
}

