/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CIsolateData;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton
public final class CIsolateDataStorage {
    public static final int ALIGNMENT = 8;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHostedUniverse.class)
    private byte[] managedIsolateSectionData;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public CIsolateDataStorage() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setSize(UnsignedWord size) {
        assert (this.managedIsolateSectionData == null);
        UnsignedWord allocationSize = size.add(WordFactory.unsigned((int)7));
        this.managedIsolateSectionData = new byte[UnsignedUtils.safeToInt(allocationSize)];
    }

    @Fold
    public static CIsolateDataStorage singleton() {
        return (CIsolateDataStorage)ImageSingletons.lookup(CIsolateDataStorage.class);
    }

    @Fold
    protected static UnsignedWord arrayBaseOffset() {
        int offset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
        return UnsignedUtils.roundUp(WordFactory.unsigned((int)offset), WordFactory.unsigned((int)8));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends PointerBase> T get(CIsolateData<T> ptr) {
        VMError.guarantee(ptr != null, "null isolate data section entry");
        Word base = Word.objectToUntrackedPointer((Object)this.managedIsolateSectionData).add(CIsolateDataStorage.arrayBaseOffset());
        return (T)base.add(ptr.getOffset());
    }
}

