/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityAnalysisField;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityAnalysisType;
import com.oracle.graal.reachability.ReachabilityInvokeInfo;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import com.oracle.svm.common.meta.MultiMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.Optional;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.nativeimage.AnnotationAccess;

public class DirectMethodProcessingHandler
implements ReachabilityMethodProcessingHandler {
    @Override
    public void onMethodReachable(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method) {
        StructuredGraph decoded = ReachabilityAnalysisMethod.getDecodedGraph(bb, method);
        DirectMethodProcessingHandler.analyzeStructuredGraph(bb, method, decoded);
    }

    @Override
    public void processGraph(ReachabilityAnalysisEngine bb, StructuredGraph graph) {
        DirectMethodProcessingHandler.analyzeStructuredGraph(bb, (ReachabilityAnalysisMethod)graph.method(), graph);
    }

    private static void analyzeStructuredGraph(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method, StructuredGraph graph) {
        if (method != null) {
            int offset;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            int parameterCount = method.getSignature().getParameterCount(!isStatic);
            for (int i = offset = isStatic ? 0 : 1; i < parameterCount; ++i) {
                bb.registerTypeAsReachable((ReachabilityAnalysisType)method.getSignature().getParameterType(i - offset, (ResolvedJavaType)method.getDeclaringClass()), "Parameter type for " + method.format("%H.%n(%p)"));
            }
            bb.registerTypeAsReachable((ReachabilityAnalysisType)method.getSignature().getReturnType((ResolvedJavaType)method.getDeclaringClass()), "Return type for " + method.format("%H.%n(%p)"));
        }
        for (Node n : graph.getNodes()) {
            if (n instanceof NewInstanceNode) {
                NewInstanceNode node = (NewInstanceNode)n;
                bb.registerTypeAsAllocated((ReachabilityAnalysisType)node.instanceClass(), AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewArrayNode) {
                NewArrayNode node = (NewArrayNode)n;
                bb.registerTypeAsAllocated(((ReachabilityAnalysisType)node.elementType()).getArrayClass(), AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof NewMultiArrayNode) {
                NewMultiArrayNode node = (NewMultiArrayNode)n;
                ResolvedJavaType type = node.type();
                for (int i = 0; i < node.dimensionCount(); ++i) {
                    bb.registerTypeAsAllocated((ReachabilityAnalysisType)type, AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                    type = type.getComponentType();
                }
                continue;
            }
            if (n instanceof VirtualInstanceNode) {
                VirtualInstanceNode node = (VirtualInstanceNode)n;
                bb.registerTypeAsAllocated((ReachabilityAnalysisType)node.type(), AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof VirtualArrayNode) {
                VirtualArrayNode node = (VirtualArrayNode)n;
                bb.registerTypeAsAllocated(((ReachabilityAnalysisType)node.componentType()).getArrayClass(), AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof ConstantNode) {
                ConstantNode node = (ConstantNode)n;
                if (!(node.getValue() instanceof JavaConstant)) continue;
                JavaConstant constant = (JavaConstant)node.getValue();
                bb.handleEmbeddedConstant(method, constant, AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof InstanceOfNode) {
                InstanceOfNode node = (InstanceOfNode)n;
                bb.registerTypeAsReachable((ReachabilityAnalysisType)node.type().getType(), AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof LoadFieldNode) {
                LoadFieldNode node = (LoadFieldNode)n;
                bb.markFieldRead((ReachabilityAnalysisField)node.field(), AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof StoreFieldNode) {
                StoreFieldNode node = (StoreFieldNode)n;
                bb.markFieldWritten((ReachabilityAnalysisField)node.field(), AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof Invoke) {
                Invoke node = (Invoke)n;
                CallTargetNode.InvokeKind kind = node.getInvokeKind();
                ReachabilityAnalysisMethod targetMethod = (ReachabilityAnalysisMethod)node.getTargetMethod();
                if (targetMethod == null || AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)targetMethod), Node.NodeIntrinsic.class)) continue;
                BytecodePosition reason = AbstractAnalysisEngine.sourcePosition((ValueNode)node.asNode());
                if (method != null) {
                    method.addInvoke(new ReachabilityInvokeInfo(targetMethod, reason, kind.isDirect()));
                }
                if (kind == CallTargetNode.InvokeKind.Static) {
                    bb.markMethodImplementationInvoked(targetMethod, reason);
                    continue;
                }
                if (kind == CallTargetNode.InvokeKind.Special) {
                    bb.markMethodSpecialInvoked(targetMethod, reason);
                    continue;
                }
                bb.markMethodInvoked(targetMethod, reason);
                continue;
            }
            if (n instanceof FrameState) {
                FrameState node = (FrameState)n;
                ResolvedJavaMethod frameMethod = node.getMethod();
                if (frameMethod == null) continue;
                ReachabilityAnalysisMethod analysisMethod = (ReachabilityAnalysisMethod)frameMethod;
                bb.registerTypeAsReachable(analysisMethod.getDeclaringClass(), AbstractAnalysisEngine.syntheticSourcePosition((Node)node, (ResolvedJavaMethod)method));
                continue;
            }
            if (n instanceof MacroInvokable) {
                MacroInvokable node = (MacroInvokable)n;
                ReachabilityAnalysisMethod targetMethod = (ReachabilityAnalysisMethod)node.getTargetMethod();
                BytecodePosition reason = AbstractAnalysisEngine.syntheticSourcePosition((Node)node.asNode(), (ResolvedJavaMethod)method);
                CallTargetNode.InvokeKind kind = node.getInvokeKind();
                if (kind == CallTargetNode.InvokeKind.Static) {
                    bb.markMethodImplementationInvoked(targetMethod, reason);
                    continue;
                }
                if (kind == CallTargetNode.InvokeKind.Special) {
                    bb.markMethodSpecialInvoked(targetMethod, reason);
                    continue;
                }
                bb.markMethodInvoked(targetMethod, reason);
                continue;
            }
            if (n instanceof ForeignCall) {
                MultiMethod.MultiMethodKey key = method == null ? MultiMethod.ORIGINAL_METHOD : method.getMultiMethodKey();
                ForeignCallsProvider foreignCallsProvider = bb.getProviders(key).getForeignCalls();
                DirectMethodProcessingHandler.handleForeignCall(bb, ((ForeignCall)n).getDescriptor(), foreignCallsProvider, graph.method());
                continue;
            }
            if (n instanceof UnaryMathIntrinsicNode) {
                ForeignCallSignature signature = ((UnaryMathIntrinsicNode)n).getOperation().foreignCallSignature;
                MultiMethod.MultiMethodKey key = method == null ? MultiMethod.ORIGINAL_METHOD : method.getMultiMethodKey();
                ForeignCallsProvider foreignCallsProvider = bb.getProviders(key).getForeignCalls();
                DirectMethodProcessingHandler.handleForeignCall(bb, foreignCallsProvider.getDescriptor(signature), foreignCallsProvider, graph.method());
                continue;
            }
            if (!(n instanceof BinaryMathIntrinsicNode)) continue;
            ForeignCallSignature signature = ((BinaryMathIntrinsicNode)n).getOperation().foreignCallSignature;
            MultiMethod.MultiMethodKey key = method == null ? MultiMethod.ORIGINAL_METHOD : method.getMultiMethodKey();
            ForeignCallsProvider foreignCallsProvider = bb.getProviders(key).getForeignCalls();
            DirectMethodProcessingHandler.handleForeignCall(bb, foreignCallsProvider.getDescriptor(signature), foreignCallsProvider, graph.method());
        }
    }

    private static void handleForeignCall(ReachabilityAnalysisEngine bb, ForeignCallDescriptor descriptor, ForeignCallsProvider foreignCallsProvider, ResolvedJavaMethod from) {
        Optional targetMethod = bb.getHostVM().handleForeignCall(descriptor, foreignCallsProvider);
        targetMethod.ifPresent(method -> bb.addRootMethod((AnalysisMethod)method, false, (Object)from, new MultiMethod.MultiMethodKey[0]));
    }
}

