/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.tools.asn1;

import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import com.oracle.jipher.internal.tools.asn1.Asn1Exception;
import com.oracle.jipher.internal.tools.asn1.TagClass;
import com.oracle.jipher.internal.tools.asn1.UniversalTag;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;

public final class Asn1 {
    static final Charset US_ASCII = Charset.forName("US-ASCII");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    static final byte[] FALSE = new byte[]{0};
    static final byte[] TRUE = new byte[]{-1};
    static final Map<Integer, UniversalTag> MAP_TO_UNIVERSAL = Asn1.genMapToUniversal();

    private Asn1() {
    }

    static Map<Integer, UniversalTag> genMapToUniversal() {
        HashMap<Integer, UniversalTag> map = new HashMap<Integer, UniversalTag>();
        for (UniversalTag ut : UniversalTag.values()) {
            if (map.containsKey(ut.tagValue)) continue;
            map.put(ut.tagValue, ut);
        }
        return Collections.unmodifiableMap(map);
    }

    public static Asn1BerValue decode(ByteBuffer src) {
        return Asn1.decode(src, false);
    }

    public static Asn1BerValue decode(ByteBuffer src, boolean checkDer) {
        return new Asn1BerValue(src, checkDer);
    }

    public static Asn1BerValue decodeOne(ByteBuffer src) {
        return Asn1.decodeOne(src, false);
    }

    public static Asn1BerValue decodeOne(ByteBuffer src, boolean checkDer) {
        Asn1BerValue value = Asn1.decode(src, checkDer);
        if (src.hasRemaining()) {
            throw new Asn1DecodeException("Unconsumed data remains in buffer after decoding value; at offset " + value.offset);
        }
        return value;
    }

    public static Asn1BerValue decodeOne(byte[] src) {
        return Asn1.decodeOne(ByteBuffer.wrap(src));
    }

    public static List<Asn1BerValue> decodeAll(ByteBuffer src) {
        return Asn1.decodeAll(src, false);
    }

    public static List<Asn1BerValue> decodeAll(ByteBuffer src, boolean checkDer) {
        ArrayList<Asn1BerValue> values = new ArrayList<Asn1BerValue>();
        while (src.hasRemaining()) {
            Asn1BerValue value = Asn1.decode(src, checkDer);
            if (value.endOfContents) {
                throw new Asn1DecodeException("Unexpected End-of-contents marker at offset " + value.offset);
            }
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    public static List<Asn1BerValue> decodeUntilMark(ByteBuffer src) {
        ArrayList<Asn1BerValue> values = new ArrayList<Asn1BerValue>();
        while (true) {
            Asn1BerValue value = new Asn1BerValue(src, false);
            if (value.endOfContents) {
                return Collections.unmodifiableList(values);
            }
            values.add(value);
        }
    }

    public static List<Asn1BerValue> toListWithoutNulls(Asn1BerValue[] values) {
        ArrayList<Asn1BerValue> vl = new ArrayList<Asn1BerValue>(values.length);
        for (Asn1BerValue v : values) {
            if (v == null) continue;
            vl.add(v);
        }
        return vl;
    }

    public static UniversalTag toUniversalTag(TagClass tagClass, int tagValue) {
        return tagClass != TagClass.UNIVERSAL ? null : MAP_TO_UNIVERSAL.get(tagValue);
    }

    public static String tagToString(TagClass tagClass, int tagValue) {
        if (tagClass == null) {
            return "[null tag class]";
        }
        if (tagValue < 0) {
            return "[invalid tag value: " + tagValue + "]";
        }
        UniversalTag ut = Asn1.toUniversalTag(tagClass, tagValue);
        if (ut != null) {
            return ut.asn1Name();
        }
        if (tagClass != TagClass.CONTEXT_SPECIFIC) {
            return "[" + tagClass.name() + ' ' + tagValue + ']';
        }
        return "[" + tagValue + ']';
    }

    static Charset getRcsCharset(UniversalTag encoding) {
        switch (encoding) {
            case UTF8String: {
                return UTF_8;
            }
            case NumericString: 
            case PrintableString: 
            case TeletexString: 
            case T61String: 
            case VideotexString: 
            case IA5String: 
            case GraphicString: 
            case VisibleString: 
            case ISO646String: 
            case GeneralString: {
                return US_ASCII;
            }
            case UniversalString: {
                return UTF_32BE;
            }
            case BMPString: {
                return UTF_16BE;
            }
        }
        throw new Asn1Exception("Not a Restricted Character String encoding: " + encoding.asn1Name());
    }

    public static Asn1BerValue newBoolean(boolean b) {
        return Asn1.newBoolean(TagClass.UNIVERSAL, UniversalTag.BOOLEAN.tagValue, b);
    }

    public static Asn1BerValue newInteger(long l) {
        return Asn1.newInteger(BigInteger.valueOf(l));
    }

    public static Asn1BerValue newInteger(BigInteger i) {
        return Asn1.newInteger(TagClass.UNIVERSAL, UniversalTag.INTEGER.tagValue, i);
    }

    public static Asn1BerValue newEnumerated(long e) {
        return Asn1.newEnumerated(BigInteger.valueOf(e));
    }

    public static Asn1BerValue newEnumerated(BigInteger e) {
        return Asn1.newEnumerated(TagClass.UNIVERSAL, UniversalTag.ENUMERATED.tagValue, e);
    }

    public static Asn1BerValue newBitString(byte[] octets) {
        return Asn1.newBitString(TagClass.UNIVERSAL, UniversalTag.BIT_STRING.tagValue, octets);
    }

    public static Asn1BerValue newBitString(BitSet bitSet) {
        return Asn1.newBitString(TagClass.UNIVERSAL, UniversalTag.BIT_STRING.tagValue, bitSet);
    }

    public static Asn1BerValue newOctetString(ByteBuffer buf) {
        return Asn1.newOctetString(TagClass.UNIVERSAL, UniversalTag.OCTET_STRING.tagValue, buf);
    }

    public static Asn1BerValue newOctetString(byte[] octets) {
        return Asn1.newOctetString(TagClass.UNIVERSAL, UniversalTag.OCTET_STRING.tagValue, octets);
    }

    public static Asn1BerValue newNull() {
        return Asn1.newNull(TagClass.UNIVERSAL, UniversalTag.NULL.tagValue);
    }

    public static Asn1BerValue newOid(int ... components) {
        return Asn1.newOid(TagClass.UNIVERSAL, UniversalTag.OBJECT_IDENTIFIER.tagValue, components);
    }

    public static Asn1BerValue newOid(String oidStr) {
        return Asn1.newOid(TagClass.UNIVERSAL, UniversalTag.OBJECT_IDENTIFIER.tagValue, oidStr);
    }

    public static Asn1BerValue newRelativeOid(int ... components) {
        return Asn1.newRelativeOid(TagClass.UNIVERSAL, UniversalTag.RELATIVE_OID.tagValue, components);
    }

    public static Asn1BerValue newRelativeOid(String oidStr) {
        return Asn1.newRelativeOid(TagClass.UNIVERSAL, UniversalTag.RELATIVE_OID.tagValue, oidStr);
    }

    public static Asn1BerValue newRcsUTF8String(String str) {
        return Asn1.newRcs(str, UniversalTag.UTF8String);
    }

    public static Asn1BerValue newRcs(String str, UniversalTag encoding) {
        return Asn1.newRcs(TagClass.UNIVERSAL, encoding.tagValue, str, encoding);
    }

    public static Asn1BerValue newGeneralizedTime(Date date) {
        return Asn1.newGeneralizedTime(TagClass.UNIVERSAL, UniversalTag.GeneralizedTime.tagValue, date);
    }

    public static Asn1BerValue newUtcTime(Date date) {
        return Asn1.newUtcTime(TagClass.UNIVERSAL, UniversalTag.UTCTime.tagValue, date);
    }

    static void checkUniversalTag(TagClass tagClass, int tagValue, UniversalTag ut) {
        if (tagClass == TagClass.UNIVERSAL && tagValue != ut.tagValue) {
            throw new Asn1Exception("Invalid universal tag applied to " + ut.asn1Name() + ": " + Asn1.tagToString(tagClass, tagValue));
        }
    }

    static Asn1BerValue newBoolean(TagClass tagClass, int tagValue, boolean b) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.BOOLEAN);
        return Asn1.newPrimitive(tagClass, tagValue, b ? TRUE : FALSE);
    }

    static Asn1BerValue newInteger(TagClass tagClass, int tagValue, long l) {
        return Asn1.newInteger(tagClass, tagValue, BigInteger.valueOf(l));
    }

    static Asn1BerValue newInteger(TagClass tagClass, int tagValue, BigInteger i) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.INTEGER);
        return Asn1.newPrimitive(tagClass, tagValue, i.toByteArray());
    }

    static Asn1BerValue newEnumerated(TagClass tagClass, int tagValue, BigInteger e) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.ENUMERATED);
        return Asn1.newPrimitive(tagClass, tagValue, e.toByteArray());
    }

    static Asn1BerValue newBitString(TagClass tagClass, int tagValue, byte[] octets) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.BIT_STRING);
        ByteBuffer content = ByteBuffer.allocate(octets.length + 1);
        content.put((byte)0).put(octets).rewind();
        return Asn1.newPrimitive(tagClass, tagValue, content);
    }

    static Asn1BerValue newBitString(TagClass tagClass, int tagValue, BitSet bitSet) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.BIT_STRING);
        byte[] bytes = bitSet.toByteArray();
        ByteBuffer content = ByteBuffer.allocate(bytes.length + 1);
        int unusedBits = bytes.length * 8 - bitSet.length();
        content.put((byte)unusedBits);
        for (int i = 0; i < bytes.length; ++i) {
            content.put((byte)(Integer.reverse(bytes[i]) >>> 24));
        }
        content.rewind();
        return Asn1.newPrimitive(tagClass, tagValue, content);
    }

    static Asn1BerValue newOctetString(TagClass tagClass, int tagValue, ByteBuffer buf) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.OCTET_STRING);
        return Asn1.newPrimitive(tagClass, tagValue, buf);
    }

    static Asn1BerValue newOctetString(TagClass tagClass, int tagValue, byte[] octets) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.OCTET_STRING);
        return Asn1.newPrimitive(tagClass, tagValue, octets);
    }

    public static Asn1BerValue newNull(TagClass tagClass, int tagValue) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.NULL);
        return Asn1.newPrimitive(tagClass, tagValue, new byte[0]);
    }

    static int countIdentifierOctets(int id) {
        int bitCount = 32 - Integer.numberOfLeadingZeros(id);
        return Math.max(1, (bitCount + 6) / 7);
    }

    static int countOidSubIdentifierOctets(int[] subIds, int offset) {
        int octetCount = 0;
        for (int i = offset; i < subIds.length; ++i) {
            if (subIds[i] < 0) {
                throw new IllegalArgumentException("Invalid OID component: " + subIds[i]);
            }
            octetCount += Asn1.countIdentifierOctets(subIds[i]);
        }
        return octetCount;
    }

    static void encodeIdentifier(ByteBuffer dst, int id) {
        int octetCount = Asn1.countIdentifierOctets(id);
        for (int shift = (octetCount - 1) * 7; shift > 0; shift -= 7) {
            dst.put((byte)(id >>> shift | 0x80));
        }
        dst.put((byte)(id & 0x7F));
    }

    static void encodeOidSubIdentifiers(ByteBuffer dst, int[] subIds, int offset) {
        for (int i = offset; i < subIds.length; ++i) {
            Asn1.encodeIdentifier(dst, subIds[i]);
        }
    }

    static Asn1BerValue newOid(TagClass tagClass, int tagValue, int[] components) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.OBJECT_IDENTIFIER);
        if (components.length < 2) {
            throw new IllegalArgumentException("Insufficient OID components");
        }
        int c0 = components[0];
        int c1 = components[1];
        int subId0 = c0 * 40 + c1;
        if (c0 < 0 || c1 < 0 || c0 > 2 || c0 < 2 && c1 >= 40 || subId0 < 0) {
            throw new IllegalArgumentException("Invalid OID component: " + Arrays.toString(components));
        }
        int len = Asn1.countIdentifierOctets(subId0) + Asn1.countOidSubIdentifierOctets(components, 2);
        ByteBuffer content = ByteBuffer.allocate(len);
        Asn1.encodeIdentifier(content, subId0);
        Asn1.encodeOidSubIdentifiers(content, components, 2);
        content.rewind();
        return Asn1.newPrimitiveValue(tagClass, tagValue, content);
    }

    static int[] splitToInts(String oidStr) {
        String[] sComponents = oidStr.split("\\.");
        int[] components = new int[sComponents.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = Integer.parseInt(sComponents[i]);
        }
        return components;
    }

    static Asn1BerValue newOid(TagClass tagClass, int tagValue, String oidStr) {
        return Asn1.newOid(tagClass, tagValue, Asn1.splitToInts(oidStr));
    }

    static Asn1BerValue newRelativeOid(TagClass tagClass, int tagValue, int[] components) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.RELATIVE_OID);
        int len = Asn1.countOidSubIdentifierOctets(components, 0);
        ByteBuffer content = ByteBuffer.allocate(len);
        Asn1.encodeOidSubIdentifiers(content, components, 0);
        content.rewind();
        return Asn1.newPrimitiveValue(tagClass, tagValue, content);
    }

    static Asn1BerValue newRelativeOid(TagClass tagClass, int tagValue, String oidStr) {
        return Asn1.newRelativeOid(tagClass, tagValue, Asn1.splitToInts(oidStr));
    }

    static Asn1BerValue newRcs(TagClass tagClass, int tagValue, String str, UniversalTag encoding) {
        Charset charset = Asn1.getRcsCharset(encoding);
        Asn1.checkUniversalTag(tagClass, tagValue, encoding);
        return Asn1.newPrimitive(tagClass, tagValue, str.getBytes(charset));
    }

    static Asn1BerValue newGeneralizedTime(TagClass tagClass, int tagValue, Date date) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.GeneralizedTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return Asn1.newPrimitive(tagClass, tagValue, df.format(date).getBytes(US_ASCII));
    }

    static Asn1BerValue newUtcTime(TagClass tagClass, int tagValue, Date date) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.UTCTime);
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return Asn1.newPrimitive(tagClass, tagValue, df.format(date).getBytes(US_ASCII));
    }

    static Asn1BerValue newPrimitive(TagClass tagClass, int tagValue, ByteBuffer content) {
        return Asn1.newPrimitiveValue(tagClass, tagValue, content.slice());
    }

    static Asn1BerValue newPrimitive(TagClass tagClass, int tagValue, byte[] content) {
        return Asn1.newPrimitiveValue(tagClass, tagValue, ByteBuffer.wrap(content));
    }

    static Asn1BerValue newPrimitiveValue(TagClass tagClass, int tagValue, ByteBuffer content) {
        if (tagClass == TagClass.UNIVERSAL && (tagValue == UniversalTag.SET.tagValue || tagValue == UniversalTag.SEQUENCE.tagValue)) {
            throw new Asn1Exception("Invalid universal tag applied to primitive: " + Asn1.tagToString(tagClass, tagValue));
        }
        return new Asn1BerValue(tagClass, tagValue, false, null, null, content.asReadOnlyBuffer());
    }

    public static Asn1BerValue newSequence(Asn1BerValue ... values) {
        return Asn1.newSequence(Asn1.toListWithoutNulls(values));
    }

    public static Asn1BerValue newSet(Asn1BerValue ... values) {
        return Asn1.newSet(Asn1.toListWithoutNulls(values));
    }

    public static Asn1BerValue newSetOf(Asn1BerValue ... values) {
        return Asn1.newSetOf(Asn1.toListWithoutNulls(values));
    }

    public static Asn1BerValue newSequence(List<Asn1BerValue> values) {
        return Asn1.newSequence(TagClass.UNIVERSAL, UniversalTag.SEQUENCE.tagValue, values);
    }

    public static Asn1BerValue newSet(List<Asn1BerValue> values) {
        return Asn1.newSet(TagClass.UNIVERSAL, UniversalTag.SET.tagValue, values, Asn1BerValue.SortOrder.SET);
    }

    public static Asn1BerValue newSetOf(List<Asn1BerValue> values) {
        return Asn1.newSet(TagClass.UNIVERSAL, UniversalTag.SET.tagValue, values, Asn1BerValue.SortOrder.SET_OF);
    }

    public static Asn1BerValue newExplicitTag(int csTag, Asn1BerValue value) {
        return Asn1.newExplicitTag(TagClass.CONTEXT_SPECIFIC, csTag, value);
    }

    static Asn1BerValue newSequence(TagClass tagClass, int tagValue, List<Asn1BerValue> values) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.SEQUENCE);
        return Asn1.newConstructedValue(tagClass, tagValue, Collections.unmodifiableList(values), Asn1BerValue.SortOrder.SEQUENCE);
    }

    static Asn1BerValue newSet(TagClass tagClass, int tagValue, List<Asn1BerValue> values, Asn1BerValue.SortOrder sortOrder) {
        Asn1.checkUniversalTag(tagClass, tagValue, UniversalTag.SET);
        return Asn1.newConstructedValue(tagClass, tagValue, Collections.unmodifiableList(values), sortOrder);
    }

    public static Asn1BerValue newExplicitTag(TagClass tagClass, int tagValue, Asn1BerValue value) {
        if (tagClass == TagClass.UNIVERSAL) {
            throw new Asn1Exception("Invalid universal explicit tag: " + Asn1.tagToString(tagClass, tagValue));
        }
        return Asn1.newConstructedValue(tagClass, tagValue, Collections.singletonList(value), Asn1BerValue.SortOrder.SEQUENCE);
    }

    static Asn1BerValue newConstructedValue(TagClass tagClass, int tagValue, List<Asn1BerValue> values, Asn1BerValue.SortOrder sortOrder) {
        return new Asn1BerValue(tagClass, tagValue, true, sortOrder, values, null);
    }

    public static ImplicitTagValueFactory implicit(int csTag) {
        return Asn1.implicit(csTag, null);
    }

    public static ImplicitTagValueFactory implicit(UniversalTag universalTag) {
        return Asn1.implicit(universalTag, null);
    }

    public static ImplicitTagValueFactory implicit(TagClass tagClass, int tagValue) {
        return Asn1.implicit(tagClass, tagValue, null);
    }

    static ImplicitTagValueFactory implicit(int csTag, ExplicitTagValueFactory tagWrapper) {
        return Asn1.implicit(TagClass.CONTEXT_SPECIFIC, csTag, tagWrapper);
    }

    static ImplicitTagValueFactory implicit(UniversalTag universalTag, ExplicitTagValueFactory tagWrapper) {
        return Asn1.implicit(TagClass.UNIVERSAL, universalTag.tagValue, tagWrapper);
    }

    static ImplicitTagValueFactory implicit(TagClass tagClass, int tagValue, ExplicitTagValueFactory tagWrapper) {
        if (tagClass == null || tagValue < 0) {
            throw new IllegalArgumentException("Invalid tag class or value");
        }
        return new ImplicitTagValueFactory(tagClass, tagValue, tagWrapper);
    }

    public static ExplicitTagValueFactory explicit(int csTag) {
        return Asn1.explicit(csTag, null);
    }

    public static ExplicitTagValueFactory explicit(TagClass tagClass, int tagValue) {
        return Asn1.explicit(tagClass, tagValue, null);
    }

    static ExplicitTagValueFactory explicit(int csTag, ExplicitTagValueFactory tagWrapper) {
        return Asn1.explicit(TagClass.CONTEXT_SPECIFIC, csTag, tagWrapper);
    }

    static ExplicitTagValueFactory explicit(TagClass tagClass, int tagValue, ExplicitTagValueFactory tagWrapper) {
        if (tagClass == null || tagValue < 0) {
            throw new IllegalArgumentException("Invalid tag class or value");
        }
        return new ExplicitTagValueFactory(tagClass, tagValue, tagWrapper);
    }

    static interface ValueFactory {
        public Asn1BerValue newBoolean(boolean var1);

        public Asn1BerValue newInteger(long var1);

        public Asn1BerValue newInteger(BigInteger var1);

        public Asn1BerValue newEnumerated(long var1);

        public Asn1BerValue newEnumerated(BigInteger var1);

        public Asn1BerValue newBitString(byte[] var1);

        public Asn1BerValue newBitString(BitSet var1);

        public Asn1BerValue newOctetString(ByteBuffer var1);

        public Asn1BerValue newOctetString(byte[] var1);

        public Asn1BerValue newNull();

        public Asn1BerValue newOid(int ... var1);

        public Asn1BerValue newOid(String var1);

        public Asn1BerValue newRelativeOid(int ... var1);

        public Asn1BerValue newRelativeOid(String var1);

        public Asn1BerValue newRcsUTF8String(String var1);

        public Asn1BerValue newRcs(String var1, UniversalTag var2);

        public Asn1BerValue newGeneralizedTime(Date var1);

        public Asn1BerValue newUtcTime(Date var1);

        public Asn1BerValue newSequence(Asn1BerValue ... var1);

        public Asn1BerValue newSet(Asn1BerValue ... var1);

        public Asn1BerValue newSetOf(Asn1BerValue ... var1);

        public Asn1BerValue newSequence(List<Asn1BerValue> var1);

        public Asn1BerValue newSet(List<Asn1BerValue> var1);

        public Asn1BerValue newSetOf(List<Asn1BerValue> var1);
    }

    public static final class ExplicitTagValueFactory
    implements ValueFactory {
        private final TagClass tagClass;
        private final int tagValue;
        private final ExplicitTagValueFactory tagWrapper;

        ExplicitTagValueFactory(TagClass tagClass, int tagValue, ExplicitTagValueFactory tagWrapper) {
            this.tagClass = tagClass;
            this.tagValue = tagValue;
            this.tagWrapper = tagWrapper;
        }

        Asn1BerValue applyExplicit(Asn1BerValue value) {
            Asn1BerValue et = Asn1.newExplicitTag(this.tagClass, this.tagValue, value);
            return this.tagWrapper != null ? this.tagWrapper.applyExplicit(et) : et;
        }

        @Override
        public Asn1BerValue newBoolean(boolean b) {
            return this.applyExplicit(Asn1.newBoolean(b));
        }

        @Override
        public Asn1BerValue newInteger(long l) {
            return this.applyExplicit(Asn1.newInteger(l));
        }

        @Override
        public Asn1BerValue newInteger(BigInteger i) {
            return this.applyExplicit(Asn1.newInteger(i));
        }

        @Override
        public Asn1BerValue newEnumerated(long e) {
            return this.applyExplicit(Asn1.newEnumerated(e));
        }

        @Override
        public Asn1BerValue newEnumerated(BigInteger e) {
            return this.applyExplicit(Asn1.newEnumerated(e));
        }

        @Override
        public Asn1BerValue newBitString(byte[] octets) {
            return this.applyExplicit(Asn1.newBitString(octets));
        }

        @Override
        public Asn1BerValue newBitString(BitSet bitSet) {
            return this.applyExplicit(Asn1.newBitString(bitSet));
        }

        @Override
        public Asn1BerValue newOctetString(ByteBuffer buf) {
            return this.applyExplicit(Asn1.newOctetString(buf));
        }

        @Override
        public Asn1BerValue newOctetString(byte[] octets) {
            return this.applyExplicit(Asn1.newOctetString(octets));
        }

        @Override
        public Asn1BerValue newNull() {
            return this.applyExplicit(Asn1.newNull());
        }

        @Override
        public Asn1BerValue newOid(int ... components) {
            return this.applyExplicit(Asn1.newOid(components));
        }

        @Override
        public Asn1BerValue newOid(String oidStr) {
            return this.applyExplicit(Asn1.newOid(oidStr));
        }

        @Override
        public Asn1BerValue newRelativeOid(int ... components) {
            return this.applyExplicit(Asn1.newRelativeOid(components));
        }

        @Override
        public Asn1BerValue newRelativeOid(String oidStr) {
            return this.applyExplicit(Asn1.newRelativeOid(oidStr));
        }

        @Override
        public Asn1BerValue newRcsUTF8String(String str) {
            return this.applyExplicit(Asn1.newRcs(str, UniversalTag.UTF8String));
        }

        @Override
        public Asn1BerValue newRcs(String str, UniversalTag encoding) {
            return this.applyExplicit(Asn1.newRcs(str, encoding));
        }

        @Override
        public Asn1BerValue newSequence(Asn1BerValue ... values) {
            return this.applyExplicit(Asn1.newSequence(values));
        }

        @Override
        public Asn1BerValue newSet(Asn1BerValue ... values) {
            return this.applyExplicit(Asn1.newSet(values));
        }

        @Override
        public Asn1BerValue newSetOf(Asn1BerValue ... values) {
            return this.applyExplicit(Asn1.newSetOf(values));
        }

        @Override
        public Asn1BerValue newSequence(List<Asn1BerValue> values) {
            return this.applyExplicit(Asn1.newSequence(values));
        }

        @Override
        public Asn1BerValue newSet(List<Asn1BerValue> values) {
            return this.applyExplicit(Asn1.newSet(values));
        }

        @Override
        public Asn1BerValue newSetOf(List<Asn1BerValue> values) {
            return this.applyExplicit(Asn1.newSetOf(values));
        }

        @Override
        public Asn1BerValue newUtcTime(Date date) {
            return this.applyExplicit(Asn1.newUtcTime(date));
        }

        @Override
        public Asn1BerValue newGeneralizedTime(Date date) {
            return this.applyExplicit(Asn1.newGeneralizedTime(date));
        }

        public ImplicitTagValueFactory implicit(int csTag) {
            return Asn1.implicit(csTag, this);
        }

        public ImplicitTagValueFactory implicit(UniversalTag universalTag) {
            return Asn1.implicit(universalTag, this);
        }

        public ImplicitTagValueFactory implicit(TagClass tagClass, int tagValue) {
            return Asn1.implicit(tagClass, tagValue, this);
        }

        public ExplicitTagValueFactory explicit(int csTag) {
            return Asn1.explicit(csTag, this);
        }

        public ExplicitTagValueFactory explicit(TagClass tagClass, int tagValue) {
            return Asn1.explicit(tagClass, tagValue, this);
        }
    }

    public static final class ImplicitTagValueFactory
    implements ValueFactory {
        private final TagClass tagClass;
        private final int tagValue;
        private final ExplicitTagValueFactory tagWrapper;

        ImplicitTagValueFactory(TagClass tagClass, int tagValue, ExplicitTagValueFactory tagWrapper) {
            this.tagClass = tagClass;
            this.tagValue = tagValue;
            this.tagWrapper = tagWrapper;
        }

        Asn1BerValue applyExplicit(Asn1BerValue value) {
            return this.tagWrapper != null ? this.tagWrapper.applyExplicit(value) : value;
        }

        @Override
        public Asn1BerValue newBoolean(boolean b) {
            return this.applyExplicit(Asn1.newBoolean(this.tagClass, this.tagValue, b));
        }

        @Override
        public Asn1BerValue newInteger(long l) {
            return this.applyExplicit(Asn1.newInteger(this.tagClass, this.tagValue, l));
        }

        @Override
        public Asn1BerValue newInteger(BigInteger i) {
            return this.applyExplicit(Asn1.newInteger(this.tagClass, this.tagValue, i));
        }

        @Override
        public Asn1BerValue newEnumerated(long e) {
            return this.applyExplicit(Asn1.newEnumerated(this.tagClass, this.tagValue, BigInteger.valueOf(e)));
        }

        @Override
        public Asn1BerValue newEnumerated(BigInteger e) {
            return this.applyExplicit(Asn1.newEnumerated(this.tagClass, this.tagValue, e));
        }

        @Override
        public Asn1BerValue newBitString(byte[] octets) {
            return this.applyExplicit(Asn1.newBitString(this.tagClass, this.tagValue, octets));
        }

        @Override
        public Asn1BerValue newBitString(BitSet bitSet) {
            return this.applyExplicit(Asn1.newBitString(this.tagClass, this.tagValue, bitSet));
        }

        @Override
        public Asn1BerValue newOctetString(ByteBuffer buf) {
            return this.applyExplicit(Asn1.newOctetString(this.tagClass, this.tagValue, buf));
        }

        @Override
        public Asn1BerValue newOctetString(byte[] octets) {
            return this.applyExplicit(Asn1.newOctetString(this.tagClass, this.tagValue, octets));
        }

        @Override
        public Asn1BerValue newNull() {
            return this.applyExplicit(Asn1.newNull(this.tagClass, this.tagValue));
        }

        @Override
        public Asn1BerValue newOid(int ... components) {
            return this.applyExplicit(Asn1.newOid(this.tagClass, this.tagValue, components));
        }

        @Override
        public Asn1BerValue newOid(String oidStr) {
            return this.applyExplicit(Asn1.newOid(this.tagClass, this.tagValue, oidStr));
        }

        @Override
        public Asn1BerValue newRelativeOid(int ... components) {
            return this.applyExplicit(Asn1.newRelativeOid(this.tagClass, this.tagValue, components));
        }

        @Override
        public Asn1BerValue newRelativeOid(String oidStr) {
            return this.applyExplicit(Asn1.newRelativeOid(this.tagClass, this.tagValue, oidStr));
        }

        public Asn1BerValue newRcs(String str) {
            UniversalTag encoding = Asn1.toUniversalTag(this.tagClass, this.tagValue);
            if (encoding == null) {
                throw new Asn1Exception("Unknown RCS encoding for tag: " + Asn1.tagToString(this.tagClass, this.tagValue));
            }
            return this.applyExplicit(Asn1.newRcs(this.tagClass, this.tagValue, str, encoding));
        }

        @Override
        public Asn1BerValue newRcsUTF8String(String str) {
            return this.applyExplicit(Asn1.newRcs(this.tagClass, this.tagValue, str, UniversalTag.UTF8String));
        }

        @Override
        public Asn1BerValue newRcs(String str, UniversalTag encoding) {
            return this.applyExplicit(Asn1.newRcs(this.tagClass, this.tagValue, str, encoding));
        }

        @Override
        public Asn1BerValue newGeneralizedTime(Date date) {
            return this.applyExplicit(Asn1.newGeneralizedTime(this.tagClass, this.tagValue, date));
        }

        @Override
        public Asn1BerValue newUtcTime(Date date) {
            return this.applyExplicit(Asn1.newUtcTime(this.tagClass, this.tagValue, date));
        }

        public Asn1BerValue newPrimitive(ByteBuffer content) {
            return this.applyExplicit(Asn1.newPrimitive(this.tagClass, this.tagValue, content));
        }

        public Asn1BerValue newPrimitive(byte[] content) {
            return this.applyExplicit(Asn1.newPrimitive(this.tagClass, this.tagValue, content));
        }

        @Override
        public Asn1BerValue newSequence(Asn1BerValue ... values) {
            return this.newSequence(Asn1.toListWithoutNulls(values));
        }

        @Override
        public Asn1BerValue newSet(Asn1BerValue ... values) {
            return this.newSet(Asn1.toListWithoutNulls(values));
        }

        @Override
        public Asn1BerValue newSetOf(Asn1BerValue ... values) {
            return this.newSetOf(Asn1.toListWithoutNulls(values));
        }

        @Override
        public Asn1BerValue newSequence(List<Asn1BerValue> values) {
            return this.applyExplicit(Asn1.newSequence(this.tagClass, this.tagValue, values));
        }

        @Override
        public Asn1BerValue newSet(List<Asn1BerValue> values) {
            return this.applyExplicit(Asn1.newSet(this.tagClass, this.tagValue, values, Asn1BerValue.SortOrder.SET));
        }

        @Override
        public Asn1BerValue newSetOf(List<Asn1BerValue> values) {
            return this.applyExplicit(Asn1.newSet(this.tagClass, this.tagValue, values, Asn1BerValue.SortOrder.SET_OF));
        }
    }
}

