/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.sampler.ProfilingSampler;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingRuntimeProfile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class b {
    private OutputStream yp;
    private final AtomicBoolean yq = new AtomicBoolean();

    @Fold
    public static b instance() {
        return (b)ImageSingletons.lookup(b.class);
    }

    public void start(OutputStream outputStream) {
        this.reset();
        assert (!this.yq.compareAndExchange(false, true)) : "The profile stream has already started.";
        this.yp = outputStream;
    }

    public void finish() throws IOException {
        assert (this.yp != null);
        assert (this.yq.compareAndExchange(true, false)) : "The profile stream was not started.";
        this.dump(this.yp);
    }

    public void reset() {
        assert (!this.yq.get()) : "Cannot reset when profile stream has started";
        ProfilingRuntimeProfile.instance().data().gL();
        if (ImageSingletons.contains(ProfilingSampler.class)) {
            ((ProfilingSampler)ImageSingletons.lookup(ProfilingSampler.class)).reset();
        }
    }

    public void dump(OutputStream outputStream) throws IOException {
        assert (!this.yq.get()) : "Cannot dump when profile stream has started";
        ProfilingRuntimeProfile.instance().dump(outputStream);
    }
}

