/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.enterprise.core.amd64.d;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.amd64.AMD64AddressNode;
import org.graalvm.compiler.core.common.type.CompressibleConstant;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

class AMD64ImageHeapAddressOptimizationPhase
extends BasePhase<CoreProviders> {
    AMD64ImageHeapAddressOptimizationPhase() {
    }

    static boolean W() {
        return (Boolean)a.OptInlineImageHeapConstants.getValue() != false && (Boolean)SubstrateOptions.SpawnIsolates.getValue() != false && !SubstrateOptions.useLLVMBackend();
    }

    static boolean a(CompressibleConstant compressibleConstant, SharedConstantReflectionProvider sharedConstantReflectionProvider) {
        if (!AMD64ImageHeapAddressOptimizationPhase.W()) {
            return false;
        }
        if (SubstrateUtil.HOSTED) {
            return true;
        }
        return sharedConstantReflectionProvider.getImageHeapOffset((JavaConstant)compressibleConstant) != 0;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        SharedConstantReflectionProvider sharedConstantReflectionProvider = (SharedConstantReflectionProvider)coreProviders.getConstantReflection();
        for (AMD64AddressNode aMD64AddressNode : structuredGraph.getNodes().filter(AMD64AddressNode.class)) {
            SubstrateObjectConstant substrateObjectConstant;
            ValueNode valueNode = aMD64AddressNode.getBase();
            if (valueNode == null || !valueNode.isJavaConstant() || !(valueNode.asJavaConstant() instanceof SubstrateObjectConstant) || !AMD64ImageHeapAddressOptimizationPhase.a((CompressibleConstant)(substrateObjectConstant = (SubstrateObjectConstant)valueNode.asJavaConstant()), sharedConstantReflectionProvider)) continue;
            d d2 = new d(substrateObjectConstant, aMD64AddressNode.getIndex(), aMD64AddressNode.getScale(), aMD64AddressNode.getDisplacement());
            aMD64AddressNode.replaceAndDelete(structuredGraph.unique((Node)d2));
            if (!valueNode.hasNoUsages()) continue;
            valueNode.safeDelete();
        }
    }

    public static class a {
        public static final HostedOptionKey<Boolean> OptInlineImageHeapConstants = new HostedOptionKey((Object)true);
    }
}

