/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.ChunkBasedCommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.at;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import com.oracle.svm.enterprise.core.e;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class EnterpriseAddressRangeCommittedMemoryProvider
extends ChunkBasedCommittedMemoryProvider {
    private static final int aU = 0;
    private static final int aV = 1;
    private static final int aW = 2;
    private static final OutOfMemoryError aX = new OutOfMemoryError("Could not allocate node for free list, OS may be out of memory.");
    private static final OutOfMemoryError aY = new OutOfMemoryError("Could not allocate an aligned heap chunk because the heap address space is exhausted. Consider re-building the image with compressed references disabled ('-H:-UseCompressedReferences').");
    private static final OutOfMemoryError aZ = new OutOfMemoryError("Could not allocate an unaligned heap chunk because the heap address space is exhausted. Consider re-building the image with compressed references disabled ('-H:-UseCompressedReferences').");
    private static final OutOfMemoryError ba = new OutOfMemoryError("Could not commit the memory for an aligned heap chunk, OS may be out of memory.");
    private static final OutOfMemoryError bb = new OutOfMemoryError("Could not commit the memory for an unaligned heap chunk, OS may be out of memory.");
    private final VMMutex bc = new VMMutex("freeList");
    private FreeListNode bd;
    private long be;
    private FreeListNode bf;
    private long bg;
    private UnsignedWord bh;
    private Pointer bi;
    private UnsignedWord bj;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public EnterpriseAddressRangeCommittedMemoryProvider() {
    }

    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer wordPointer, CEntryPointCreateIsolateParameters cEntryPointCreateIsolateParameters) {
        Pointer pointer;
        WordPointer wordPointer2;
        UnsignedWord unsignedWord;
        int n2;
        UnsignedWord unsignedWord2 = ReferenceAccess.singleton().getAddressSpaceSize();
        CCharPointer cCharPointer = (CCharPointer)WordFactory.nullPointer();
        UnsignedWord unsignedWord3 = (UnsignedWord)WordFactory.zero();
        if (cEntryPointCreateIsolateParameters.isNonNull()) {
            if (cEntryPointCreateIsolateParameters.version() < 0 || cEntryPointCreateIsolateParameters.version() > 5) {
                return 10;
            }
            if (cEntryPointCreateIsolateParameters.version() >= 2) {
                cCharPointer = cEntryPointCreateIsolateParameters.auxiliaryImagePath();
                unsignedWord3 = cEntryPointCreateIsolateParameters.auxiliaryImageReservedSpaceSize();
            }
            if (cEntryPointCreateIsolateParameters.version() >= 1 && cEntryPointCreateIsolateParameters.reservedSpaceSize().notEqual(0)) {
                unsignedWord2 = UnsignedUtils.min((UnsignedWord)cEntryPointCreateIsolateParameters.reservedSpaceSize(), (UnsignedWord)unsignedWord2);
            }
        }
        if (unsignedWord3.equal((UnsignedWord)WordFactory.zero())) {
            unsignedWord3 = at.getReservedAuxiliaryImageBytes();
        }
        if ((n2 = this.a(unsignedWord2, unsignedWord = WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment()), cEntryPointCreateIsolateParameters, wordPointer2 = (WordPointer)StackValue.get(WordPointer.class))) != 0) {
            return n2;
        }
        Pointer pointer2 = (Pointer)wordPointer2.read();
        if (((Boolean)SubstrateOptions.SpawnIsolates.getValue()).booleanValue()) {
            WordPointer wordPointer3 = (WordPointer)StackValue.get(WordPointer.class);
            int n3 = ImageHeapProvider.get().initialize(pointer2, unsignedWord2, wordPointer, wordPointer3);
            if (n3 != 0) {
                this.a(pointer2, unsignedWord2);
                return n3;
            }
            CEntryPointSnippets.setHeapBase((PointerBase)((PointerBase)wordPointer.read()));
            pointer = (Pointer)wordPointer3.read();
            Pointer pointer3 = PointerUtils.roundUp((PointerBase)((PointerBase)wordPointer3.read()), (UnsignedWord)this.getGranularity());
            UnsignedWord unsignedWord4 = unsignedWord2.subtract((UnsignedWord)pointer3.subtract((UnsignedWord)pointer2));
            if (unsignedWord3.aboveThan(0)) {
                if (unsignedWord3.aboveThan(unsignedWord4)) {
                    this.a(pointer2, unsignedWord2);
                    return 17;
                }
                unsignedWord4 = unsignedWord3;
            }
            if (cCharPointer.isNonNull()) {
                WordPointer wordPointer4 = (WordPointer)StackValue.get(WordPointer.class);
                WordPointer wordPointer5 = (WordPointer)StackValue.get(WordPointer.class);
                n3 = AuxiliaryImageProvider.get().loadAuxiliaryImage(pointer3, unsignedWord4, cCharPointer, wordPointer4, wordPointer5);
                if (n3 != 0) {
                    this.a(pointer2, unsignedWord2);
                    return n3;
                }
                pointer = (Pointer)wordPointer5.read();
            }
            if (unsignedWord3.aboveThan(0)) {
                AuxiliaryImageLoader.setAuxImageReservedSpace(pointer3, unsignedWord3);
                pointer = pointer3.add(unsignedWord3);
            }
            pointer = PointerUtils.roundUp((PointerBase)pointer, (UnsignedWord)this.getGranularity());
        } else {
            int n4 = EnterpriseAddressRangeCommittedMemoryProvider.protectSingleIsolateImageHeap();
            if (n4 != 0) {
                return n4;
            }
            wordPointer.write((WordBase)Isolates.IMAGE_HEAP_BEGIN.get());
            pointer = pointer2;
        }
        int n5 = EnterpriseAddressRangeCommittedMemoryProvider.a(pointer2, unsignedWord2, pointer);
        if (n5 != 0) {
            this.a(pointer2, unsignedWord2);
        }
        return n5;
    }

    @NeverInline(value="Ensure a newly looked up value of EnterpriseAddressRangeCommittedMemoryProvider is used now that the image heap is initialized")
    @Uninterruptible(reason="Called from uninterruptible code.")
    private static int a(Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2) {
        EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider = (EnterpriseAddressRangeCommittedMemoryProvider)ChunkBasedCommittedMemoryProvider.get();
        return enterpriseAddressRangeCommittedMemoryProvider.b(pointer, unsignedWord, pointer2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private int b(Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2) {
        this.bh = unsignedWord;
        this.bi = pointer2;
        this.bj = pointer.add(unsignedWord).subtract((UnsignedWord)pointer2);
        FreeListNode freeListNode = this.c(pointer2, this.bj);
        if (freeListNode.isNull()) {
            return 3;
        }
        this.bf = freeListNode;
        this.bg = 1L;
        this.bd = freeListNode;
        this.be = 1L;
        return 0;
    }

    @Uninterruptible(reason="Still being initialized.")
    protected int a(UnsignedWord unsignedWord, UnsignedWord unsignedWord2, CEntryPointCreateIsolateParameters cEntryPointCreateIsolateParameters, WordPointer wordPointer) {
        Pointer pointer = ImageSingletons.contains(e.class) ? e.singleton().a(unsignedWord, unsignedWord2) : VirtualMemoryProvider.get().reserve(unsignedWord, unsignedWord2, false);
        if (pointer.isNull()) {
            return 801;
        }
        wordPointer.write((WordBase)pointer);
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void a(Pointer pointer, UnsignedWord unsignedWord) {
        VirtualMemoryProvider.get().free((PointerBase)pointer, unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private FreeListNode b(Pointer pointer, UnsignedWord unsignedWord) {
        FreeListNode freeListNode = this.c(pointer, unsignedWord);
        if (freeListNode.isNull()) {
            throw aX;
        }
        return freeListNode;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private FreeListNode c(Pointer pointer, UnsignedWord unsignedWord) {
        FreeListNode freeListNode = (FreeListNode)((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).calloc(SizeOf.unsigned(FreeListNode.class));
        if (freeListNode.isNonNull()) {
            this.a(freeListNode, pointer, unsignedWord);
        }
        return freeListNode;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(FreeListNode freeListNode) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)freeListNode);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean a(UnsignedWord unsignedWord) {
        return unsignedWord.aboveOrEqual(EnterpriseAddressRangeCommittedMemoryProvider.minAllocationSize());
    }

    @Fold
    static UnsignedWord minAllocationSize() {
        return UnsignedUtils.min((UnsignedWord)HeapParameters.getAlignedHeapChunkSize(), (UnsignedWord)HeapParameters.getMinUnalignedChunkSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        assert (UnsignedUtils.isAMultiple((UnsignedWord)pointer, (UnsignedWord)this.getGranularity()));
        assert (UnsignedUtils.isAMultiple((UnsignedWord)unsignedWord, (UnsignedWord)this.getGranularity()));
        assert (pointer.aboveOrEqual((UnsignedWord)this.bi));
        assert (unsignedWord.belowOrEqual(this.bj));
        assert (pointer.add(unsignedWord).belowOrEqual((UnsignedWord)this.bi.add(this.bj)));
        freeListNode.setStart(pointer);
        freeListNode.setSize(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer b(FreeListNode freeListNode) {
        return freeListNode.getStart().add(freeListNode.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, Pointer pointer, Pointer pointer2) {
        assert (freeListNode.getCommittedStart().isNull() == freeListNode.getCommittedEnd().isNull());
        assert (pointer.isNull() == pointer2.isNull());
        if (pointer.isNull()) {
            return;
        }
        assert (pointer.aboveOrEqual((UnsignedWord)this.bi));
        assert (pointer.belowThan((UnsignedWord)pointer2));
        assert (PointerUtils.isAMultiple((PointerBase)pointer, (UnsignedWord)this.getGranularity()));
        assert (PointerUtils.isAMultiple((PointerBase)pointer2, (UnsignedWord)this.getGranularity()));
        assert (pointer2.subtract((UnsignedWord)pointer).belowOrEqual(this.bj));
        Pointer pointer3 = EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode);
        if (pointer.aboveOrEqual((UnsignedWord)pointer3) || pointer2.belowOrEqual((UnsignedWord)freeListNode.getStart())) {
            return;
        }
        Pointer pointer4 = (Pointer)PointerUtils.max((PointerBase)pointer, (PointerBase)freeListNode.getStart());
        Pointer pointer5 = (Pointer)PointerUtils.min((PointerBase)pointer2, (PointerBase)pointer3);
        if (freeListNode.getCommittedStart().isNull() || pointer4.belowThan((UnsignedWord)freeListNode.getCommittedStart())) {
            freeListNode.setCommittedStart(pointer4);
        }
        if (freeListNode.getCommittedEnd().isNull() || pointer5.aboveThan((UnsignedWord)freeListNode.getCommittedEnd())) {
            freeListNode.setCommittedEnd(pointer5);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void c(FreeListNode freeListNode) {
        Pointer pointer = freeListNode.getCommittedStart();
        Pointer pointer2 = freeListNode.getCommittedEnd();
        if (pointer.isNonNull()) {
            freeListNode.setCommittedStart((Pointer)WordFactory.nullPointer());
            freeListNode.setCommittedEnd((Pointer)WordFactory.nullPointer());
            this.a(freeListNode, pointer, pointer2);
        }
    }

    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        PointerBase pointerBase = Isolates.getHeapBase((Isolate)CurrentIsolate.getIsolate());
        FreeListNode freeListNode = this.bf;
        while (freeListNode.isNonNull()) {
            FreeListNode freeListNode2 = freeListNode.getUnusedNext();
            EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode);
            freeListNode = freeListNode2;
        }
        return this.a(pointerBase);
    }

    @Uninterruptible(reason="Tear-down in progress.")
    protected int a(PointerBase pointerBase) {
        if (VirtualMemoryProvider.get().free(pointerBase, this.bh) != 0) {
            return 19;
        }
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateAlignedChunk(UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
        WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
        int n2 = this.a(unsignedWord, unsignedWord2, wordPointer);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)aY);
            }
            case 2: {
                throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)ba);
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
        return (Pointer)wordPointer.read();
    }

    public Pointer allocateUnalignedChunk(UnsignedWord unsignedWord) {
        WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
        int n2 = this.a(unsignedWord, EnterpriseAddressRangeCommittedMemoryProvider.getAlignmentForUnalignedChunks(), wordPointer);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)aZ);
            }
            case 2: {
                throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)bb);
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
        return (Pointer)wordPointer.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    private int a(UnsignedWord unsignedWord, UnsignedWord unsignedWord2, WordPointer wordPointer) {
        assert (unsignedWord.aboveThan(0));
        assert (unsignedWord2.aboveThan(0));
        this.bc.lockNoTransitionUnspecifiedOwner();
        try {
            Pointer pointer;
            UnsignedWord unsignedWord3;
            FreeListNode freeListNode = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode2 = (FreeListNode)WordFactory.nullPointer();
            UnsignedWord unsignedWord4 = UnsignedUtils.MAX_VALUE;
            FreeListNode freeListNode3 = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode4 = this.bd;
            while (freeListNode4.isNonNull()) {
                unsignedWord3 = freeListNode4.getSize();
                if (unsignedWord3.aboveOrEqual(unsignedWord) && unsignedWord3.belowThan(unsignedWord4)) {
                    pointer = PointerUtils.roundUp((PointerBase)freeListNode4.getStart(), (UnsignedWord)unsignedWord2).subtract((UnsignedWord)freeListNode4.getStart());
                    if (unsignedWord3.subtract(unsignedWord).aboveOrEqual((UnsignedWord)pointer)) {
                        freeListNode2 = freeListNode3;
                        freeListNode = freeListNode4;
                        unsignedWord4 = unsignedWord3;
                        if (unsignedWord3.equal(unsignedWord)) break;
                    }
                }
                freeListNode3 = freeListNode4;
                freeListNode4 = freeListNode4.getAllocNext();
            }
            if (freeListNode.isNull()) {
                wordPointer.write((WordBase)WordFactory.nullPointer());
                int n2 = 1;
                return n2;
            }
            freeListNode3 = this.getGranularity();
            freeListNode4 = freeListNode.getStart();
            assert (PointerUtils.isAMultiple((PointerBase)freeListNode4, (UnsignedWord)freeListNode3));
            assert (UnsignedUtils.isAMultiple((UnsignedWord)unsignedWord4, (UnsignedWord)freeListNode3));
            unsignedWord3 = PointerUtils.roundUp((PointerBase)freeListNode4, (UnsignedWord)unsignedWord2);
            pointer = PointerUtils.roundDown((PointerBase)unsignedWord3, (UnsignedWord)freeListNode3);
            Pointer pointer2 = PointerUtils.roundUp((PointerBase)unsignedWord3.add(unsignedWord), (UnsignedWord)freeListNode3);
            Pointer pointer3 = pointer2.subtract((UnsignedWord)pointer);
            assert (pointer.aboveOrEqual((UnsignedWord)freeListNode4) && pointer2.belowOrEqual((UnsignedWord)freeListNode4.add(unsignedWord4)));
            int n3 = 3;
            Pointer pointer4 = VirtualMemoryProvider.get().commit((PointerBase)pointer, (UnsignedWord)pointer3, 3);
            if (pointer4.isNull()) {
                wordPointer.write((WordBase)WordFactory.nullPointer());
                int n4 = 2;
                return n4;
            }
            VMError.guarantee((boolean)pointer4.equal((UnsignedWord)pointer), (String)"Must not be mapped anywhere else.");
            Pointer pointer5 = pointer.subtract((UnsignedWord)freeListNode4);
            Pointer pointer6 = freeListNode4.add(unsignedWord4).subtract((UnsignedWord)pointer2);
            boolean bl2 = false;
            if (pointer5.aboveThan(0) && pointer6.aboveThan(0)) {
                if (EnterpriseAddressRangeCommittedMemoryProvider.a((UnsignedWord)pointer5)) {
                    this.b(freeListNode, pointer2, (UnsignedWord)pointer6);
                    this.d(freeListNode, freeListNode.getStart(), (UnsignedWord)pointer5);
                } else {
                    this.a(freeListNode, (UnsignedWord)pointer5);
                    this.d(freeListNode, pointer2, (UnsignedWord)pointer6);
                }
            } else if (pointer6.aboveThan(0)) {
                this.d(freeListNode, pointer2, (UnsignedWord)pointer6);
            } else if (pointer5.aboveThan(0)) {
                this.d(freeListNode, freeListNode.getStart(), (UnsignedWord)pointer5);
            } else {
                bl2 = true;
            }
            if (bl2 || !EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode.getSize())) {
                this.c(freeListNode, freeListNode2);
            }
            if (bl2) {
                this.d(freeListNode);
                EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode);
                freeListNode = (FreeListNode)WordFactory.nullPointer();
            }
            wordPointer.write((WordBase)unsignedWord3);
            int n5 = 0;
            return n5;
        }
        finally {
            this.bc.unlockNoTransitionUnspecifiedOwner();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, UnsignedWord unsignedWord) {
        FreeListNode freeListNode2 = this.b(freeListNode.getStart(), unsignedWord);
        this.a(freeListNode2, freeListNode.getCommittedStart(), freeListNode.getCommittedEnd());
        this.a(freeListNode2, freeListNode.getUnusedPrevious());
        assert (!EnterpriseAddressRangeCommittedMemoryProvider.a(unsignedWord));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void b(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        FreeListNode freeListNode2 = this.b(pointer, unsignedWord);
        this.a(freeListNode2, freeListNode.getCommittedStart(), freeListNode.getCommittedEnd());
        this.a(freeListNode2, freeListNode);
        if (EnterpriseAddressRangeCommittedMemoryProvider.a(unsignedWord)) {
            this.b(freeListNode2, freeListNode);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, FreeListNode freeListNode2) {
        FreeListNode freeListNode3;
        assert (freeListNode.isNonNull());
        assert (freeListNode.getUnusedNext().isNull());
        assert (freeListNode.getUnusedPrevious().isNull());
        if (freeListNode2.isNull()) {
            freeListNode3 = this.bf;
            this.bf = freeListNode;
        } else {
            freeListNode3 = freeListNode2.getUnusedNext();
            freeListNode2.setUnusedNext(freeListNode);
            freeListNode.setUnusedPrevious(freeListNode2);
        }
        if (freeListNode3.isNonNull()) {
            freeListNode3.setUnusedPrevious(freeListNode);
            freeListNode.setUnusedNext(freeListNode3);
        }
        ++this.bg;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void d(FreeListNode freeListNode) {
        assert (freeListNode.isNonNull());
        FreeListNode freeListNode2 = freeListNode.getUnusedNext();
        FreeListNode freeListNode3 = freeListNode.getUnusedPrevious();
        if (freeListNode2.isNonNull()) {
            freeListNode2.setUnusedPrevious(freeListNode3);
        }
        if (freeListNode == this.bf) {
            this.bf = freeListNode2;
        } else {
            freeListNode3.setUnusedNext(freeListNode2);
        }
        --this.bg;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void b(FreeListNode freeListNode, FreeListNode freeListNode2) {
        assert (freeListNode.isNonNull());
        assert (freeListNode.getAllocNext().isNull());
        if (freeListNode2.isNull()) {
            freeListNode.setAllocNext(this.bd);
            this.bd = freeListNode;
        } else {
            freeListNode.setAllocNext(freeListNode2.getAllocNext());
            freeListNode2.setAllocNext(freeListNode);
        }
        ++this.be;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void c(FreeListNode freeListNode, FreeListNode freeListNode2) {
        assert (freeListNode.isNonNull());
        if (freeListNode == this.bd) {
            assert (freeListNode2.isNull());
            this.bd = freeListNode.getAllocNext();
        } else {
            freeListNode2.setAllocNext(freeListNode.getAllocNext());
        }
        freeListNode.setAllocNext((FreeListNode)WordFactory.nullPointer());
        --this.be;
    }

    public boolean areUnalignedChunksZeroed() {
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase pointerBase, UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
        this.d((Pointer)pointerBase, unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase pointerBase, UnsignedWord unsignedWord) {
        this.d((Pointer)pointerBase, unsignedWord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    private void d(Pointer pointer, UnsignedWord unsignedWord) {
        assert (pointer.isNonNull());
        assert (unsignedWord.aboveThan(0));
        this.bc.lockNoTransition();
        try {
            FreeListNode freeListNode;
            boolean bl2;
            FreeListNode freeListNode2;
            UnsignedWord unsignedWord2 = this.getGranularity();
            Pointer pointer2 = PointerUtils.roundDown((PointerBase)pointer, (UnsignedWord)unsignedWord2);
            FreeListNode freeListNode3 = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode4 = this.bd;
            while (freeListNode4.isNonNull() && freeListNode4.getStart().belowThan((UnsignedWord)pointer2)) {
                freeListNode3 = freeListNode4;
                freeListNode4 = freeListNode4.getAllocNext();
            }
            FreeListNode freeListNode5 = freeListNode3;
            FreeListNode freeListNode6 = freeListNode2 = freeListNode5.isNull() ? this.bf : freeListNode5.getUnusedNext();
            while (freeListNode2.isNonNull() && freeListNode2.getStart().belowThan((UnsignedWord)pointer2)) {
                freeListNode5 = freeListNode2;
                freeListNode2 = freeListNode2.getUnusedNext();
            }
            Pointer pointer3 = PointerUtils.roundUp((PointerBase)pointer.add(unsignedWord), (UnsignedWord)unsignedWord2);
            Pointer pointer4 = pointer3.subtract((UnsignedWord)pointer2);
            assert (pointer4.aboveOrEqual(unsignedWord));
            assert (freeListNode5.isNull() || pointer2.aboveOrEqual((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode5)));
            assert (freeListNode2.isNull() || pointer3.belowOrEqual((UnsignedWord)freeListNode2.getStart()));
            boolean bl3 = freeListNode5.isNonNull() && EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode5).equal((UnsignedWord)pointer2);
            boolean bl4 = bl2 = freeListNode2.isNonNull() && pointer3.equal((UnsignedWord)freeListNode2.getStart());
            if (bl3) {
                this.c(freeListNode5, pointer2, (UnsignedWord)pointer4);
                freeListNode = freeListNode5;
                if (bl2) {
                    this.c(freeListNode, freeListNode2.getStart(), freeListNode2.getSize());
                    this.a(freeListNode, freeListNode2.getCommittedStart(), freeListNode2.getCommittedEnd());
                    if (freeListNode4 == freeListNode2) {
                        freeListNode4 = freeListNode4.getAllocNext();
                        this.c(freeListNode2, freeListNode3);
                    }
                    this.d(freeListNode2);
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode2);
                    freeListNode2 = (FreeListNode)WordFactory.nullPointer();
                }
            } else if (bl2) {
                this.c(freeListNode2, pointer2, (UnsignedWord)pointer4);
                freeListNode = freeListNode2;
            } else {
                FreeListNode freeListNode7 = this.b(pointer2, (UnsignedWord)pointer4);
                this.a(freeListNode7, freeListNode5);
                freeListNode = freeListNode7;
            }
            this.a(freeListNode, pointer2, pointer2.add((UnsignedWord)pointer4));
            if (EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode.getSize()) && freeListNode != freeListNode3 && freeListNode != freeListNode4) {
                this.b(freeListNode, freeListNode3);
            }
        }
        finally {
            this.bc.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void c(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        assert (EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode).equal((UnsignedWord)pointer) || pointer.add(unsignedWord).equal((UnsignedWord)freeListNode.getStart())) : "must be adjacent";
        assert (UnsignedUtils.isAMultiple((UnsignedWord)unsignedWord, (UnsignedWord)this.getGranularity()));
        assert (unsignedWord.belowOrEqual(this.bh));
        Pointer pointer2 = (Pointer)PointerUtils.min((PointerBase)freeListNode.getStart(), (PointerBase)pointer);
        UnsignedWord unsignedWord2 = freeListNode.getSize().add(unsignedWord);
        this.a(freeListNode, pointer2, unsignedWord2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void d(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        assert (unsignedWord.belowOrEqual(this.bh));
        assert (freeListNode.getStart().equal((UnsignedWord)pointer) && unsignedWord.belowThan(freeListNode.getSize()) || freeListNode.getStart().belowThan((UnsignedWord)pointer) && EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode).equal((UnsignedWord)pointer.add(unsignedWord)));
        this.a(freeListNode, pointer, unsignedWord);
        this.c(freeListNode);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void beforeGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
        assert (!this.bc.hasOwner()) : "Must not be locked -- is mutator code holding the lock?";
        if (((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            this.H();
        }
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void afterGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void uncommitUnusedMemory() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
        assert (!this.bc.hasOwner()) : "Must not be locked";
        this.G();
    }

    private void G() {
        FreeListNode freeListNode = this.bf;
        while (freeListNode.isNonNull()) {
            Pointer pointer = freeListNode.getCommittedStart();
            if (pointer.isNonNull()) {
                assert (pointer.aboveOrEqual((UnsignedWord)freeListNode.getStart()) && freeListNode.getCommittedEnd().belowOrEqual((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)));
                Pointer pointer2 = freeListNode.getCommittedEnd().subtract((UnsignedWord)pointer);
                if (VirtualMemoryProvider.get().uncommit((PointerBase)pointer, (UnsignedWord)pointer2) != 0) {
                    Log.log().string("Uncommitting ").unsigned((WordBase)pointer2).string(" bytes of unused memory at ").hex((WordBase)pointer).string(" failed. nodeStart=").zhex((WordBase)freeListNode.getStart()).string(", nodeEnd=").zhex((WordBase)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)).newline();
                    VMError.shouldNotReachHere((String)"Uncommitting memory failed.");
                }
                freeListNode.setCommittedStart((Pointer)WordFactory.nullPointer());
                freeListNode.setCommittedEnd((Pointer)WordFactory.nullPointer());
            }
            freeListNode = freeListNode.getUnusedNext();
        }
        if (((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            this.H();
        }
    }

    private void H() {
        FreeListNode freeListNode;
        int n2 = 0;
        FreeListNode freeListNode2 = (FreeListNode)WordFactory.nullPointer();
        FreeListNode freeListNode3 = this.bf;
        while (freeListNode3.isNonNull()) {
            VMError.guarantee((boolean)freeListNode3.getUnusedPrevious().equal((ComparableWord)freeListNode2), (String)"Unused list previous-next node linkage must be consistent");
            VMError.guarantee((freeListNode2.isNull() || freeListNode3.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode2)) ? 1 : 0) != 0, (String)"Unused blocks must not be adjacent or overlapping");
            VMError.guarantee((this.e(freeListNode3) == EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode3.getSize()) ? 1 : 0) != 0, (String)"Allocatable blocks must be in the alloc list");
            ++n2;
            freeListNode2 = freeListNode3;
            freeListNode3 = freeListNode3.getUnusedNext();
        }
        VMError.guarantee(((long)n2 == this.bg ? 1 : 0) != 0, (String)"Number of unused list nodes must match recorded count");
        int n3 = 0;
        if (freeListNode2.isNonNull()) {
            FreeListNode freeListNode4 = freeListNode2;
            ++n3;
            freeListNode = freeListNode4.getUnusedPrevious();
            while (freeListNode.isNonNull()) {
                VMError.guarantee((boolean)freeListNode.getUnusedNext().equal((ComparableWord)freeListNode4), (String)"Unused list previous-next node linkage must be consistent");
                VMError.guarantee((boolean)freeListNode4.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)), (String)"Unused blocks must not be adjacent or overlapping");
                ++n3;
                freeListNode4 = freeListNode;
                freeListNode = freeListNode.getUnusedPrevious();
            }
            VMError.guarantee((freeListNode4 == this.bf ? 1 : 0) != 0, (String)"Unused list reverse iteration must terminate at list head");
        }
        VMError.guarantee((n2 == n3 ? 1 : 0) != 0, (String)"Number of unused list nodes must be the same for forward and reverse iteration");
        int n4 = 0;
        freeListNode = (FreeListNode)WordFactory.nullPointer();
        FreeListNode freeListNode5 = this.bd;
        while (freeListNode5.isNonNull()) {
            VMError.guarantee((freeListNode.isNull() || freeListNode5.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)) ? 1 : 0) != 0, (String)"Allocatable blocks must not be adjacent or overlapping");
            VMError.guarantee((boolean)EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode5.getSize()), (String)"Allocatable blocks must satisfy minimum allocatable size");
            ++n4;
            freeListNode = freeListNode5;
            freeListNode5 = freeListNode5.getAllocNext();
        }
        VMError.guarantee((this.bd.isNull() || this.bf.equal((ComparableWord)this.bd) || EnterpriseAddressRangeCommittedMemoryProvider.b(this.bf).belowOrEqual((UnsignedWord)this.bd.getStart()) ? 1 : 0) != 0, (String)"First unused block must start before first allocatable block, or be allocatable itself");
        VMError.guarantee((n4 <= n2 ? 1 : 0) != 0, (String)"Allocation list must not be longer than unused list");
        VMError.guarantee(((long)n4 == this.be ? 1 : 0) != 0, (String)"Number of allocation list nodes must match recorded count");
    }

    private boolean e(FreeListNode freeListNode) {
        FreeListNode freeListNode2 = this.bd;
        while (freeListNode2.isNonNull() && freeListNode2.getStart().belowOrEqual((UnsignedWord)freeListNode.getStart())) {
            if (freeListNode2.equal((ComparableWord)freeListNode)) {
                return true;
            }
            freeListNode2 = freeListNode2.getAllocNext();
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord I() {
        return this.bh;
    }

    @RawStructure
    private static interface FreeListNode
    extends PointerBase {
        @RawField
        public Pointer getStart();

        @RawField
        public void setStart(Pointer var1);

        @RawField
        public UnsignedWord getSize();

        @RawField
        public void setSize(UnsignedWord var1);

        @RawField
        public Pointer getCommittedStart();

        @RawField
        public void setCommittedStart(Pointer var1);

        @RawField
        public Pointer getCommittedEnd();

        @RawField
        public void setCommittedEnd(Pointer var1);

        @RawField
        public FreeListNode getAllocNext();

        @RawField
        public void setAllocNext(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedPrevious();

        @RawField
        public void setUnusedPrevious(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedNext();

        @RawField
        public void setUnusedNext(FreeListNode var1);
    }

    public static final class a {
        public static void a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2) {
            enterpriseAddressRangeCommittedMemoryProvider.b(pointer, unsignedWord, pointer2);
        }

        public static void a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bg == 1L ? 1 : 0) != 0, (String)"more than one unused node");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.be == 1L ? 1 : 0) != 0, (String)"more than one alloc node");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bd == enterpriseAddressRangeCommittedMemoryProvider.bf ? 1 : 0) != 0, (String)"different nodes");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bf.getStart().equal((UnsignedWord)enterpriseAddressRangeCommittedMemoryProvider.bi), (String)"begin is incorrect");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bf.getSize().equal(enterpriseAddressRangeCommittedMemoryProvider.bj), (String)"size is incorrect");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bf.getCommittedStart().isNull(), (String)"committed start is incorrect");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bf.getCommittedEnd().isNull(), (String)"committed end is incorrect");
        }

        public static void b(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bg == 0L ? 1 : 0) != 0, (String)"there must not be any nodes left");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.be == 0L ? 1 : 0) != 0, (String)"there must not be any nodes left");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bd.isNull(), (String)"must be null");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bf.isNull(), (String)"must be null");
        }

        public static Pointer a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
            WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            enterpriseAddressRangeCommittedMemoryProvider.a(unsignedWord, unsignedWord2, wordPointer);
            return (Pointer)wordPointer.read();
        }

        public static void a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, Pointer pointer, UnsignedWord unsignedWord) {
            enterpriseAddressRangeCommittedMemoryProvider.d(pointer, unsignedWord);
        }

        public static void c(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            enterpriseAddressRangeCommittedMemoryProvider.G();
        }
    }
}

