/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxTensorLike;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtUtil;
import ai.onnxruntime.TensorInfo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class OnnxTensor
extends OnnxTensorLike {
    private final Buffer buffer;

    OnnxTensor(long l2, long l3, TensorInfo tensorInfo) {
        this(l2, l3, tensorInfo, null);
    }

    OnnxTensor(long l2, long l3, TensorInfo tensorInfo, Buffer buffer) {
        super(l2, l3, tensorInfo);
        this.buffer = buffer;
    }

    @Override
    public OnnxValue.OnnxValueType getType() {
        return OnnxValue.OnnxValueType.ONNX_TYPE_TENSOR;
    }

    @Override
    public Object getValue() throws OrtException {
        if (this.info.isScalar()) {
            switch (this.info.type) {
                case FLOAT: {
                    return Float.valueOf(this.getFloat(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value));
                }
                case DOUBLE: {
                    return this.getDouble(OnnxRuntime.ortApiHandle, this.nativeHandle);
                }
                case UINT8: 
                case INT8: {
                    return this.getByte(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case INT16: {
                    return this.getShort(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case INT32: {
                    return this.getInt(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case INT64: {
                    return this.getLong(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case BOOL: {
                    return this.getBool(OnnxRuntime.ortApiHandle, this.nativeHandle);
                }
                case STRING: {
                    return this.getString(OnnxRuntime.ortApiHandle, this.nativeHandle);
                }
            }
            throw new OrtException("Extracting the value of an invalid Tensor.");
        }
        Object object = this.info.makeCarrier();
        this.getArray(OnnxRuntime.ortApiHandle, this.nativeHandle, object);
        if (this.info.type == OnnxJavaType.STRING && this.info.shape.length != 1) {
            return OrtUtil.reshape((String[])object, this.info.shape);
        }
        return object;
    }

    public String toString() {
        return "OnnxTensor(info=" + this.info.toString() + ")";
    }

    @Override
    public void close() {
        this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    public ByteBuffer getByteBuffer() {
        if (this.info.type != OnnxJavaType.STRING) {
            ByteBuffer byteBuffer = this.getBuffer(OnnxRuntime.ortApiHandle, this.nativeHandle);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity());
            byteBuffer2.put(byteBuffer);
            byteBuffer2.rewind();
            return byteBuffer2;
        }
        return null;
    }

    public FloatBuffer getFloatBuffer() {
        if (this.info.type == OnnxJavaType.FLOAT) {
            if (this.info.onnxType == TensorInfo.OnnxTensorType.ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT16) {
                ShortBuffer shortBuffer = this.getBuffer().asShortBuffer();
                int n2 = shortBuffer.capacity();
                FloatBuffer floatBuffer = FloatBuffer.allocate(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    floatBuffer.put(OnnxTensor.fp16ToFloat(shortBuffer.get(i2)));
                }
                floatBuffer.rewind();
                return floatBuffer;
            }
            FloatBuffer floatBuffer = this.getBuffer().asFloatBuffer();
            FloatBuffer floatBuffer2 = FloatBuffer.allocate(floatBuffer.capacity());
            floatBuffer2.put(floatBuffer);
            floatBuffer2.rewind();
            return floatBuffer2;
        }
        return null;
    }

    public DoubleBuffer getDoubleBuffer() {
        if (this.info.type == OnnxJavaType.DOUBLE) {
            DoubleBuffer doubleBuffer = this.getBuffer().asDoubleBuffer();
            DoubleBuffer doubleBuffer2 = DoubleBuffer.allocate(doubleBuffer.capacity());
            doubleBuffer2.put(doubleBuffer);
            doubleBuffer2.rewind();
            return doubleBuffer2;
        }
        return null;
    }

    public ShortBuffer getShortBuffer() {
        if (this.info.type == OnnxJavaType.INT16) {
            ShortBuffer shortBuffer = this.getBuffer().asShortBuffer();
            ShortBuffer shortBuffer2 = ShortBuffer.allocate(shortBuffer.capacity());
            shortBuffer2.put(shortBuffer);
            shortBuffer2.rewind();
            return shortBuffer2;
        }
        return null;
    }

    public IntBuffer getIntBuffer() {
        if (this.info.type == OnnxJavaType.INT32) {
            IntBuffer intBuffer = this.getBuffer().asIntBuffer();
            IntBuffer intBuffer2 = IntBuffer.allocate(intBuffer.capacity());
            intBuffer2.put(intBuffer);
            intBuffer2.rewind();
            return intBuffer2;
        }
        return null;
    }

    public LongBuffer getLongBuffer() {
        if (this.info.type == OnnxJavaType.INT64) {
            LongBuffer longBuffer = this.getBuffer().asLongBuffer();
            LongBuffer longBuffer2 = LongBuffer.allocate(longBuffer.capacity());
            longBuffer2.put(longBuffer);
            longBuffer2.rewind();
            return longBuffer2;
        }
        return null;
    }

    private ByteBuffer getBuffer() {
        return this.getBuffer(OnnxRuntime.ortApiHandle, this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private native ByteBuffer getBuffer(long var1, long var3);

    private native float getFloat(long var1, long var3, int var5) throws OrtException;

    private native double getDouble(long var1, long var3) throws OrtException;

    private native byte getByte(long var1, long var3, int var5) throws OrtException;

    private native short getShort(long var1, long var3, int var5) throws OrtException;

    private native int getInt(long var1, long var3, int var5) throws OrtException;

    private native long getLong(long var1, long var3, int var5) throws OrtException;

    private native String getString(long var1, long var3) throws OrtException;

    private native boolean getBool(long var1, long var3) throws OrtException;

    private native void getArray(long var1, long var3, Object var5) throws OrtException;

    private native void close(long var1, long var3);

    static float fp16ToFloat(short s2) {
        int n2 = (s2 & 0x8000) << 16 | (s2 & 0x7C00) + 114688 << 13 | (s2 & 0x3FF) << 13;
        return Float.intBitsToFloat(n2);
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, Object object) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, object);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, Object object) throws OrtException {
        if (!ortAllocator.isClosed()) {
            TensorInfo tensorInfo = TensorInfo.constructFromJavaArray(object);
            if (tensorInfo.type == OnnxJavaType.STRING) {
                if (tensorInfo.shape.length == 0) {
                    return new OnnxTensor(OnnxTensor.createString(OnnxRuntime.ortApiHandle, ortAllocator.handle, (String)object), ortAllocator.handle, tensorInfo);
                }
                return new OnnxTensor(OnnxTensor.createStringTensor(OnnxRuntime.ortApiHandle, ortAllocator.handle, OrtUtil.flattenString(object), tensorInfo.shape), ortAllocator.handle, tensorInfo);
            }
            if (tensorInfo.shape.length == 0 && (object = OrtUtil.convertBoxedPrimitiveToArray(tensorInfo.type, object)) == null) {
                throw new OrtException("Failed to convert a boxed primitive to an array, this is an error with the ORT Java API, please report this message & stack trace. JavaType = " + (Object)((Object)tensorInfo.type) + ", object = " + object);
            }
            return new OnnxTensor(OnnxTensor.createTensor(OnnxRuntime.ortApiHandle, ortAllocator.handle, object, tensorInfo.shape, tensorInfo.onnxType.value), ortAllocator.handle, tensorInfo);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor with a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, String[] stringArray, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, stringArray, lArray);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, String[] stringArray, long[] lArray) throws OrtException {
        if (!ortAllocator.isClosed()) {
            TensorInfo tensorInfo = new TensorInfo(lArray, OnnxJavaType.STRING, TensorInfo.OnnxTensorType.ONNX_TENSOR_ELEMENT_DATA_TYPE_STRING);
            return new OnnxTensor(OnnxTensor.createStringTensor(OnnxRuntime.ortApiHandle, ortAllocator.handle, stringArray, lArray), ortAllocator.handle, tensorInfo);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, FloatBuffer floatBuffer, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, floatBuffer, lArray);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, FloatBuffer floatBuffer, long[] lArray) throws OrtException {
        if (!ortAllocator.isClosed()) {
            OnnxJavaType onnxJavaType = OnnxJavaType.FLOAT;
            return OnnxTensor.createTensor(onnxJavaType, ortAllocator, (Buffer)floatBuffer, lArray);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, DoubleBuffer doubleBuffer, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, doubleBuffer, lArray);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, DoubleBuffer doubleBuffer, long[] lArray) throws OrtException {
        if (!ortAllocator.isClosed()) {
            OnnxJavaType onnxJavaType = OnnxJavaType.DOUBLE;
            return OnnxTensor.createTensor(onnxJavaType, ortAllocator, (Buffer)doubleBuffer, lArray);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, ByteBuffer byteBuffer, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, byteBuffer, lArray);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, ByteBuffer byteBuffer, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortAllocator, byteBuffer, lArray, OnnxJavaType.INT8);
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, ByteBuffer byteBuffer, long[] lArray, OnnxJavaType onnxJavaType) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, byteBuffer, lArray, onnxJavaType);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, ByteBuffer byteBuffer, long[] lArray, OnnxJavaType onnxJavaType) throws OrtException {
        if (!ortAllocator.isClosed()) {
            return OnnxTensor.createTensor(onnxJavaType, ortAllocator, (Buffer)byteBuffer, lArray);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, ShortBuffer shortBuffer, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, shortBuffer, lArray);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, ShortBuffer shortBuffer, long[] lArray) throws OrtException {
        if (!ortAllocator.isClosed()) {
            OnnxJavaType onnxJavaType = OnnxJavaType.INT16;
            return OnnxTensor.createTensor(onnxJavaType, ortAllocator, (Buffer)shortBuffer, lArray);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, IntBuffer intBuffer, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, intBuffer, lArray);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, IntBuffer intBuffer, long[] lArray) throws OrtException {
        if (!ortAllocator.isClosed()) {
            OnnxJavaType onnxJavaType = OnnxJavaType.INT32;
            return OnnxTensor.createTensor(onnxJavaType, ortAllocator, (Buffer)intBuffer, lArray);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment ortEnvironment, LongBuffer longBuffer, long[] lArray) throws OrtException {
        return OnnxTensor.createTensor(ortEnvironment, ortEnvironment.defaultAllocator, longBuffer, lArray);
    }

    static OnnxTensor createTensor(OrtEnvironment ortEnvironment, OrtAllocator ortAllocator, LongBuffer longBuffer, long[] lArray) throws OrtException {
        if (!ortAllocator.isClosed()) {
            OnnxJavaType onnxJavaType = OnnxJavaType.INT64;
            return OnnxTensor.createTensor(onnxJavaType, ortAllocator, (Buffer)longBuffer, lArray);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    private static OnnxTensor createTensor(OnnxJavaType onnxJavaType, OrtAllocator ortAllocator, Buffer buffer, long[] lArray) throws OrtException {
        OrtUtil.BufferTuple bufferTuple = OrtUtil.prepareBuffer(buffer, onnxJavaType);
        TensorInfo tensorInfo = TensorInfo.constructFromBuffer(bufferTuple.data, lArray, onnxJavaType);
        return new OnnxTensor(OnnxTensor.createTensorFromBuffer(OnnxRuntime.ortApiHandle, ortAllocator.handle, bufferTuple.data, bufferTuple.pos, bufferTuple.byteSize, lArray, tensorInfo.onnxType.value), ortAllocator.handle, tensorInfo, bufferTuple.data);
    }

    private static native long createTensor(long var0, long var2, Object var4, long[] var5, int var6) throws OrtException;

    private static native long createTensorFromBuffer(long var0, long var2, Buffer var4, int var5, long var6, long[] var8, int var9) throws OrtException;

    private static native long createString(long var0, long var2, String var4) throws OrtException;

    private static native long createStringTensor(long var0, long var2, Object[] var4, long[] var5) throws OrtException;
}

