/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.code.FactoryMethodHolder;
import com.oracle.svm.core.code.FactoryThrowMethodHolder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class FactoryMethodSupport {
    private final Map<AnalysisMethod, FactoryMethod> factoryMethods = new ConcurrentHashMap<AnalysisMethod, FactoryMethod>();
    private final Map<AnalysisMethod, FactoryMethod> factoryThrowMethods = new ConcurrentHashMap<AnalysisMethod, FactoryMethod>();

    public static FactoryMethodSupport singleton() {
        return (FactoryMethodSupport)ImageSingletons.lookup(FactoryMethodSupport.class);
    }

    public ResolvedJavaMethod lookup(UniverseMetaAccess metaAccess, ResolvedJavaMethod constructor, boolean throwAllocatedObject) {
        AnalysisMetaAccess aMetaAccess;
        HostedUniverse hUniverse;
        if (metaAccess instanceof HostedMetaAccess) {
            hUniverse = (HostedUniverse)metaAccess.getUniverse();
            aMetaAccess = (AnalysisMetaAccess)metaAccess.getWrapped();
        } else {
            hUniverse = null;
            aMetaAccess = (AnalysisMetaAccess)metaAccess;
        }
        AnalysisUniverse aUniverse = aMetaAccess.getUniverse();
        AnalysisMethod aConstructor = constructor instanceof HostedMethod ? ((HostedMethod)constructor).getWrapped() : (AnalysisMethod)constructor;
        VMError.guarantee(aConstructor.getDeclaringClass().isInstanceClass() && !aConstructor.getDeclaringClass().isAbstract(), "Must be a non-abstract instance class");
        Map<AnalysisMethod, FactoryMethod> methods = throwAllocatedObject ? this.factoryThrowMethods : this.factoryMethods;
        FactoryMethod factoryMethod = methods.computeIfAbsent(aConstructor, key -> {
            String name = SubstrateUtil.uniqueStubName((ResolvedJavaMethod)aConstructor);
            ResolvedJavaType[] unwrappedParameterTypes = new ResolvedJavaType[aConstructor.getSignature().getParameterCount(false)];
            for (int i = 0; i < unwrappedParameterTypes.length; ++i) {
                unwrappedParameterTypes[i] = ((AnalysisType)aConstructor.getSignature().getParameterType(i, null)).getWrapped();
            }
            ResolvedJavaType unwrappedReturnType = (throwAllocatedObject ? aMetaAccess.lookupJavaType(Void.TYPE) : aConstructor.getDeclaringClass()).getWrapped();
            SimpleSignature unwrappedSignature = new SimpleSignature((JavaType[])unwrappedParameterTypes, (JavaType)unwrappedReturnType);
            ResolvedJavaMethod unwrappedConstructor = aConstructor.getWrapped();
            ResolvedJavaType unwrappedDeclaringClass = aMetaAccess.lookupJavaType(throwAllocatedObject ? FactoryThrowMethodHolder.class : FactoryMethodHolder.class).getWrapped();
            ConstantPool unwrappedConstantPool = unwrappedConstructor.getConstantPool();
            return new FactoryMethod(name, unwrappedConstructor, unwrappedDeclaringClass, unwrappedSignature, unwrappedConstantPool, throwAllocatedObject);
        });
        AnalysisMethod aFactoryMethod = aUniverse.lookup((JavaMethod)factoryMethod);
        if (hUniverse != null) {
            return hUniverse.lookup((JavaMethod)aFactoryMethod);
        }
        return aFactoryMethod;
    }

    protected AbstractNewObjectNode createNewInstance(HostedGraphKit kit, ResolvedJavaType type, boolean fillContents) {
        return (AbstractNewObjectNode)kit.append((Node)new NewInstanceNode(type, fillContents));
    }
}

