/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Optional;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticallyRegisteredFeature
public class LoggingFeature
implements InternalFeature {
    private final boolean trace = Options.TraceLoggingFeature.getValue();
    private boolean reflectionConfigured = false;
    private Field loggersField;

    private static Optional<Module> requiredModule() {
        return ModuleLayer.boot().findModule("java.logging");
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        Boolean loggingEnabled = Options.EnableLoggingFeature.getValue();
        if (loggingEnabled.booleanValue() && LoggingFeature.requiredModule().isEmpty()) {
            throw UserError.abort("Option %s requires JDK module java.logging to be available", SubstrateOptionsParser.commandArgument(Options.EnableLoggingFeature, "+"));
        }
        return loggingEnabled;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        LoggingFeature.class.getModule().addReads(LoggingFeature.requiredModule().get());
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        try {
            ReflectionUtil.lookupMethod((Class)access.findClassByName("java.util.logging.LogManager"), (String)"getLogManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere("Reflective LogManager initialization failed", e);
        }
        this.loggersField = ((FeatureImpl.DuringSetupAccessImpl)access).findField("sun.util.logging.PlatformLogger", "loggers");
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        access.rescanRoot(this.loggersField);
        if (!this.reflectionConfigured && access.getMetaAccess().optionalLookupJavaType(a.findClassByName("java.util.logging.Logger")).isPresent()) {
            this.registerForReflection(a.findClassByName("java.util.logging.ConsoleHandler"));
            this.registerForReflection(a.findClassByName("java.util.logging.SimpleFormatter"));
            this.reflectionConfigured = true;
            access.requireAnalysisIteration();
        }
    }

    private void registerForReflection(Class<?> clazz) {
        try {
            this.trace("Registering " + String.valueOf(clazz) + " for reflection.");
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.register((Executable[])new Executable[]{clazz.getConstructor(new Class[0])});
        }
        catch (NoSuchMethodException e) {
            VMError.shouldNotReachHere(e);
        }
    }

    private void trace(String msg) {
        if (this.trace) {
            System.out.println("LoggingFeature: " + msg);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> EnableLoggingFeature = new HostedOptionKey<Boolean>(LoggingFeature.requiredModule().isPresent());
        public static final HostedOptionKey<Boolean> TraceLoggingFeature = new HostedOptionKey<Boolean>(false);
    }
}

