/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.thread.VMThreads;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.nodes.PauseNode;

public class JavaSpinLockUtils {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final int LOCKED = 1;
    private static final int UNLOCKED = 0;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize(Object obj, long intFieldOffset) {
        UNSAFE.putIntVolatile(obj, intFieldOffset, 0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isLocked(Object obj, long intFieldOffset) {
        return UNSAFE.getIntOpaque(obj, intFieldOffset) != 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean tryLock(Object obj, long intFieldOffset) {
        return UNSAFE.compareAndSetInt(obj, intFieldOffset, 0, 1);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean tryLock(Object obj, long intFieldOffset, int retries) {
        if (JavaSpinLockUtils.tryLock(obj, intFieldOffset)) {
            return true;
        }
        int yields = 0;
        for (int i = 0; i < retries; ++i) {
            if (JavaSpinLockUtils.isLocked(obj, intFieldOffset)) {
                if ((i & 0xFF) == 0 && VMThreads.singleton().supportsNativeYieldAndSleep()) {
                    if (yields > 5) {
                        VMThreads.singleton().nativeSleep(1);
                        continue;
                    }
                    VMThreads.singleton().yield();
                    ++yields;
                    continue;
                }
                PauseNode.pause();
                continue;
            }
            if (!JavaSpinLockUtils.tryLock(obj, intFieldOffset)) continue;
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="This method does not do a transition, so the whole critical section must be uninterruptible.", callerMustBe=true)
    public static void lockNoTransition(Object obj, long intFieldOffset) {
        while (!JavaSpinLockUtils.tryLock(obj, intFieldOffset, Integer.MAX_VALUE)) {
        }
    }

    @Uninterruptible(reason="The whole critical section must be uninterruptible.", callerMustBe=true)
    public static void unlock(Object obj, long intFieldOffset) {
        UNSAFE.putIntVolatile(obj, intFieldOffset, 0);
    }
}

