/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrGCName;
import com.oracle.svm.core.jfr.JfrGCNames;
import com.oracle.svm.core.jfr.JfrSerializer;
import com.oracle.svm.core.jfr.JfrType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrGCNameSerializer
implements JfrSerializer {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrGCNameSerializer() {
    }

    @Override
    public void write(JfrChunkWriter writer) {
        JfrGCName[] gcNames = JfrGCNames.singleton().getNames();
        writer.writeCompressedLong(JfrType.GCName.getId());
        writer.writeCompressedLong(gcNames.length);
        for (JfrGCName name : gcNames) {
            writer.writeCompressedLong(name.getId());
            writer.writeString(name.getName());
        }
    }
}

