/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.VMOperationInfo;
import com.oracle.svm.core.thread.VMOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class VMOperationInfos {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final HashMap<VMOperationKey, VMOperationInfo> hostedMap = new HashMap();
    @UnknownObjectField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    static String[] names = new String[0];

    @Fold
    public static VMOperationInfos singleton() {
        return (VMOperationInfos)ImageSingletons.lookup(VMOperationInfos.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Fold
    public static VMOperationInfo get(Class<? extends VMOperation> clazz, String name, VMOperation.SystemEffect systemEffect) {
        HashMap<VMOperationKey, VMOperationInfo> hashMap = hostedMap;
        synchronized (hashMap) {
            VMOperationKey key = new VMOperationKey(clazz, name);
            VMOperationInfo result = hostedMap.get(key);
            if (result == null) {
                int id = hostedMap.size();
                result = new VMOperationInfo(id, clazz, name, systemEffect);
                hostedMap.put(key, result);
            }
            return result;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void cacheNames() {
        names = new String[hostedMap.size()];
        for (Map.Entry<VMOperationKey, VMOperationInfo> entry : hostedMap.entrySet()) {
            VMOperationInfos.names[entry.getValue().getId()] = entry.getKey().getName();
        }
    }

    public static String[] getNames() {
        return names;
    }

    private static class VMOperationKey {
        private final Class<? extends VMOperation> clazz;
        private final String name;

        VMOperationKey(Class<? extends VMOperation> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VMOperationKey that = (VMOperationKey)o;
            return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.name);
        }
    }
}

