/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.stackvalue.AbstractStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_8)
public class LateStackValueNode
extends AbstractStackValueNode {
    public static final NodeClass<LateStackValueNode> TYPE = NodeClass.create(LateStackValueNode.class);
    @Node.Input
    protected ValueNode sizeInBytes;

    protected LateStackValueNode(ValueNode sizeInBytes, int alignmentInBytes, StackValueNode.StackSlotIdentity slotIdentity, boolean checkVirtualThread) {
        super(TYPE, alignmentInBytes, slotIdentity, checkVirtualThread);
        this.sizeInBytes = sizeInBytes;
    }

    public static LateStackValueNode create(ValueNode sizeInBytes, ResolvedJavaMethod method, int bci, boolean disallowVirtualThread) {
        int alignmentInBytes = ConfigurationValues.getTarget().stackAlignment;
        StackValueNode.StackSlotIdentity slotIdentity = LateStackValueNode.createStackSlotIdentity(method, bci);
        return new LateStackValueNode(sizeInBytes, alignmentInBytes, slotIdentity, LateStackValueNode.needsVirtualThreadCheck(method, disallowVirtualThread));
    }
}

