/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.nodes.DeoptTestNode;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class DeoptTestSnippets
extends SubstrateTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo deoptTest;

    @Snippet
    protected static void deoptTestSnippet() {
        SubstrateIntrinsics.runtimeCall(DeoptTester.DEOPTTEST);
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new DeoptTestSnippets(options, providers, lowerings);
    }

    private DeoptTestSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.deoptTest = this.snippet(providers, DeoptTestSnippets.class, "deoptTestSnippet", new LocationIdentity[0]);
        lowerings.put(DeoptTestNode.class, new DeoptTestLowering());
    }

    protected class DeoptTestLowering
    implements NodeLoweringProvider<DeoptTestNode> {
        protected DeoptTestLowering() {
        }

        @Override
        public void lower(DeoptTestNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(DeoptTestSnippets.this.deoptTest, node.graph().getGuardsStage(), tool.getLoweringStage());
            DeoptTestSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

