/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.polyglot.scala;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.polyglot.scala.ScalaAnalysisPlugin;
import com.oracle.svm.util.ModuleSupport;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class ScalaFeature
implements InternalFeature {
    public static final String UNSUPPORTED_SCALA_VERSION = "This is not a supported Scala version. native-image supports Scala 2.11.x and onwards.";

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return access.findClassByName("scala.Predef") != null;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ScalaFeature.initializeScalaEnumerations(access);
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"scala.Symbol"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"scala.Symbol$"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"scala.runtime.LambdaDeserialize"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"scala.runtime.StructuralCallSite"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"scala.runtime.EmptyMethodCache"});
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.EXPORT, ScalaFeature.class, (boolean)false, (String)"jdk.internal.vm.compiler", (String[])new String[]{"org.graalvm.compiler.nodes"});
    }

    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.EXPORT, ScalaFeature.class, (boolean)false, (String)"jdk.internal.vm.ci", (String[])new String[]{"jdk.vm.ci.meta"});
        if (SubstrateOptions.parseOnce() || reason.duringAnalysis()) {
            plugins.appendNodePlugin((NodePlugin)new ScalaAnalysisPlugin());
        }
    }

    private static boolean isValDef(Field[] fields, Method m) {
        return Arrays.stream(fields).anyMatch(fd -> fd.getName().equals(m.getName()) && fd.getType().equals(m.getReturnType()));
    }

    private static void initializeScalaEnumerations(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        Class scalaEnum = access.findClassByName("scala.Enumeration");
        UserError.guarantee((scalaEnum != null ? 1 : 0) != 0, (String)"%s", (Object[])new Object[]{UNSUPPORTED_SCALA_VERSION});
        Class scalaEnumVal = access.findClassByName("scala.Enumeration$Val");
        UserError.guarantee((scalaEnumVal != null ? 1 : 0) != 0, (String)"%s", (Object[])new Object[]{UNSUPPORTED_SCALA_VERSION});
        Class valueClass = access.findClassByName("scala.Enumeration$Value");
        UserError.guarantee((valueClass != null ? 1 : 0) != 0, (String)"%s", (Object[])new Object[]{UNSUPPORTED_SCALA_VERSION});
        access.findSubclasses(scalaEnum).forEach(enumClass -> {
            RuntimeReflection.registerAllDeclaredFields((Class)enumClass);
            Executable[] relevantMethods = (Method[])Arrays.stream(enumClass.getDeclaredMethods()).filter(m -> m.getParameterTypes().length == 0 && m.getDeclaringClass() != scalaEnum && valueClass.isAssignableFrom(m.getReturnType()) && ScalaFeature.isValDef(enumClass.getDeclaredFields(), m)).toArray(Method[]::new);
            RuntimeReflection.register((Executable[])relevantMethods);
            try {
                RuntimeReflection.register((Executable[])new Executable[]{scalaEnumVal.getDeclaredMethod("id", new Class[0])});
            }
            catch (NoSuchMethodException e) {
                throw UserError.abort((String)"%s", (Object[])new Object[]{UNSUPPORTED_SCALA_VERSION});
            }
        });
    }

    static class IsEnabled
    implements BooleanSupplier {
        IsEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(ScalaFeature.class);
        }
    }
}

