/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.at;
import com.oracle.svm.enterprise.gc.g1.b;
import com.oracle.svm.enterprise.gc.g1.e;
import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class i
extends ObjectHeader {
    private final int mW;
    private final int mX;
    private final int mY;
    private final int mZ;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public i() {
        assert (ReferenceAccess.singleton().haveCompressedReferences());
        this.mW = CodeUtil.log2((int)ConfigurationValues.getObjectLayout().getAlignment());
        if (at.useCompressedReferences()) {
            this.mX = 5;
            this.mY = this.mX - this.mW;
            UnsignedWord unsignedWord = WordFactory.unsigned((int)1);
            UnsignedWord unsignedWord2 = WordFactory.unsigned((int)30);
            this.mZ = NumUtil.safeToInt((long)unsignedWord.or(unsignedWord2).rawValue());
            assert (b.co() == Long.bitCount(unsignedWord2.rawValue()));
        } else {
            this.mX = 0;
            this.mY = 0;
            this.mZ = 0;
        }
    }

    @Fold
    public static i get() {
        return (i)e.get().getObjectHeader();
    }

    public int getReservedBitsMask() {
        return this.mZ;
    }

    public Word encodeAsTLABObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Word a(DynamicHub dynamicHub) {
        Word word = Word.objectToUntrackedPointer((Object)dynamicHub).subtract((UnsignedWord)KnownIntrinsics.heapBase());
        i.a(this.d((UnsignedWord)word), "must be in hub-specific address space");
        Word word2 = word.shiftLeft(this.mY);
        i.a(word2.and(this.mZ).isNull(), "all reserved bits must be zero");
        return word2;
    }

    public long encodeAsImageHeapObjectHeader(ImageHeapObject imageHeapObject, long l2) {
        assert (this.d(WordFactory.unsigned((long)l2)));
        long l3 = l2 << this.mY;
        assert ((l3 & (long)this.mZ) == 0L) : "all reserved bits must be zero";
        return l3;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer extractPotentialDynamicHubFromHeader(Word word) {
        if (at.useCompressedReferences()) {
            Word word2 = word.unsignedShiftRight(this.mX);
            UnsignedWord unsignedWord = word2.shiftLeft(this.mW);
            return KnownIntrinsics.heapBase().add(unsignedWord);
        }
        assert (this.mX == 0);
        return word.add((UnsignedWord)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsUnmanagedObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initializeHeaderOfNewObject(Pointer pointer, Word word) {
        pointer.writeWord(i.getHubOffset(), (WordBase)word, LocationIdentity.INIT_LOCATION);
        if (at.useCompressedReferences()) {
            i.a(word.and((Word)WordFactory.unsigned((long)-4294967296L)).isNull(), "the whole 32-bit mark word must be 0");
        } else {
            pointer.writeWord(i.getMarkWordOffset(), WordFactory.zero(), LocationIdentity.INIT_LOCATION);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOptionalIdentityHashField(Word word) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have a fixed identity hash code field");
            return false;
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasIdentityHashFromAddress(Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have a fixed identity hash code field");
        return false;
    }

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.", callerMustBe=true)
    public void setIdentityHashFromAddress(Pointer pointer, Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"identity hash codes are never computed from addresses");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(boolean bl2, String string) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)bl2, (String)string);
        } else assert (bl2) : string;
    }

    @Fold
    static int getMarkWordOffset() {
        return i.getHubOffset() + i.getReferenceSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean d(UnsignedWord unsignedWord) {
        UnsignedWord unsignedWord2 = this.cC();
        return unsignedWord2.aboveThan(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private UnsignedWord cC() {
        if (!at.useCompressedReferences() && this.mY == 0) {
            return UnsignedUtils.MAX_VALUE;
        }
        int n2 = ConfigurationValues.getObjectLayout().getReferenceSize();
        return WordFactory.unsigned((long)(1L << n2 * 8 - this.mY));
    }
}

