/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.posix;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageHeader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public class i
implements AuxiliaryImageProvider {
    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int loadAuxiliaryImage(Pointer pointer, UnsignedWord unsignedWord, CCharPointer cCharPointer, WordPointer wordPointer, WordPointer wordPointer2) {
        int n2 = Fcntl.NoTransitions.open((CCharPointer)cCharPointer, (int)Fcntl.O_RDONLY(), (int)0);
        if (n2 < 0) {
            return 14;
        }
        ComparableWord comparableWord = i.a(n2, AUXILIARY_IMAGE_HEADER_OFFSET + AuxiliaryImageHeader.offsetOfPrimaryImageId(), (ComparableWord)WordFactory.zero());
        if (comparableWord.notEqual(AuxiliaryImageLoader.getPrimaryImageId())) {
            Unistd.NoTransitions.close((int)n2);
            if (comparableWord.equal((ComparableWord)WordFactory.zero())) {
                return 15;
            }
            return 21;
        }
        UnsignedWord unsignedWord2 = i.a(n2, AUXILIARY_IMAGE_HEADER_OFFSET + AuxiliaryImageHeader.offsetOfImageHeapToAuxImageHeapOffset(), UnsignedUtils.MAX_VALUE);
        if (unsignedWord2.equal(UnsignedUtils.MAX_VALUE)) {
            Unistd.NoTransitions.close((int)n2);
            return 15;
        }
        UnsignedWord unsignedWord3 = i.a(n2, 128, UnsignedUtils.MAX_VALUE);
        if (unsignedWord3.equal(UnsignedUtils.MAX_VALUE)) {
            Unistd.NoTransitions.close((int)n2);
            return 15;
        }
        UnsignedWord unsignedWord4 = i.a(n2, 152, (UnsignedWord)WordFactory.zero());
        if (unsignedWord4.equal(0)) {
            Unistd.NoTransitions.close((int)n2);
            return 15;
        }
        UnsignedWord unsignedWord5 = i.a(n2, 160, (UnsignedWord)WordFactory.zero());
        if (unsignedWord5.equal(0) || unsignedWord5.belowThan(unsignedWord4)) {
            Unistd.NoTransitions.close((int)n2);
            return 15;
        }
        PointerBase pointerBase = Isolates.getHeapBase((Isolate)CurrentIsolate.getIsolate());
        Word word = ((Word)pointerBase).add(unsignedWord2);
        Pointer pointer2 = word.add(unsignedWord5);
        if (word.belowThan((UnsignedWord)pointer) || pointer2.aboveThan((UnsignedWord)pointer.add(unsignedWord))) {
            Unistd.NoTransitions.close((int)n2);
            return 16;
        }
        UnsignedWord unsignedWord6 = i.a(n2, AUXILIARY_IMAGE_HEADER_OFFSET + AuxiliaryImageHeader.offsetOfImageHeapToOriginObjectOffset(), UnsignedUtils.MAX_VALUE);
        if (unsignedWord6.equal(UnsignedUtils.MAX_VALUE)) {
            Unistd.NoTransitions.close((int)n2);
            return 15;
        }
        int n3 = 3;
        if (unsignedWord5.notEqual(unsignedWord4) && word.notEqual((UnsignedWord)VirtualMemoryProvider.get().commit((PointerBase)word, unsignedWord5, 3))) {
            Unistd.NoTransitions.close((int)n2);
            return 16;
        }
        Pointer pointer3 = VirtualMemoryProvider.get().mapFile((PointerBase)word, unsignedWord4, (WordBase)WordFactory.signed((int)n2), unsignedWord3, 3);
        Unistd.NoTransitions.close((int)n2);
        if (pointer3.isNull() || pointer3.notEqual((UnsignedWord)word)) {
            VirtualMemoryProvider.get().uncommit((PointerBase)word, unsignedWord5);
            return 16;
        }
        wordPointer.write((WordBase)word);
        wordPointer2.write((WordBase)pointer2);
        AuxiliaryImageLoader.setAuxImageLocation((Pointer)word, pointer2, unsignedWord6);
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    private static <T extends WordBase> T a(int n2, int n3, T t2) {
        SignedWord signedWord;
        if (Unistd.NoTransitions.lseek((int)n2, (SignedWord)WordFactory.signed((int)n3), (int)Unistd.SEEK_SET()).lessThan(0)) {
            return t2;
        }
        WordPointer wordPointer = (WordPointer)StackValue.get(WordPointer.class);
        Pointer pointer = (Pointer)wordPointer;
        UnsignedWord unsignedWord = WordFactory.unsigned((int)FrameAccess.wordSize());
        do {
            if ((signedWord = Unistd.NoTransitions.read((int)n2, (PointerBase)pointer, (UnsignedWord)unsignedWord)).lessOrEqual(0)) {
                Unistd.NoTransitions.close((int)n2);
                return t2;
            }
            pointer = pointer.add((UnsignedWord)signedWord);
        } while ((unsignedWord = unsignedWord.subtract((UnsignedWord)signedWord)).aboveThan(0));
        return (T)wordPointer.read();
    }

    @Override
    public int unloadAuxiliaryImage(Pointer pointer, Pointer pointer2) {
        int n2 = VirtualMemoryProvider.get().uncommit((PointerBase)pointer, (UnsignedWord)pointer2.subtract((UnsignedWord)pointer));
        AuxiliaryImageLoader.setAuxImageLocation((Pointer)WordFactory.nullPointer(), (Pointer)WordFactory.nullPointer(), (UnsignedWord)WordFactory.zero());
        return n2;
    }
}

