/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.auximage;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointErrors;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImage;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageCodeObserver;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import com.oracle.svm.enterprise.core.auximage.d;
import com.oracle.svm.enterprise.core.auximage.f;
import com.oracle.svm.enterprise.core.auximage.r;
import com.oracle.svm.enterprise.core.auximage.s;
import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class AuxiliaryImageLoader {
    private static final CGlobalData<WordPointer> df = CGlobalDataFactory.createWord((WordBase)AuxiliaryImageLoader.Z());
    private static Pointer dg;
    private static UnsignedWord dh;
    private static Pointer di;
    private static Pointer dj;
    private static volatile f dk;

    private static WordBase Z() {
        long l2;
        while ((l2 = ThreadLocalRandom.current().nextLong()) == 0L) {
        }
        return WordFactory.signed((long)l2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static ComparableWord getPrimaryImageId() {
        return (ComparableWord)((WordPointer)df.get()).read();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageReservedSpace(Pointer pointer, UnsignedWord unsignedWord) {
        VMError.guarantee((dg.isNull() && dh.equal((UnsignedWord)WordFactory.zero()) ? 1 : 0) != 0);
        dg = pointer;
        dh = unsignedWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setAuxImageLocation(Pointer pointer, Pointer pointer2, UnsignedWord unsignedWord) {
        VMError.guarantee((pointer.isNull() == pointer2.isNull() && di.isNull() == dj.isNull() ? 1 : 0) != 0, (String)"sanity");
        VMError.guarantee((di.isNull() || pointer.isNull() ? 1 : 0) != 0, (String)"Cannot replace a loaded image in-place");
        di = pointer;
        dj = pointer2;
        AuxiliaryImageLoader.b(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void b(UnsignedWord unsignedWord) {
        Object object;
        f f2 = null;
        ImageHeapInfo imageHeapInfo = null;
        if (di.isNonNull()) {
            object = KnownIntrinsics.heapBase().add(unsignedWord);
            f2 = (f)object.toObject();
            imageHeapInfo = f2.dp;
        }
        dk = f2;
        object = d.singleton();
        object.cZ = imageHeapInfo;
        object.da = true;
    }

    public static AuxiliaryImage load(File file) {
        b b2 = new b(file.getPath());
        b2.enqueue();
        if (b2.dn != null) {
            throw b2.dn;
        }
        AuxiliaryImageLoader.ad();
        return AuxiliaryImageLoader.getLoaded();
    }

    public static AuxiliaryImage getLoaded() {
        f f2 = dk;
        if (f2 == null) {
            throw new IllegalStateException("No auxiliary image has been loaded.");
        }
        return f2.do;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static f aa() {
        return dk;
    }

    public static boolean hasLoaded() {
        return dk != null;
    }

    static void ab() {
        AuxiliaryImageLoader.ac();
        AuxiliaryImageLoader.ad();
    }

    private static void ac() {
        f f2 = dk;
        if (f2 != null) {
            if (r.isSupportedInCurrentImage()) {
                if (f2.dq.length > 0) {
                    a a2 = new a(f2);
                    a2.enqueue();
                }
            } else assert (f2.dq.length == 0) : "No runtime compilation, where does the compiled code come from?";
        }
    }

    private static void ad() {
        assert (!VMOperation.isInProgressAtSafepoint());
        f f2 = dk;
        if (f2 != null && r.isSupportedInCurrentImage() && f2.dq.length > 0) {
            for (AuxiliaryImageCodeObserver auxiliaryImageCodeObserver : f2.ds) {
                auxiliaryImageCodeObserver.afterAllAuxiliaryImageCodeInstalled();
            }
        }
    }

    private AuxiliaryImageLoader() {
    }

    private static final class b
    extends JavaVMOperation {
        private final String dm;
        private RuntimeException dn;

        b(String string) {
            super(VMOperationInfos.get(b.class, (String)"Load auxiliary image", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.dm = string;
        }

        protected void operate() {
            try {
                this.ae();
            }
            catch (RuntimeException runtimeException) {
                this.dn = runtimeException;
            }
        }

        protected void ae() {
            if (dk != null) {
                throw new IllegalStateException("An auxiliary image is already loaded.");
            }
            if (dg.isNull() || dh.belowOrEqual(0)) {
                throw new IllegalStateException("No space was reserved for loading an auxiliary image during isolate creation");
            }
            WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            WordPointer wordPointer2 = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)this.dm);){
                int n2 = AuxiliaryImageProvider.get().loadAuxiliaryImage(dg, dh, cCharPointerHolder.get(), wordPointer, wordPointer2);
                if (n2 != 0) {
                    throw new RuntimeException("Auxiliary image could not be loaded: " + CEntryPointErrors.getDescription((int)n2));
                }
                AuxiliaryImageLoader.ac();
                d d2 = d.singleton();
                VMError.guarantee((di.isNonNull() && dj.isNonNull() && dk != null && d2.cZ != null && d2.da ? 1 : 0) != 0);
            }
        }
    }

    private static class a
    extends JavaVMOperation {
        private final f dl;

        a(f f2) {
            super(VMOperationInfos.get(a.class, (String)"Install auxiliary image persisted code", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.dl = f2;
        }

        protected void operate() {
            try {
                s.a(this.dl);
            }
            catch (Throwable throwable) {
                throw VMError.shouldNotReachHere((String)"Persisted code cache installation failed.", (Throwable)throwable);
            }
        }
    }
}

