/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class OnnxModelMetadata {
    private final String producerName;
    private final String graphName;
    private final String graphDescription;
    private final String domain;
    private final String description;
    private final long version;
    private final Map<String, String> customMetadata;

    OnnxModelMetadata(String string, String string2, String string3, String string4, String string5, long l2, String[] stringArray) {
        this.producerName = string == null ? "" : string;
        this.graphName = string2 == null ? "" : string2;
        this.graphDescription = string3 == null ? "" : string3;
        this.domain = string4 == null ? "" : string4;
        this.description = string5 == null ? "" : string5;
        this.version = l2;
        if (stringArray != null && stringArray.length > 0) {
            this.customMetadata = new HashMap<String, String>();
            if (stringArray.length % 2 == 1) {
                throw new IllegalStateException("Asked for keys and values, but received an odd number of elements.");
            }
            for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
                this.customMetadata.put(stringArray[i2], stringArray[i2 + 1]);
            }
        } else {
            this.customMetadata = Collections.emptyMap();
        }
    }

    OnnxModelMetadata(String string, String string2, String string3, String string4, String string5, long l2, Map<String, String> map) {
        this.producerName = string == null ? "" : string;
        this.graphName = string2 == null ? "" : string2;
        this.graphDescription = string3 == null ? "" : string3;
        this.domain = string4 == null ? "" : string4;
        this.description = string5 == null ? "" : string5;
        this.version = l2;
        this.customMetadata = map == null ? Collections.emptyMap() : map;
    }

    public OnnxModelMetadata(OnnxModelMetadata onnxModelMetadata) {
        this.producerName = onnxModelMetadata.producerName;
        this.graphName = onnxModelMetadata.graphName;
        this.graphDescription = onnxModelMetadata.graphDescription;
        this.domain = onnxModelMetadata.domain;
        this.description = onnxModelMetadata.description;
        this.version = onnxModelMetadata.version;
        this.customMetadata = onnxModelMetadata.customMetadata.isEmpty() ? Collections.emptyMap() : new HashMap<String, String>(this.getCustomMetadata());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OnnxModelMetadata onnxModelMetadata = (OnnxModelMetadata)object;
        return this.version == onnxModelMetadata.version && this.producerName.equals(onnxModelMetadata.producerName) && this.graphName.equals(onnxModelMetadata.graphName) && this.graphDescription.equals(onnxModelMetadata.graphDescription) && this.domain.equals(onnxModelMetadata.domain) && this.description.equals(onnxModelMetadata.description) && this.customMetadata.equals(onnxModelMetadata.customMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.producerName, this.graphName, this.graphDescription, this.domain, this.description, this.version, this.customMetadata);
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public String getGraphDescription() {
        return this.graphDescription;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDescription() {
        return this.description;
    }

    public long getVersion() {
        return this.version;
    }

    public Map<String, String> getCustomMetadata() {
        return Collections.unmodifiableMap(this.customMetadata);
    }

    public Optional<String> getCustomMetadataValue(String string) {
        return Optional.ofNullable(this.customMetadata.get(string));
    }

    public String toString() {
        return "OnnxModelMetadata{producerName='" + this.producerName + '\'' + ", graphName='" + this.graphName + '\'' + ", graphDescription='" + this.graphDescription + '\'' + ", domain='" + this.domain + '\'' + ", description='" + this.description + '\'' + ", version=" + this.version + ", customMetadata=" + this.customMetadata + '}';
    }
}

