/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.loader.LibraryLoader;
import com.oracle.jipher.internal.loader.LibraryLoaderContext;
import com.oracle.jipher.internal.openssl.OpenSsl;
import java.nio.file.Path;
import java.nio.file.Paths;

class InstallDirLoader
extends LibraryLoader {
    InstallDirLoader(LibraryLoaderContext cfg) {
        super(cfg);
    }

    @Override
    public OpenSsl load() {
        Path installDir = Paths.get(this.loadContext.getLibInstallDir(), new String[0]);
        DEBUG.println("Loading libraries from install dir: " + installDir);
        Path loadLib = installDir.resolve(this.loadContext.getPlatform().getLoadLibFile());
        this.loadContext.getSystemLoader().load(loadLib.toAbsolutePath().toString());
        DEBUG.println("Successfully loaded libraries from install path.");
        Path osslCnf = installDir.resolve(this.loadContext.getPlatform().getOpensslCnfFile());
        return this.loadContext.configureOpenssl(installDir.toAbsolutePath().toString(), osslCnf.toAbsolutePath().toString());
    }
}

