/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.hosted.reflect.RecordUtils;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.RuntimeProxyCreation;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import sun.reflect.annotation.ExceptionProxy;

public class ReflectionDataBuilder
extends ConditionalConfigurationRegistry
implements RuntimeReflectionSupport,
ReflectionHostedSupport {
    private AnalysisMetaAccess metaAccess;
    private AnalysisUniverse universe;
    private final SubstrateAnnotationExtractor annotationExtractor;
    private FeatureImpl.BeforeAnalysisAccessImpl analysisAccess;
    private boolean sealed;
    private final Map<Class<?>, RecordComponent[]> registeredRecordComponents = new ConcurrentHashMap();
    private final Map<Class<?>, Set<Class<?>>> innerClasses = new ConcurrentHashMap();
    private final Map<Class<?>, Integer> enabledQueriesFlags = new ConcurrentHashMap();
    private final Map<AnalysisField, Field> registeredFields = new ConcurrentHashMap<AnalysisField, Field>();
    private final Set<AnalysisField> hidingFields = ConcurrentHashMap.newKeySet();
    private final Map<AnalysisMethod, Executable> registeredMethods = new ConcurrentHashMap<AnalysisMethod, Executable>();
    private final Map<AnalysisMethod, Object> methodAccessors = new ConcurrentHashMap<AnalysisMethod, Object>();
    private final Set<AnalysisMethod> hidingMethods = ConcurrentHashMap.newKeySet();
    private final Set<DynamicHub> heapDynamicHubs = ConcurrentHashMap.newKeySet();
    private final Map<AnalysisField, Field> heapFields = new ConcurrentHashMap<AnalysisField, Field>();
    private final Map<AnalysisMethod, Executable> heapMethods = new ConcurrentHashMap<AnalysisMethod, Executable>();
    private final Map<AnalysisType, Set<String>> negativeFieldLookups = new ConcurrentHashMap<AnalysisType, Set<String>>();
    private final Map<AnalysisType, Set<AnalysisMethod.Signature>> negativeMethodLookups = new ConcurrentHashMap<AnalysisType, Set<AnalysisMethod.Signature>>();
    private final Map<AnalysisType, Set<AnalysisType[]>> negativeConstructorLookups = new ConcurrentHashMap<AnalysisType, Set<AnalysisType[]>>();
    private final Map<Type, Set<Integer>> processedTypes = new ConcurrentHashMap<Type, Set<Integer>>();
    private final Map<Class<?>, Set<Method>> pendingRecordClasses;
    private final Set<Consumer<AnalysisUniverse>> pendingRegistrations = ConcurrentHashMap.newKeySet();
    private final Map<AnnotatedElement, AnnotationValue[]> filteredAnnotations = new ConcurrentHashMap<AnnotatedElement, AnnotationValue[]>();
    private final Map<AnalysisMethod, AnnotationValue[][]> filteredParameterAnnotations = new ConcurrentHashMap<AnalysisMethod, AnnotationValue[][]>();
    private final Map<AnnotatedElement, TypeAnnotationValue[]> filteredTypeAnnotations = new ConcurrentHashMap<AnnotatedElement, TypeAnnotationValue[]>();
    private final Method getEnclosingMethod0 = ReflectionUtil.lookupMethod(Class.class, (String)"getEnclosingMethod0", (Class[])new Class[0]);
    private static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
    private static final AnnotationValue[][] NO_PARAMETER_ANNOTATIONS = new AnnotationValue[0][0];
    private static final TypeAnnotationValue[] NO_TYPE_ANNOTATIONS = new TypeAnnotationValue[0];

    ReflectionDataBuilder(SubstrateAnnotationExtractor annotationExtractor) {
        this.annotationExtractor = annotationExtractor;
        this.pendingRecordClasses = !MissingRegistrationUtils.throwMissingRegistrationErrors() ? new ConcurrentHashMap() : null;
    }

    public void duringSetup(AnalysisMetaAccess analysisMetaAccess, AnalysisUniverse analysisUniverse) {
        this.metaAccess = analysisMetaAccess;
        this.universe = analysisUniverse;
        for (Consumer<AnalysisUniverse> pendingRegistration : this.pendingRegistrations) {
            pendingRegistration.accept(this.universe);
        }
        this.pendingRegistrations.clear();
    }

    public void beforeAnalysis(FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccess) {
        this.analysisAccess = beforeAnalysisAccess;
    }

    private void register(Consumer<AnalysisUniverse> registrationCallback) {
        if (this.universe != null) {
            registrationCallback.accept(this.universe);
        } else {
            this.pendingRegistrations.add(registrationCallback);
            VMError.guarantee(this.universe == null, "There shouldn't be a race condition on Feature.duringSetup.");
        }
    }

    private void setQueryFlag(Class<?> clazz, int flag) {
        this.enabledQueriesFlags.compute(clazz, (key, oldValue) -> oldValue == null ? flag : oldValue | flag);
    }

    public void register(ConfigurationCondition condition, boolean unsafeInstantiated, Class<?> clazz) {
        this.checkNotSealed();
        this.register(analysisUniverse -> this.registerConditionalConfiguration(condition, () -> analysisUniverse.getBigbang().postTask(debug -> this.registerClass(clazz, unsafeInstantiated))));
    }

    public void registerAllClassesQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(clazz, 0x400000));
        try {
            this.register(condition, clazz.getClasses());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    public void registerAllDeclaredClassesQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(clazz, 0x800000));
        try {
            this.register(condition, clazz.getDeclaredClasses());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    private void registerClass(Class<?> clazz, boolean unsafeInstantiated) {
        if (this.shouldExcludeClass(clazz)) {
            return;
        }
        AnalysisType type = this.metaAccess.lookupJavaType(clazz);
        type.registerAsReachable((Object)"Is registered for reflection.");
        if (unsafeInstantiated) {
            type.registerAsAllocated((Object)"Is registered for reflection.");
        }
        ClassForNameSupport.registerClass(clazz);
        try {
            if (clazz.getEnclosingClass() != null) {
                this.innerClasses.computeIfAbsent(this.metaAccess.lookupJavaType(clazz.getEnclosingClass()).getJavaClass(), enclosingType -> ConcurrentHashMap.newKeySet()).add(clazz);
            }
        }
        catch (LinkageError e) {
            ReflectionDataBuilder.reportLinkingErrors(clazz, List.of(e));
        }
    }

    public void registerClassLookupException(ConfigurationCondition condition, String typeName, Throwable t) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> ClassForNameSupport.registerExceptionForClass(typeName, t));
    }

    public void registerClassLookup(ConfigurationCondition condition, String typeName) {
        this.checkNotSealed();
        try {
            this.register(condition, new Class[]{Class.forName(typeName, false, ClassLoader.getSystemClassLoader())});
        }
        catch (ClassNotFoundException e) {
            this.registerConditionalConfiguration(condition, () -> ClassForNameSupport.registerNegativeQuery(typeName));
        }
        catch (Throwable t) {
            this.registerClassLookupException(condition, typeName, t);
        }
    }

    public void registerAllRecordComponentsQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(clazz, 0x1000000));
        this.register(analysisUniverse -> this.registerConditionalConfiguration(condition, () -> analysisUniverse.getBigbang().postTask(debug -> this.registerRecordComponents(clazz))));
    }

    public void registerAllPermittedSubclassesQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> {
            this.setQueryFlag(clazz, 0x2000000);
            if (clazz.isSealed()) {
                this.register(condition, clazz.getPermittedSubclasses());
            }
        });
    }

    public void registerAllNestMembersQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> {
            this.setQueryFlag(clazz, 0x4000000);
            for (Class<?> nestMember : clazz.getNestMembers()) {
                if (nestMember == clazz) continue;
                this.register(condition, new Class[]{nestMember});
            }
        });
    }

    public void registerAllSignersQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> {
            this.setQueryFlag(clazz, 0x8000000);
            Object[] signers = clazz.getSigners();
            if (signers != null) {
                for (Object signer : signers) {
                    this.metaAccess.lookupJavaType(signer.getClass()).registerAsInHeap((Object)"signer");
                }
            }
        });
    }

    public void register(ConfigurationCondition condition, boolean queriedOnly, Executable ... executables) {
        this.checkNotSealed();
        this.register(analysisUniverse -> this.registerConditionalConfiguration(condition, () -> {
            for (Executable executable : executables) {
                analysisUniverse.getBigbang().postTask(debug -> this.registerMethod(queriedOnly, executable));
            }
        }));
    }

    public void registerAllMethodsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        this.checkNotSealed();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            Class<?> currentLambda = current;
            this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(currentLambda, 262144));
        }
        try {
            this.register(condition, queriedOnly, clazz.getMethods());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    public void registerAllDeclaredMethodsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(clazz, 524288));
        try {
            this.register(condition, queriedOnly, clazz.getDeclaredMethods());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    public void registerAllConstructorsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        this.checkNotSealed();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            Class<?> currentLambda = current;
            this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(currentLambda, 0x100000));
        }
        try {
            this.register(condition, queriedOnly, clazz.getConstructors());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    public void registerAllDeclaredConstructorsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(clazz, 0x200000));
        try {
            this.register(condition, queriedOnly, clazz.getDeclaredConstructors());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    private void registerMethod(boolean queriedOnly, Executable reflectExecutable) {
        if (SubstitutionReflectivityFilter.shouldExclude(reflectExecutable, this.metaAccess, this.universe)) {
            return;
        }
        AnalysisMethod analysisMethod = this.metaAccess.lookupJavaMethod(reflectExecutable);
        if (this.registeredMethods.put(analysisMethod, reflectExecutable) == null) {
            this.registerTypesForMethod(analysisMethod, reflectExecutable);
            AnalysisType declaringType = analysisMethod.getDeclaringClass();
            Class declaringClass = declaringType.getJavaClass();
            this.analysisAccess.registerSubtypeReachabilityHandler((access, subType) -> this.universe.getBigbang().postTask(debug -> this.checkSubtypeForOverridingMethod(analysisMethod, this.metaAccess.lookupJavaType(subType))), declaringClass);
            if (declaringType.isAnnotation() && !analysisMethod.isConstructor()) {
                this.processAnnotationMethod(queriedOnly, (Method)reflectExecutable);
            }
            if (!MissingRegistrationUtils.throwMissingRegistrationErrors() && declaringClass.isRecord()) {
                this.pendingRecordClasses.computeIfPresent(declaringClass, (clazz, unregisteredAccessors) -> {
                    if (unregisteredAccessors.remove(reflectExecutable) && unregisteredAccessors.isEmpty()) {
                        this.registerRecordComponents(declaringClass);
                    }
                    return unregisteredAccessors;
                });
            }
        }
        if (!queriedOnly) {
            this.methodAccessors.computeIfAbsent(analysisMethod, aMethod -> {
                SubstrateAccessor accessor = ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).getOrCreateAccessor(reflectExecutable);
                this.universe.getHeapScanner().rescanObject((Object)accessor);
                return accessor;
            });
        }
    }

    public void registerMethodLookup(ConfigurationCondition condition, Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        this.checkNotSealed();
        try {
            this.register(condition, true, declaringClass.getDeclaredMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            this.registerConditionalConfiguration(condition, () -> this.negativeMethodLookups.computeIfAbsent(this.metaAccess.lookupJavaType(declaringClass), key -> ConcurrentHashMap.newKeySet()).add(new AnalysisMethod.Signature(methodName, this.metaAccess.lookupJavaTypes(parameterTypes))));
        }
    }

    public void registerConstructorLookup(ConfigurationCondition condition, Class<?> declaringClass, Class<?> ... parameterTypes) {
        this.checkNotSealed();
        try {
            this.register(condition, true, declaringClass.getDeclaredConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            this.registerConditionalConfiguration(condition, () -> this.negativeConstructorLookups.computeIfAbsent(this.metaAccess.lookupJavaType(declaringClass), key -> ConcurrentHashMap.newKeySet()).add(this.metaAccess.lookupJavaTypes(parameterTypes)));
        }
    }

    public void register(ConfigurationCondition condition, boolean finalIsWritable, Field ... fields) {
        this.checkNotSealed();
        this.registerInternal(condition, false, fields);
    }

    private void registerInternal(ConfigurationCondition condition, boolean queriedOnly, Field ... fields) {
        this.register(analysisUniverse -> this.registerConditionalConfiguration(condition, () -> {
            for (Field field : fields) {
                analysisUniverse.getBigbang().postTask(debug -> this.registerField(queriedOnly, field));
            }
        }));
    }

    public void registerAllFieldsQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.registerAllFieldsQuery(condition, false, clazz);
    }

    public void registerAllFieldsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        this.checkNotSealed();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            Class<?> currentLambda = current;
            this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(currentLambda, 65536));
        }
        try {
            this.registerInternal(condition, queriedOnly, clazz.getFields());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    public void registerAllDeclaredFieldsQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.registerAllDeclaredFieldsQuery(condition, false, clazz);
    }

    public void registerAllDeclaredFieldsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.setQueryFlag(clazz, 131072));
        try {
            this.registerInternal(condition, queriedOnly, clazz.getDeclaredFields());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    private void registerField(boolean queriedOnly, Field reflectField) {
        if (SubstitutionReflectivityFilter.shouldExclude(reflectField, this.metaAccess, this.universe)) {
            return;
        }
        AnalysisField analysisField = this.metaAccess.lookupJavaField(reflectField);
        if (this.registeredFields.put(analysisField, reflectField) == null) {
            this.registerTypesForField(analysisField, reflectField, true);
            AnalysisType declaringClass = analysisField.getDeclaringClass();
            this.analysisAccess.registerSubtypeReachabilityHandler((access, subType) -> this.universe.getBigbang().postTask(debug -> this.checkSubtypeForOverridingField(analysisField, this.metaAccess.lookupJavaType(subType))), declaringClass.getJavaClass());
            if (declaringClass.isAnnotation()) {
                this.processAnnotationField(reflectField);
            }
        }
        if (!queriedOnly) {
            this.registerTypesForField(analysisField, reflectField, false);
        }
    }

    public void registerFieldLookup(ConfigurationCondition condition, Class<?> declaringClass, String fieldName) {
        this.checkNotSealed();
        try {
            this.registerInternal(condition, false, declaringClass.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            this.registerConditionalConfiguration(condition, () -> this.negativeFieldLookups.computeIfAbsent(this.metaAccess.lookupJavaType(declaringClass), key -> ConcurrentHashMap.newKeySet()).add(fieldName));
        }
    }

    private void checkNotSealed() {
        if (this.sealed) {
            throw new UnsupportedFeatureException("Too late to add classes, methods, and fields for reflective access. Registration must happen in a Feature before the analysis has finished.");
        }
    }

    private void processAnnotationMethod(boolean queriedOnly, Method method) {
        Class<?> annotationClass = method.getDeclaringClass();
        Class<?> proxyClass = Proxy.getProxyClass(annotationClass.getClassLoader(), annotationClass);
        try {
            this.register(ConfigurationCondition.create((String)proxyClass.getTypeName()), queriedOnly, proxyClass.getDeclaredMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void processAnnotationField(Field field) {
        Class<?> annotationClass = field.getDeclaringClass();
        Class<?> proxyClass = Proxy.getProxyClass(annotationClass.getClassLoader(), annotationClass);
        try {
            this.register(ConfigurationCondition.create((String)proxyClass.getTypeName()), false, proxyClass.getDeclaredField(field.getName()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void checkSubtypeForOverridingField(AnalysisField field, AnalysisType subtype) {
        try {
            ResolvedJavaField[] subClassFields;
            for (ResolvedJavaField javaField : subClassFields = field.isStatic() ? subtype.getStaticFields() : subtype.getInstanceFields(false)) {
                AnalysisField subclassField = (AnalysisField)javaField;
                if (!subclassField.getName().equals(field.getName())) continue;
                this.hidingFields.add(subclassField);
                subclassField.getType().registerAsReachable((Object)"Is the declared type of a hiding Filed used by reflection");
            }
        }
        catch (UnsupportedFeatureException | LinkageError throwable) {
            // empty catch block
        }
    }

    private void checkSubtypeForOverridingMethod(AnalysisMethod method, AnalysisType subtype) {
        try {
            AnalysisMethod subClassMethod = subtype.findMethod(method.getName(), (Signature)method.getSignature());
            if (subClassMethod != null) {
                this.hidingMethods.add(subClassMethod);
            }
        }
        catch (UnsupportedFeatureException | LinkageError throwable) {
            // empty catch block
        }
    }

    private void registerTypesForClass(AnalysisType analysisType, Class<?> clazz) {
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(clazz::getTypeParameters));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(clazz::getGenericSuperclass));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(clazz::getGenericInterfaces));
        this.registerTypesForEnclosingMethodInfo(clazz);
        if (!MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            this.maybeRegisterRecordComponents(clazz);
        }
        this.registerTypesForAnnotations((AnnotatedElement)analysisType);
        this.registerTypesForTypeAnnotations((AnnotatedElement)analysisType);
    }

    private void registerRecordComponents(Class<?> clazz) {
        RecordComponent[] recordComponents = clazz.getRecordComponents();
        if (recordComponents == null) {
            return;
        }
        for (RecordComponent recordComponent : recordComponents) {
            this.registerTypesForRecordComponent(recordComponent);
        }
        this.registeredRecordComponents.put(clazz, recordComponents);
    }

    private void registerTypesForEnclosingMethodInfo(Class<?> clazz) {
        Executable enclosingMethodOrConstructor;
        Object[] enclosingMethodInfo = this.getEnclosingMethodInfo(clazz);
        if (enclosingMethodInfo == null) {
            return;
        }
        this.metaAccess.lookupJavaType((Class)enclosingMethodInfo[0]).registerAsReachable((Object)"Is used by the enclosing method info of an element registered for reflection.");
        try {
            enclosingMethodOrConstructor = Optional.ofNullable(clazz.getEnclosingMethod()).orElse((Method)((Object)clazz.getEnclosingConstructor()));
        }
        catch (InternalError | LinkageError | TypeNotPresentException e) {
            return;
        }
        if (enclosingMethodOrConstructor != null) {
            RuntimeReflection.registerAsQueried((Executable[])new Executable[]{enclosingMethodOrConstructor});
        }
    }

    private Object[] getEnclosingMethodInfo(Class<?> clazz) {
        try {
            return (Object[])this.getEnclosingMethod0.invoke(clazz, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof LinkageError) {
                return null;
            }
            throw VMError.shouldNotReachHere(e);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private void registerTypesForField(AnalysisField analysisField, Field reflectField, boolean queriedOnly) {
        if (!queriedOnly) {
            analysisField.registerAsUnsafeAccessed((Object)"is registered for reflection.");
        }
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectField::getGenericType));
        this.registerTypesForAnnotations((AnnotatedElement)analysisField);
        this.registerTypesForTypeAnnotations((AnnotatedElement)analysisField);
    }

    private void registerTypesForMethod(AnalysisMethod analysisMethod, Executable reflectExecutable) {
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectExecutable::getTypeParameters));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectExecutable::getGenericParameterTypes));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectExecutable::getGenericExceptionTypes));
        if (!analysisMethod.isConstructor()) {
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(((Method)reflectExecutable)::getGenericReturnType));
        }
        this.registerTypesForAnnotations((AnnotatedElement)analysisMethod);
        this.registerTypesForParameterAnnotations(analysisMethod);
        this.registerTypesForTypeAnnotations((AnnotatedElement)analysisMethod);
        if (!analysisMethod.isConstructor()) {
            this.registerTypesForAnnotationDefault(analysisMethod);
        }
    }

    private void registerTypesForGenericSignature(Type[] types) {
        this.registerTypesForGenericSignature(types, 0);
    }

    private void registerTypesForGenericSignature(Type[] types, int dimension) {
        if (types != null) {
            for (Type type : types) {
                this.registerTypesForGenericSignature(type, dimension);
            }
        }
    }

    private void registerTypesForGenericSignature(Type type) {
        this.registerTypesForGenericSignature(type, 0);
    }

    private void registerTypesForGenericSignature(Type type, int dimension) {
        try {
            if (type == null || !this.processedTypes.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet()).add(dimension)) {
                return;
            }
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException throwable) {
            // empty catch block
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (this.shouldExcludeClass(clazz)) {
                return;
            }
            if (dimension > 0) {
                this.metaAccess.lookupJavaType(clazz).getArrayClass(dimension).registerAsReachable((Object)"Is used by generic signature of element registered for reflection.");
            }
            ClassForNameSupport.registerClass(clazz);
        } else if (type instanceof TypeVariable) {
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(((TypeVariable)type)::getBounds), dimension);
        } else if (type instanceof GenericArrayType) {
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(((GenericArrayType)type)::getGenericComponentType), dimension + 1);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(parameterizedType::getActualTypeArguments));
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(parameterizedType::getRawType), dimension);
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(parameterizedType::getOwnerType));
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(wildcardType::getLowerBounds), dimension);
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(wildcardType::getUpperBounds), dimension);
        }
    }

    private void registerTypesForRecordComponent(RecordComponent recordComponent) {
        Method accessorOrNull = recordComponent.getAccessor();
        if (accessorOrNull != null) {
            this.register(ConfigurationCondition.alwaysTrue(), true, accessorOrNull);
        }
        this.registerTypesForAnnotations(recordComponent);
        this.registerTypesForTypeAnnotations(recordComponent);
    }

    private void registerTypesForAnnotations(AnnotatedElement annotatedElement) {
        if (annotatedElement != null && !this.filteredAnnotations.containsKey(annotatedElement)) {
            ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
            for (AnnotationValue annotation : this.annotationExtractor.getDeclaredAnnotationData(annotatedElement)) {
                if (!this.includeAnnotation(annotation)) continue;
                includedAnnotations.add(annotation);
                this.registerTypesForAnnotation(annotation);
            }
            this.filteredAnnotations.put(annotatedElement, includedAnnotations.toArray(new AnnotationValue[0]));
        }
    }

    private void registerTypesForParameterAnnotations(AnalysisMethod method) {
        if (method != null && !this.filteredParameterAnnotations.containsKey(method)) {
            AnnotationValue[][] parameterAnnotations = this.annotationExtractor.getParameterAnnotationData((AnnotatedElement)method);
            AnnotationValue[][] includedParameterAnnotations = new AnnotationValue[parameterAnnotations.length][];
            for (int i = 0; i < includedParameterAnnotations.length; ++i) {
                AnnotationValue[] annotations = parameterAnnotations[i];
                ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
                for (AnnotationValue annotation : annotations) {
                    if (!this.includeAnnotation(annotation)) continue;
                    includedAnnotations.add(annotation);
                    this.registerTypesForAnnotation(annotation);
                }
                includedParameterAnnotations[i] = includedAnnotations.toArray(new AnnotationValue[0]);
            }
            this.filteredParameterAnnotations.put(method, includedParameterAnnotations);
        }
    }

    private void registerTypesForTypeAnnotations(AnnotatedElement annotatedElement) {
        if (annotatedElement != null && !this.filteredTypeAnnotations.containsKey(annotatedElement)) {
            ArrayList<TypeAnnotationValue> includedTypeAnnotations = new ArrayList<TypeAnnotationValue>();
            for (TypeAnnotationValue typeAnnotation : this.annotationExtractor.getTypeAnnotationData(annotatedElement)) {
                if (!this.includeAnnotation(typeAnnotation.getAnnotationData())) continue;
                includedTypeAnnotations.add(typeAnnotation);
                this.registerTypesForAnnotation(typeAnnotation.getAnnotationData());
            }
            this.filteredTypeAnnotations.put(annotatedElement, includedTypeAnnotations.toArray(new TypeAnnotationValue[0]));
        }
    }

    private void registerTypesForAnnotationDefault(AnalysisMethod method) {
        AnnotationMemberValue annotationDefault = this.annotationExtractor.getAnnotationDefaultData((AnnotatedElement)method);
        if (annotationDefault != null) {
            this.registerTypes(annotationDefault.getTypes());
        }
    }

    private boolean includeAnnotation(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return false;
        }
        for (Class<?> type : annotationValue.getTypes()) {
            if (type != null && !SubstitutionReflectivityFilter.shouldExclude(type, this.metaAccess, this.universe)) continue;
            return false;
        }
        return true;
    }

    private void registerTypesForAnnotation(AnnotationValue annotationValue) {
        this.registerTypes(annotationValue.getTypes());
        Class<? extends Annotation> annotationType = annotationValue.getType();
        if (annotationType != null) {
            RuntimeReflection.registerAllDeclaredMethods(annotationType);
        }
    }

    private void registerTypes(Collection<Class<?>> types) {
        for (Class<?> type : types) {
            AnalysisType analysisType = this.metaAccess.lookupJavaType(type);
            analysisType.registerAsReachable((Object)"Is used by annotation of element registered for reflection.");
            if (type.isAnnotation()) {
                RuntimeProxyCreation.register((Class[])new Class[]{type});
            }
            if (!ExceptionProxy.class.isAssignableFrom(type)) continue;
            analysisType.registerAsInHeap((Object)"Is used by annotation of element registered for reflection.");
        }
    }

    private boolean shouldExcludeClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return SubstitutionReflectivityFilter.shouldExclude(clazz, this.metaAccess, this.universe);
    }

    private static <T> T queryGenericInfo(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException e) {
            return null;
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere(t);
        }
    }

    private void maybeRegisterRecordComponents(Class<?> clazz) {
        if (!clazz.isRecord()) {
            return;
        }
        Method[] accessors = RecordUtils.getRecordComponentAccessorMethods(clazz);
        ConcurrentHashMap.KeySetView unregisteredAccessors = ConcurrentHashMap.newKeySet();
        for (Method accessor2 : accessors) {
            if (SubstitutionReflectivityFilter.shouldExclude(accessor2, this.metaAccess, this.universe)) {
                return;
            }
            unregisteredAccessors.add(accessor2);
        }
        this.pendingRecordClasses.put(clazz, unregisteredAccessors);
        unregisteredAccessors.removeIf(accessor -> this.registeredMethods.containsKey(this.metaAccess.lookupJavaMethod((Executable)accessor)));
        if (unregisteredAccessors.isEmpty()) {
            this.registerRecordComponents(clazz);
        }
    }

    private static void reportLinkingErrors(Class<?> clazz, List<Throwable> errors) {
        if (errors.isEmpty()) {
            return;
        }
        String messages = errors.stream().map(e -> e.getClass().getTypeName() + ": " + e.getMessage()).distinct().collect(Collectors.joining(", "));
        LogUtils.warning((String)"Could not register complete reflection metadata for %s. Reason(s): %s.", (Object[])new Object[]{clazz.getTypeName(), messages});
    }

    protected void afterAnalysis() {
        this.sealed = true;
        this.processedTypes.clear();
        if (!MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            this.pendingRecordClasses.clear();
        }
    }

    @Override
    public Map<Class<?>, Set<Class<?>>> getReflectionInnerClasses() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.innerClasses);
    }

    public int getEnabledReflectionQueries(Class<?> clazz) {
        return this.enabledQueriesFlags.getOrDefault(clazz, 0);
    }

    @Override
    public Map<AnalysisField, Field> getReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.registeredFields);
    }

    @Override
    public Map<AnalysisMethod, Executable> getReflectionExecutables() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.registeredMethods);
    }

    @Override
    public Object getAccessor(AnalysisMethod method) {
        assert (this.sealed);
        return this.methodAccessors.get(method);
    }

    public Set<ResolvedJavaField> getHidingReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingFields);
    }

    public Set<ResolvedJavaMethod> getHidingReflectionMethods() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingMethods);
    }

    @Override
    public RecordComponent[] getRecordComponents(Class<?> type) {
        assert (this.sealed);
        return this.registeredRecordComponents.get(type);
    }

    @Override
    public void registerHeapDynamicHub(Object object, ObjectScanner.ScanReason reason) {
        DynamicHub hub = (DynamicHub)object;
        Class<?> javaClass = hub.getHostedJavaClass();
        if (this.heapDynamicHubs.add(hub)) {
            if (this.sealed) {
                throw new UnsupportedFeatureException("Registering new class for reflection when the image heap is already sealed: " + String.valueOf(javaClass));
            }
            if (!SubstitutionReflectivityFilter.shouldExclude(javaClass, this.metaAccess, this.universe)) {
                this.registerTypesForClass(this.metaAccess.lookupJavaType(javaClass), javaClass);
            }
        }
    }

    public Set<DynamicHub> getHeapDynamicHubs() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.heapDynamicHubs);
    }

    @Override
    public void registerHeapReflectionField(Field reflectField, ObjectScanner.ScanReason reason) {
        AnalysisField analysisField = this.metaAccess.lookupJavaField(reflectField);
        if (this.heapFields.put(analysisField, reflectField) == null) {
            if (this.sealed) {
                throw new UnsupportedFeatureException("Registering new field for reflection when the image heap is already sealed: " + String.valueOf(reflectField));
            }
            if (!SubstitutionReflectivityFilter.shouldExclude(reflectField, this.metaAccess, this.universe)) {
                this.registerTypesForField(analysisField, reflectField, false);
                if (analysisField.getDeclaringClass().isAnnotation()) {
                    this.processAnnotationField(reflectField);
                }
            }
        }
    }

    @Override
    public void registerHeapReflectionExecutable(Executable reflectExecutable, ObjectScanner.ScanReason reason) {
        AnalysisMethod analysisMethod = this.metaAccess.lookupJavaMethod(reflectExecutable);
        if (this.heapMethods.put(analysisMethod, reflectExecutable) == null) {
            if (this.sealed) {
                throw new UnsupportedFeatureException("Registering new method for reflection when the image heap is already sealed: " + String.valueOf(reflectExecutable));
            }
            if (!SubstitutionReflectivityFilter.shouldExclude(reflectExecutable, this.metaAccess, this.universe)) {
                this.registerTypesForMethod(analysisMethod, reflectExecutable);
                if (reflectExecutable instanceof Method && reflectExecutable.getDeclaringClass().isAnnotation()) {
                    this.processAnnotationMethod(false, (Method)reflectExecutable);
                }
            }
        }
    }

    @Override
    public Map<AnalysisField, Field> getHeapReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.heapFields);
    }

    @Override
    public Map<AnalysisMethod, Executable> getHeapReflectionExecutables() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.heapMethods);
    }

    @Override
    public Map<AnalysisType, Set<String>> getNegativeFieldQueries() {
        return Collections.unmodifiableMap(this.negativeFieldLookups);
    }

    @Override
    public Map<AnalysisType, Set<AnalysisMethod.Signature>> getNegativeMethodQueries() {
        return Collections.unmodifiableMap(this.negativeMethodLookups);
    }

    @Override
    public Map<AnalysisType, Set<AnalysisType[]>> getNegativeConstructorQueries() {
        return Collections.unmodifiableMap(this.negativeConstructorLookups);
    }

    public AnnotationValue[] getAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredAnnotations.getOrDefault(element, NO_ANNOTATIONS);
    }

    public AnnotationValue[][] getParameterAnnotationData(AnalysisMethod element) {
        assert (this.sealed);
        return this.filteredParameterAnnotations.getOrDefault(element, NO_PARAMETER_ANNOTATIONS);
    }

    public TypeAnnotationValue[] getTypeAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredTypeAnnotations.getOrDefault(element, NO_TYPE_ANNOTATIONS);
    }

    public AnnotationMemberValue getAnnotationDefaultData(AnnotatedElement element) {
        return this.annotationExtractor.getAnnotationDefaultData(element);
    }

    @Override
    public int getReflectionMethodsCount() {
        return this.registeredMethods.size();
    }

    @Override
    public int getReflectionFieldsCount() {
        return this.registeredFields.size();
    }
}

