/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisGraphDecoder;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.fieldfolding.IsStaticFinalFieldInitializedNode;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.LoadFieldNode;

public class InlineBeforeAnalysisGraphDecoderImpl
extends InlineBeforeAnalysisGraphDecoder {
    private final SimulateClassInitializerSupport simulateClassInitializerSupport = SimulateClassInitializerSupport.singleton();

    public InlineBeforeAnalysisGraphDecoderImpl(BigBang bb, InlineBeforeAnalysisPolicy policy, StructuredGraph graph, HostedProviders providers) {
        super(bb, policy, graph, providers, null);
    }

    protected Node doCanonicalizeFixedNode(InlineBeforeAnalysisGraphDecoder.InlineBeforeAnalysisMethodScope methodScope, GraphDecoder.LoopScope loopScope, Node initialNode) {
        Node node = super.doCanonicalizeFixedNode(methodScope, loopScope, initialNode);
        if (node instanceof EnsureClassInitializedNode) {
            EnsureClassInitializedNode ensureClassInitializedNode = (EnsureClassInitializedNode)node;
            node = this.handleEnsureClassInitializedNode(ensureClassInitializedNode);
        } else if (node instanceof LoadFieldNode) {
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            node = this.handleLoadFieldNode(loadFieldNode);
        } else if (node instanceof IsStaticFinalFieldInitializedNode) {
            IsStaticFinalFieldInitializedNode isStaticFinalFieldInitializedNode = (IsStaticFinalFieldInitializedNode)node;
            node = this.handleIsStaticFinalFieldInitializedNode(isStaticFinalFieldInitializedNode);
        }
        return node;
    }

    private Node handleEnsureClassInitializedNode(EnsureClassInitializedNode node) {
        AnalysisType type = (AnalysisType)node.constantTypeOrNull(this.bb.getConstantReflectionProvider());
        if (type != null) {
            if (type.isReachable()) {
                type.getInitializeMetaDataTask().ensureDone();
            } else {
                this.simulateClassInitializerSupport.trySimulateClassInitializer(this.bb, type);
            }
            if (this.simulateClassInitializerSupport.isClassInitializerSimulated(type)) {
                return null;
            }
        }
        return node;
    }

    private Node handleLoadFieldNode(LoadFieldNode node) {
        ConstantNode canonicalized = this.simulateClassInitializerSupport.tryCanonicalize(this.bb, node);
        if (canonicalized != null) {
            return canonicalized;
        }
        return node;
    }

    private Node handleIsStaticFinalFieldInitializedNode(IsStaticFinalFieldInitializedNode node) {
        AnalysisField field = (AnalysisField)node.getField();
        if (this.simulateClassInitializerSupport.isClassInitializerSimulated(field.getDeclaringClass())) {
            return ConstantNode.forBoolean((boolean)true);
        }
        return node;
    }
}

